# ReportMix

[![PyPI](https://img.shields.io/pypi/v/reportmix?style=flat-square)](https://pypi.org/project/reportmix/)
[![License](https://img.shields.io/github/license/GaelGirodon/reportmix?color=informational&style=flat-square)](https://github.com/GaelGirodon/reportmix/blob/master/LICENSE)
[![Python version](https://img.shields.io/pypi/pyversions/reportmix?style=flat-square)](https://pypi.org/project/reportmix/)
[![Build](https://img.shields.io/azure-devops/build/gaelgirodon/reportmix/10?style=flat-square)](https://dev.azure.com/gaelgirodon/reportmix)
[![Tests](https://img.shields.io/azure-devops/tests/gaelgirodon/reportmix/10?style=flat-square)](https://dev.azure.com/gaelgirodon/reportmix)

Merge reports from [multiple tools](#supported-reports) into a single file.

> :warning: This tool is only in alpha stage, not safe for production usage!

## Install

Install **ReportMix** from [PyPI](https://pypi.org/project/reportmix/):

```shell
pip install reportmix
```

## Usage

Merge reports using the command-line interface:

```shell
reportmix
```

### Arguments

| Argument                    | Description                                                | Default value |
| --------------------------- | ---------------------------------------------------------- | ------------- |
| `--help`                    | Show the help message and exit                             |               |
| `--verbose`                 | Run verbosely (display `DEBUG` logging)                    |               |
| `--output_dir OUTPUT_DIR`   | The location to write the report                           | `./`          |
| `--config_file CONFIG_FILE` | The path to the configuration file                         | `.reportmix`  |
| `--formats FORMATS`         | Report formats to be generated (`csv`, `json`, `html`)     | `html`        |
| `--fields FIELDS`           | Fields to include in the output report (CSV and HTML only) | _all_         |
| `--logo LOGO`               | The URL to the company logo to display on the HTML report  |               |

Run `reportmix --help` to show the full help message.

Plural properties (`formats`, `fields`, ...) support a single value
or a comma-separated list of items (e.g. `--formats "csv,html,json"`).

Tool-specific configuration arguments are documented in the help message
and [below](#supported-reports).

## Configuration

Configure the merging process using command-line arguments
or create a configuration file `.reportmix` in the working directory:

```ini
[global]
output_dir=target
formats=html,csv,json
fields=tool_name,tool_version,name,description,type,severity,subject_name
logo=http://acme.com/img/logo.png

[dependency_check]
report_file=target/dependency-check-report.csv

[npm_audit]
report_file=web-app/npm-audit.json

[sonarqube]
host_url=http://sonarqube.acme.corp
project_key=acme:myproject
```

This configuration can also be passed as command-line arguments:

```shell
reportmix --output_dir target --formats "html,csv,json" \
    dependency_check.report_file "target/dependency-check-report.csv" \
    npm_audit.report_file "web-app/npm-audit.json" \
    sonarqube.host_url "http://sonarqube.acme.corp" sonarqube.project_key "acme:myproject"
```

## Supported reports

Reports produced by the following tools are currently supported:

- [**Dependency-Check**](#dependency-check):
  load a vulnerability report generated by OWASP dependency check
  (CSV format only), version 5.x is recommended
- [**npm audit**](#npm-audit):
  load a security audit generated by npm-audit CLI command
  (JSON format only), npm@6 is required
- [**SonarQube**](#sonarqube):
  load code quality analysis results from a SonarQube instance,
  version 7.x is required

> Contributions to improve existing [report loaders](reportmix/loaders)
> or add new ones are welcome!

### Dependency-Check

- **Run** a Dependency-Check scan (cf. [Maven plugin](https://jeremylong.github.io/DependencyCheck/dependency-check-maven/))
  - The `CSV` report must be generated (cf. `format` property in the plugin configuration)
- **Move** the `dependency-check-report.csv` file in the working directory
  or **configure** ReportMix (`dependency_check.report_file`) to look for the file somewhere else
- :heavy_check_mark: **Run ReportMix**

> → [Dependency-Check loader](reportmix/loaders/dependency_check.py)

### npm audit

- **Run** a security audit using the [npm-audit](https://docs.npmjs.com/cli/audit) CLI command
  - Get the detailed audit report in JSON format, e.g.: `npm audit --json > npm-audit.json`
- **Move** the `npm-audit.json` file in the working directory
  or **configure** ReportMix (`npm_audit.report_file`) to look for the file somewhere else
- :heavy_check_mark: **Run ReportMix**

> → [npm audit loader](reportmix/loaders/npm_audit.py)

### SonarQube

- **Run** a SonarQube analysis (cf. [Analyzing Source Code](https://docs.sonarqube.org/latest/analysis/overview/))
- **Configure** the instance URL (`sonarqube.host_url`), the project key (`sonarqube.project_key`),
  and [authentication](https://docs.sonarqube.org/latest/extend/web-api/) settings
- :heavy_check_mark: **Run ReportMix**

> → [SonarQube loader](reportmix/loaders/sonarqube.py)

## Development

### Environment

Create the virtual environment, install dependencies from `Pipfile`
and activate the Pipenv shell:

```shell
export PIPENV_VENV_IN_PROJECT=1 # optional
pipenv install
pipenv shell
```

### Resources

- [Basic Usage of Pipenv](https://docs.pipenv.org/en/latest/basics/)
- [Tools for Writing Python CLI Applications](https://hackernoon.com/tools-for-writing-python-cli-applications-ba52db1e454f)
- [argparse — Python 3 documentation](https://docs.python.org/3/library/argparse.html)
- [configparser — Python 3 documentation](https://docs.python.org/3/library/configparser.html)
- [csv — Python 3 documentation](https://docs.python.org/3/library/csv.html)
- [logging — Python 3 documentation](https://docs.python.org/3/howto/logging.html)
- [A sample Python project](https://github.com/pypa/sampleproject)
- [Cowsay](https://github.com/VaasuDevanS/cowsay-python)
- [twine · PyPI](https://pypi.org/project/twine/)

## License

**ReportMix** is licensed under the GNU General Public License.
