# Auto generated by 'inv collect-airflow'
from airfly._vendor.airflow.models.baseoperator import BaseOperator
from airfly._vendor.airflow.models.skipmixin import SkipMixin


class BaseSQLOperator(BaseOperator):
    conn_id: "typing.Union[str, NoneType]"
    database: "typing.Union[str, NoneType]"


class SQLCheckOperator(BaseSQLOperator):
    sql: "str"
    conn_id: "typing.Union[str, NoneType]"
    database: "typing.Union[str, NoneType]"


class SQLIntervalCheckOperator(BaseSQLOperator):
    table: "str"
    metrics_thresholds: "typing.Dict[str, int]"
    date_filter_column: "typing.Union[str, NoneType]"
    days_back: "typing.SupportsAbs[int]"
    ratio_formula: "typing.Union[str, NoneType]"
    ignore_zero: "bool"
    conn_id: "typing.Union[str, NoneType]"
    database: "typing.Union[str, NoneType]"


class SQLValueCheckOperator(BaseSQLOperator):
    sql: "str"
    pass_value: "typing.Any"
    tolerance: "typing.Any"
    conn_id: "typing.Union[str, NoneType]"
    database: "typing.Union[str, NoneType]"


class SQLThresholdCheckOperator(BaseSQLOperator):
    sql: "str"
    min_threshold: "typing.Any"
    max_threshold: "typing.Any"
    conn_id: "typing.Union[str, NoneType]"
    database: "typing.Union[str, NoneType]"


class BranchSQLOperator(BaseSQLOperator, SkipMixin):
    sql: "str"
    follow_task_ids_if_true: "typing.List[str]"
    follow_task_ids_if_false: "typing.List[str]"
    conn_id: "str"
    database: "typing.Union[str, NoneType]"
    parameters: "typing.Union[typing.Mapping, typing.Iterable, NoneType]"
