# mypy-boto3-compute-optimizer<a id="mypy-boto3-compute-optimizer"></a>

[![PyPI - mypy-boto3-compute-optimizer](https://img.shields.io/pypi/v/mypy-boto3-compute-optimizer.svg?color=blue)](https://pypi.org/project/mypy-boto3-compute-optimizer)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-compute-optimizer.svg?color=blue)](https://pypi.org/project/mypy-boto3-compute-optimizer)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-compute-optimizer?color=blue)](https://pypistats.org/packages/mypy-boto3-compute-optimizer)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ComputeOptimizer 1.17.85](https://boto3.amazonaws.com/v1/documentation/api/1.17.85/reference/services/compute-optimizer.html#ComputeOptimizer)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.14.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-compute-optimizer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_compute_optimizer/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-compute-optimizer](#mypy-boto3-compute-optimizer)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `ComputeOptimizer` service.

```bash
python -m pip install boto3-stubs[compute-optimizer]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[compute-optimizer]` in your environment:
  `python -m pip install 'boto3-stubs[compute-optimizer]'`

Both type checking and auto-complete should work for `ComputeOptimizer`
service. No explicit type annotations required, write your `boto3` code as
usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[compute-optimizer]` in your environment:
  `python -m pip install 'boto3-stubs[compute-optimizer]'`

Both type checking and auto-complete should work for `ComputeOptimizer`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[compute-optimizer]` in your environment:
  `python -m pip install 'boto3-stubs[compute-optimizer]'`
- Run `mypy` as usual

Type checking should work for `ComputeOptimizer` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[compute-optimizer]` in your environment:
  `python -m pip install 'boto3-stubs[compute-optimizer]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ComputeOptimizer` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`ComputeOptimizerClient` provides annotations for
`boto3.client("compute-optimizer")`.

```python
import boto3

from mypy_boto3_compute_optimizer import ComputeOptimizerClient

client: ComputeOptimizerClient = boto3.client("compute-optimizer")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ComputeOptimizerClient = session.client("compute-optimizer")
```

### Literals<a id="literals"></a>

`mypy_boto3_compute_optimizer.literals` module contains literals extracted from
shapes that can be used in user code for type checking.

```python
from mypy_boto3_compute_optimizer.literals import (
    EBSFilterNameType,
    EBSFindingType,
    EBSMetricNameType,
    ExportableAutoScalingGroupFieldType,
    ExportableInstanceFieldType,
    ExportableLambdaFunctionFieldType,
    ExportableVolumeFieldType,
    FileFormatType,
    FilterNameType,
    FindingReasonCodeType,
    FindingType,
    InstanceRecommendationFindingReasonCodeType,
    JobFilterNameType,
    JobStatusType,
    LambdaFunctionMemoryMetricNameType,
    LambdaFunctionMemoryMetricStatisticType,
    LambdaFunctionMetricNameType,
    LambdaFunctionMetricStatisticType,
    LambdaFunctionRecommendationFilterNameType,
    LambdaFunctionRecommendationFindingReasonCodeType,
    LambdaFunctionRecommendationFindingType,
    MetricNameType,
    MetricStatisticType,
    PlatformDifferenceType,
    RecommendationSourceTypeType,
    ResourceTypeType,
    StatusType,
)

def check_value(value: EBSFilterNameType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_compute_optimizer.type_defs` module contains structures and shapes
assembled to typed dictionaries for additional type checking.

```python
from mypy_boto3_compute_optimizer.type_defs import (
    AutoScalingGroupConfigurationTypeDef,
    AutoScalingGroupRecommendationOptionTypeDef,
    AutoScalingGroupRecommendationTypeDef,
    DescribeRecommendationExportJobsResponseTypeDef,
    EBSFilterTypeDef,
    EBSUtilizationMetricTypeDef,
    ExportAutoScalingGroupRecommendationsResponseTypeDef,
    ExportDestinationTypeDef,
    ExportEBSVolumeRecommendationsResponseTypeDef,
    ExportEC2InstanceRecommendationsResponseTypeDef,
    ExportLambdaFunctionRecommendationsResponseTypeDef,
    FilterTypeDef,
    GetAutoScalingGroupRecommendationsResponseTypeDef,
    GetEBSVolumeRecommendationsResponseTypeDef,
    GetEC2InstanceRecommendationsResponseTypeDef,
    GetEC2RecommendationProjectedMetricsResponseTypeDef,
    GetEnrollmentStatusResponseTypeDef,
    GetLambdaFunctionRecommendationsResponseTypeDef,
    GetRecommendationErrorTypeDef,
    GetRecommendationSummariesResponseTypeDef,
    InstanceRecommendationOptionTypeDef,
    InstanceRecommendationTypeDef,
    JobFilterTypeDef,
    LambdaFunctionMemoryProjectedMetricTypeDef,
    LambdaFunctionMemoryRecommendationOptionTypeDef,
    LambdaFunctionRecommendationFilterTypeDef,
    LambdaFunctionRecommendationTypeDef,
    LambdaFunctionUtilizationMetricTypeDef,
    ProjectedMetricTypeDef,
    ReasonCodeSummaryTypeDef,
    RecommendationExportJobTypeDef,
    RecommendationSourceTypeDef,
    RecommendationSummaryTypeDef,
    RecommendedOptionProjectedMetricTypeDef,
    S3DestinationConfigTypeDef,
    S3DestinationTypeDef,
    SummaryTypeDef,
    UpdateEnrollmentStatusResponseTypeDef,
    UtilizationMetricTypeDef,
    VolumeConfigurationTypeDef,
    VolumeRecommendationOptionTypeDef,
    VolumeRecommendationTypeDef,
)

def get_structure() -> AutoScalingGroupConfigurationTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-compute-optimizer` version is the same as related `boto3` version
and follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-compute-optimizer docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_compute_optimizer/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
