"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceNamespace = exports.ScalableTarget = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const applicationautoscaling_generated_1 = require("./applicationautoscaling.generated");
const step_scaling_policy_1 = require("./step-scaling-policy");
const target_tracking_scaling_policy_1 = require("./target-tracking-scaling-policy");
/**
 * Define a scalable target
 */
class ScalableTarget extends core_1.Resource {
    constructor(scope, id, props) {
        super(scope, id);
        this.actions = new Array();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_ScalableTargetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, ScalableTarget);
            }
            throw error;
        }
        core_1.withResolved(props.maxCapacity, max => {
            if (max < 0) {
                throw new RangeError(`maxCapacity cannot be negative, got: ${props.maxCapacity}`);
            }
        });
        core_1.withResolved(props.minCapacity, min => {
            if (min < 0) {
                throw new RangeError(`minCapacity cannot be negative, got: ${props.minCapacity}`);
            }
        });
        core_1.withResolved(props.minCapacity, props.maxCapacity, (min, max) => {
            if (max < min) {
                throw new RangeError(`minCapacity (${props.minCapacity}) should be lower than maxCapacity (${props.maxCapacity})`);
            }
        });
        this.role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('application-autoscaling.amazonaws.com'),
        });
        const resource = new applicationautoscaling_generated_1.CfnScalableTarget(this, 'Resource', {
            maxCapacity: props.maxCapacity,
            minCapacity: props.minCapacity,
            resourceId: props.resourceId,
            roleArn: this.role.roleArn,
            scalableDimension: props.scalableDimension,
            scheduledActions: core_1.Lazy.any({ produce: () => this.actions }, { omitEmptyArray: true }),
            serviceNamespace: props.serviceNamespace,
        });
        this.scalableTargetId = resource.ref;
    }
    static fromScalableTargetId(scope, id, scalableTargetId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.scalableTargetId = scalableTargetId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a policy statement to the role's policy
     */
    addToRolePolicy(statement) {
        this.role.addToPrincipalPolicy(statement);
    }
    /**
     * Scale out or in based on time
     */
    scaleOnSchedule(id, action) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_ScalingSchedule(action);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.scaleOnSchedule);
            }
            throw error;
        }
        if (action.minCapacity === undefined && action.maxCapacity === undefined) {
            throw new Error(`You must supply at least one of minCapacity or maxCapacity, got ${JSON.stringify(action)}`);
        }
        // add a warning on synth when minute is not defined in a cron schedule
        action.schedule._bind(this);
        this.actions.push({
            scheduledActionName: id,
            schedule: action.schedule.expressionString,
            startTime: action.startTime,
            endTime: action.endTime,
            scalableTargetAction: {
                maxCapacity: action.maxCapacity,
                minCapacity: action.minCapacity,
            },
        });
    }
    /**
     * Scale out or in, in response to a metric
     */
    scaleOnMetric(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_BasicStepScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.scaleOnMetric);
            }
            throw error;
        }
        return new step_scaling_policy_1.StepScalingPolicy(this, id, { ...props, scalingTarget: this });
    }
    /**
     * Scale out or in in order to keep a metric around a target value
     */
    scaleToTrackMetric(id, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_applicationautoscaling_BasicTargetTrackingScalingPolicyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.scaleToTrackMetric);
            }
            throw error;
        }
        return new target_tracking_scaling_policy_1.TargetTrackingScalingPolicy(this, id, { ...props, scalingTarget: this });
    }
}
exports.ScalableTarget = ScalableTarget;
_a = JSII_RTTI_SYMBOL_1;
ScalableTarget[_a] = { fqn: "@aws-cdk/aws-applicationautoscaling.ScalableTarget", version: "1.180.0" };
/**
 * The service that supports Application AutoScaling
 */
var ServiceNamespace;
(function (ServiceNamespace) {
    /**
     * Elastic Container Service
     */
    ServiceNamespace["ECS"] = "ecs";
    /**
     * Elastic Map Reduce
     */
    ServiceNamespace["ELASTIC_MAP_REDUCE"] = "elasticmapreduce";
    /**
     * Elastic Compute Cloud
     */
    ServiceNamespace["EC2"] = "ec2";
    /**
     * App Stream
     */
    ServiceNamespace["APPSTREAM"] = "appstream";
    /**
     * Dynamo DB
     */
    ServiceNamespace["DYNAMODB"] = "dynamodb";
    /**
     * Relational Database Service
     */
    ServiceNamespace["RDS"] = "rds";
    /**
     * SageMaker
     */
    ServiceNamespace["SAGEMAKER"] = "sagemaker";
    /**
     * Custom Resource
     */
    ServiceNamespace["CUSTOM_RESOURCE"] = "custom-resource";
    /**
     * Lambda
     */
    ServiceNamespace["LAMBDA"] = "lambda";
    /**
     * Comprehend
     */
    ServiceNamespace["COMPREHEND"] = "comprehend";
    /**
     * Kafka
     */
    ServiceNamespace["KAFKA"] = "kafka";
    /**
     * ElastiCache
     */
    ServiceNamespace["ELASTICACHE"] = "elasticache";
})(ServiceNamespace = exports.ServiceNamespace || (exports.ServiceNamespace = {}));
//# sourceMappingURL=data:application/json;base64,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