"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesSmtpCredentials = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SesSmtpCredentials extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const secretName = `${aws_cdk_lib_1.Names.uniqueId(this)}${props.iamUserName}`;
        const sesSendPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'SesSendPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'SesAllowSendPolicy',
                    actions: ['ses:SendRawEmail'],
                    resources: ['*'],
                }),
            ],
        });
        this.iamUser = new aws_cdk_lib_1.aws_iam.User(this, 'User', {
            userName: props.iamUserName,
            managedPolicies: [
                sesSendPolicy,
            ],
        });
        aws_cdk_lib_1.Tags.of(this.iamUser).add('CfnStackIdForSesCredLibrary', aws_cdk_lib_1.Stack.of(this).stackId);
        const lambdaPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'SecretsManagerPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'SecretsManagerPolicy',
                    actions: [
                        'secretsmanager:PutSecretValue',
                        'secretsmanager:CreateSecret',
                        'secretsmanager:DeleteSecret',
                        'secretsmanager:UpdateSecret',
                        'secretsmanager:TagResource',
                        'secretsmanager:RestoreSecret',
                    ],
                    resources: [`arn:aws:secretsmanager:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:secret:${secretName}-*`],
                }),
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'IamAllowKeyManagementPolicy',
                    actions: [
                        'iam:CreateAccessKey',
                        'iam:DeleteAccessKey',
                        'iam:ListAccessKeys',
                    ],
                    resources: ['*'],
                    conditions: {
                        StringEquals: {
                            'iam:ResourceTag/CfnStackIdForSesCredLibrary': aws_cdk_lib_1.Stack.of(this).stackId,
                        },
                    },
                }),
            ],
        });
        if (props.kmsKey) {
            lambdaPolicy.addStatements(new aws_cdk_lib_1.aws_iam.PolicyStatement({
                effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                sid: 'KmsAllowKeyManagementPolicy',
                actions: [
                    'kms:Encrypt',
                    'kms:Decrypt',
                    'kms:ReEncrypt*',
                    'kms:GenerateDataKey*',
                ],
                resources: [props.kmsKey.keyArn],
            }));
        }
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                lambdaPolicy,
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'OnEventHandler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            handler: 'index.on_event',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            role,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler,
        });
        const secret = new aws_cdk_lib_1.CustomResource(this, 'SecretArn', {
            serviceToken: provider.serviceToken,
            properties: {
                UserName: props.iamUserName,
                SecretName: secretName,
                Region: aws_cdk_lib_1.Stack.of(this).region,
                Override: props.overwriteSecret ?? true,
                Restore: props.restoreSecret ?? true,
                KmsKeyId: props.kmsKey == undefined ? 'aws/secretsmanager' : props.kmsKey.keyId,
            },
        });
        secret.node.addDependency(this.iamUser);
        this.secret = aws_cdk_lib_1.aws_secretsmanager.Secret.fromSecretCompleteArn(this, 'Secret', secret.getAttString('SecretArn'));
        if (props.secretResourcePolicy) {
            new aws_cdk_lib_1.aws_secretsmanager.CfnResourcePolicy(this, 'SecretResourcePolicy', {
                secretId: this.secret.secretArn,
                resourcePolicy: props.secretResourcePolicy.toString(),
            });
        }
    }
}
exports.SesSmtpCredentials = SesSmtpCredentials;
_a = JSII_RTTI_SYMBOL_1;
SesSmtpCredentials[_a] = { fqn: "@renovosolutions/cdk-library-aws-ses-smtp-credentials.SesSmtpCredentials", version: "0.0.11" };
//# sourceMappingURL=data:application/json;base64,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