# Generated by Django 4.0.10 on 2023-06-12 12:29

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('eveonline', '0017_alliance_and_corp_names_are_not_unique'),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='Report',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=250)),
            ],
        ),
        migrations.CreateModel(
            name='ReportDataSource',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('object_id', models.PositiveIntegerField(editable=False)),
                ('content_type', models.ForeignKey(editable=False,
                 on_delete=django.db.models.deletion.CASCADE, to='contenttypes.contenttype')),
            ],
            options={
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='ReportFieldAlts',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=500)),
                ('description', models.CharField(max_length=500)),
                ('show_out_of_corp_alts', models.BooleanField(default=True)),
            ],
            options={
                'verbose_name': 'Report Field: Character Alts',
                'verbose_name_plural': 'Report Field: Character Alts',
            },
        ),
        migrations.CreateModel(
            name='ReportResults',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('results', models.TextField()),
                ('last_update', models.DateTimeField(auto_now=True)),
                ('corporation', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='eveonline.evecorporationinfo')),
                ('report', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='authstats.report')),
            ],
        ),
        migrations.CreateModel(
            name='ReportDataThrough',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('rank', models.IntegerField(default=5)),
                ('header', models.CharField(max_length=250)),
                ('pass_fail_aggregate', models.BooleanField(default=False)),
                ('report', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='authstats.report')),
                ('report_Data_source', models.ForeignKey(
                    on_delete=django.db.models.deletion.CASCADE, to='authstats.reportdatasource')),
            ],
            options={
                'verbose_name': 'Report Field',
                'verbose_name_plural': 'Report Fields',
            },
        ),
        migrations.AddField(
            model_name='report',
            name='report_fields',
            field=models.ManyToManyField(
                through='authstats.ReportDataThrough', to='authstats.reportdatasource'),
        ),
        migrations.CreateModel(
            name='AuthReportsConfiguration',
            fields=[
                ('id', models.AutoField(auto_created=True,
                 primary_key=True, serialize=False, verbose_name='ID')),
                ('holding_corps', models.ManyToManyField(
                    to='eveonline.evecorporationinfo')),
            ],
            options={
                'verbose_name': 'Site Configuration',
                'permissions': (('holding_corps', 'Can access configured holding corp reports.'), ('own_corp', 'Can access own corporations reports.'), ('own_alliance', 'Can access own alliances reports.'), ('own_state', 'Can access own states reports.')),
                'default_permissions': [],
            },
        ),
    ]
