# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sweetheart']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'sweetheart',
    'version': '0.1.1b6',
    'description': 'for creating python/html programs with ease',
    'long_description': '# Sweetheart **0.1.1**\n*get power with low-code and low-costs python programs*\n\n## A supercharged heart for the non-expert hands\n\nWhat about safety, big-data, realtime databases, responsive interfaces and AI? Sweetheart comes with the highest quality components widely used by GAFAM and others, also the best coding practices, and makes the hard stuff for you. Start from scratch, and create with ease and efficiency the apps you really need embedding reliable open-source code for processing at full power data which remains yours!\n\nSince Ubuntu 20.04 can be installed as usual softwares within Windows 10, it provides an incredible way for any organization to develop, deploy, and administrate **powerful responsive webapps including AI** on its own local network keeping high capabilities of integration with the already existing tools like databases, MS-Excel, and SAP.\n\nSweetheart provides a simple Python/Html centric approach leading you implementing best components and best coding practices. Due to the top-rated place of the Python language regarding to data processing, calculations and AI, this makes sweetheart a fast and ideal toolkit to e-volute towards **Industry4.0** precepts and innovative ideas.\n\nSweetheart is shared under the [CeCILL-C FREE SOFTWARE LICENSE AGREEMENT](https://github.com/IncredibleProgress/sweetheart.py/blob/master/LICENSE).\n\n## Get coding full power including AI at the light speed\n\nSweetheart supports you getting coding full power from scratch:\n\n- easy to learn, easy to use\n- full documentation provided\n- built-in responsive user interfaces\n- quick and clean prototyping\n- quick and clean deployment\n- ready for maintenable great code quality\n- ready for datacenters, big-data and AI\n- ready for high performances, innovation and creativity\n\n## Stick to good standards without thinking about it\n\nSweetheart is a thin-layer for going efficient and doesn\'t reinvent the wheel. It just intends to transform you stepwise in a good driver and maybe in a pilot! Due to provided components, configuration and documentation **you will learn quickly to make great python/html code** including up-to-date best practices and patterns. You won\'t learn Sweetheart itself, you will learn Python/Html real programming life like any other developer, but gradually and under control. Meaning that you don\'t need any kind of expertise to use the good things in the right way.\n\n## The highest quality components which can be adopted by newbies\n\nSweetheart delivers a stock of ready-to-use features:\n\n- backend language: [Python](https://www.python.org/)\n- database server: [RethinkDB](https://rethinkdb.com)\n- asgi framework: [Starlette](https://www.starlette.io/)\n- asynchronous webserver: [Uvicorn](https://www.uvicorn.org/)\n- fast documentation builder: [mdBook](https://rust-lang.github.io/mdBook/index.html)\n- responsive user interfaces: [Html](https://www.w3schools.com/), [JupyterLab](https://jupyter.org/)\n- web libs for going fast: [TailwindCss](https://tailwindcss.com/), [Vue](https://v3.vuejs.org/)\n\n**And all other nice things you wish** using [poetry](https://python-poetry.org/), [npm](https://docs.npmjs.com/about-npm/), [apt](https://en.wikipedia.org/wiki/APT_(software)) and [cargo](https://doc.rust-lang.org/cargo/): Sweetheart comes with the above mentioned package to support you saving time. Your are not forced to use these components, but these are what you should highly consider for starting new projects.\n\nIn a first approach consider it provides to you **an incredible full-stacked sandbox**. In a second time you will take benefits of Sweetheart as a convenient super-orchestrator for low-costs.\n\n## Keep permanently innovative capabilities\n\nThe following *sweetheart development chart* allows to evaluate coding and costs efforts for implementation of most important and innovative features at the date of today.\n\n|                                              | Coding effort | Costs effort |\n| :------------------------------------------- | :-----------: | :----------: |\n| Build responsive webapp with default libs    | FAST          | FREE         |\n| Build responsive datavisualizations          | MIDDLE        | FREE         |\n| Run MongoDB/webserver on local network       | FAST          | FREE         |\n| Improve code quality and reinforce security  | EXPERT        | CHEAP        |\n| Run MongoDB/webserver as internet services   | MIDDLE        | MODERATE     |\n| Implement AI capabilities                    | MIDDLE        | MODERATE     |\n| Implement SAP gateway                        | MIDDLE        | MODERATE     |\n| Erect and run a dedicated datacenter         | EXPERT        | HIGH         |\n\n## Realistic code examples\n\nSweetheart allows you to do all what you need with only 1 Python file and 1 Html file, that\'s it! Even more, it leads you writting in a natural low-code and minimalistic way. Neithertheless under the hood it integrates the most powerfull and innovative features at the time being like Ubuntu, Rust, RethinkDB, Jupyter, TailwindCss and Vue.\n\n### typical webpage controller written in Python\n\n``` python\nfrom sweetheart.sandbox import *\n\nconfig = set_config({\n    "webbrowser": "brave.exe",\n    "selected_DB": "test" })\n\nwebapp = HttpServer(config, set_database=True).mount(\n    Route("/", HTMLTemplate("grid.htm")) )\n\nquickstart(webapp)\n```\n\n### typical Html webpage template\n\n``` html\n<!SWEETHEART html>\n\n<python>\n# some nice python code can be given here (many thanks to Brython!)\n# SweetHeart preset also RethinkDB/WebSocket/Vue3 capabilities for you\n\ndef on_update(event):\n\n    """ this updates in realtime RethinkDB using WebSocket \n        it should be called only from html event attributes\n        e.g. <input type="text" id="row:col" v-on:keyup="update"> """\n\n    elt = event.target\n    \n    r.table("grid")\n    r.filter({"id": elt.tableId})\n    r.update({elt.tableCol: elt.value})\n\ndef on_message(event):\n\n    """ catch here WebSocket messages from the server side \n        you see, we handle directly the JavaScript event object """\n\n    console.log(event.data)\n\ndef vue_created(data):\n\n    """ this will be called as soon as the Vue3 instance is created\n        it allows you fecthing data using ReQL before html rendering\n        the data argument provides the $data object of the Vue model """\n\n    r.table("grid").setVueAttr("table")\n\ncreateVueApp({\n    "table": [],\n    "headers": ["col1","col2","col3"]\n})\n</python>\n\n<div v-cloak id="VueApp" class="m-2">\n  <h1 class="text-xl">Realtime Table</h1>\n\n  <table>\n    <thead>\n      <tr>\n        <th v-for="h in headers" class="border">{{ h }}</th>\n      </tr>\n    </thead>\n    <tbody>\n      <tr v-for="n in table.length">\n        <td v-for="h in headers" class="border">\n          <input type="text" v-bind:id="tableId(n-1,h)" v-model="table[n-1][h]" v-on:keyup="update">\n        </td>\n      </tr>\n    </tbody>\n  </table>\n</div>\n```\n\n## Install and run Sweetheart\n\n### set WSL on Windows 10\n\nDiscovering what is the WSL, have a look at the [Microsoft documentation](https://docs.microsoft.com/en-us/windows/wsl/about). Then install *Ubuntu 20.04* via the Microsoft Store. At this step installing *VS Code* and *Windows Terminal* can be recommended to you too. When done click on Ubuntu within start menu, and now *Bash* is running!\n\n### first steps with Bash\n\n1. start setting the prerequisites\n``` bash\ncurl -sSL https://raw.githubusercontent.com/IncredibleProgress/sweetheart.py/master/get-sweetheart.py | python3 -\n```\nYou can suppress the `--rethinkdb` option if you don\'t need to setup the RethinkDB repository for Ubuntu/Debian.\n\n2. then restart bash and get initial components\n``` bash\nbash\nsws --init\n```\nBeing experienced you can add extra python libs you want with `--init`. Typically you could prefer `fastapi` instead of simply `starlette`. Note too that JupyterLab is not set in too by default. This is because you could already use it by another way (e.g. within VS Code). If not you should also consider to install it with sweetheart as showed hereafter.\n\n``` bash\n# alternative examples for initial setting of sweetheart\nsws --init jupyterlab\nsws --init fastapi\nsws --init fastapi jupyterlab\n```\n\n3. at last run sweetheart for tests\n``` bash\nsws start\n```\n\nThere is here no heavy installation process which could badly interact with the operating system. Everything goes and runs safely within dedicated */home* directories. [Click-here]() for detailed informations.\n\n### get power with many additionnal resources\n\n``` bash\n# interested for calculation, machine-learning, ms-excel\nsws install science\n\n# interested for processing or scraping the web\nsws install web\n```\n\n## Epilogue: a new life starts now\n\nEven at this BETA stage, Sweetheart allows you to make a lot by yourself. Enjoy discovering and learning how coding can help and support you, using amazing raw materials widely used by GAFAM and others!\n',
    'author': 'Nicolas Champion',
    'author_email': 'champion.nicolas@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/IncredibleProgress/sweetheart.py',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
