from typing import Optional

import strawberry

from phoenix.server.api.interceptor import GqlValueMediator


@strawberry.type
class PromptResponse:
    """
    A prompt and response pair. Used to group together the input and output of a LLM
    """

    prompt: Optional[str] = strawberry.field(
        description="The prompt submitted to the LLM",
        default=GqlValueMediator(),
    )
    response: Optional[str] = strawberry.field(
        description="The response generated by the LLM",
        default=GqlValueMediator(),
    )

    def __bool__(self) -> bool:
        return bool(self.prompt) or bool(self.response)
