from typing import (
    Callable,
    Optional,
    Tuple,
    Union,
)
from werkzeug.datastructures import Authorization

class HTTPAuth:
    def __init__(
        self,
        scheme: Optional[str] = ...,
        realm: Optional[str] = ...,
        header: Optional[str] = ...,
    ) -> None: ...
    def authenticate_header(self) -> str: ...
    def authorize(
        self,
        role: Optional[Union[Tuple[str, str], Tuple[Tuple[str, str]], str]],
        user: Union[str, bool],
        auth: Optional[Authorization],
    ) -> Optional[bool]: ...
    def current_user(self) -> Optional[str]: ...
    def error_handler(self, f: Callable) -> Callable: ...
    def get_auth(self) -> Optional[Authorization]: ...
    def get_auth_password(self, auth: Optional[Authorization]) -> Optional[str]: ...
    def get_password(self, f: Callable) -> Callable: ...
    def get_user_roles(self, f: Callable) -> Callable: ...
    def login_required(
        self,
        f: Optional[Callable] = ...,
        role: Optional[Union[Tuple[str, str], Tuple[Tuple[str, str]], str]] = ...,
        optional: Optional[bool] = ...,
    ) -> Callable: ...
    def username(self) -> str: ...

class HTTPBasicAuth:
    def __init__(self, scheme: None = ..., realm: Optional[str] = ...) -> None: ...
    def authenticate(
        self, auth: Optional[Authorization], stored_password: Optional[str]
    ) -> Optional[Union[str, bool]]: ...
    def get_auth(self) -> Optional[Authorization]: ...
    def hash_password(self, f: Callable) -> Callable: ...
    def verify_password(self, f: Callable) -> Callable: ...

class HTTPDigestAuth:
    def __init__(
        self, scheme: None = ..., realm: Optional[str] = ..., use_ha1_pw: bool = ...
    ) -> None: ...
    def authenticate(
        self, auth: Optional[Authorization], stored_password_or_ha1: Optional[str]
    ) -> bool: ...
    def authenticate_header(self) -> str: ...
    def generate_ha1(self, username: str, password: str) -> str: ...
    def generate_nonce(self, f: Callable) -> Callable: ...
    def generate_opaque(self, f: Callable) -> Callable: ...
    def get_nonce(self) -> str: ...
    def get_opaque(self) -> str: ...
    def verify_nonce(self, f: Callable) -> Callable: ...
    def verify_opaque(self, f: Callable) -> Callable: ...

class HTTPTokenAuth:
    def __init__(
        self, scheme: str = ..., realm: Optional[str] = ..., header: Optional[str] = ...
    ) -> None: ...
    def authenticate(
        self, auth: Optional[Authorization], stored_password: None
    ) -> Optional[Union[str, bool]]: ...
    def verify_token(self, f: Callable) -> Callable: ...

class MultiAuth:
    def __init__(self, main_auth: HTTPBasicAuth, *args) -> None: ...
    def current_user(self) -> Optional[str]: ...
    def login_required(
        self, f: Optional[Callable] = ..., role: Optional[str] = ...
    ) -> Callable: ...
