/**
 * Zone properties for looking up the Hosted Zone.
 *
 * @stability stable
 */
export interface HostedZoneProviderProps {
    /**
     * The zone domain e.g. example.com.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Whether the zone that is being looked up is a private hosted zone.
     *
     * @default false
     * @stability stable
     */
    readonly privateZone?: boolean;
    /**
     * Specifies the ID of the VPC associated with a private hosted zone.
     *
     * If a VPC ID is provided and privateZone is false, no results will be returned
     * and an error will be raised
     *
     * @default - No VPC ID
     * @stability stable
     */
    readonly vpcId?: string;
}
