import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Route53::HealthCheck`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 * @external
 */
export interface CfnHealthCheckProps {
    /**
     * `AWS::Route53::HealthCheck.HealthCheckConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig
     * @external
     */
    readonly healthCheckConfig: CfnHealthCheck.HealthCheckConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags
     * @external
     */
    readonly healthCheckTags?: Array<CfnHealthCheck.HealthCheckTagProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 */
export declare class CfnHealthCheck extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HealthCheck";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHealthCheck;
    /**
     * @external
     * @cloudformationAttribute HealthCheckId
     */
    readonly attrHealthCheckId: string;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthcheckconfig
     * @external
     */
    healthCheckConfig: CfnHealthCheck.HealthCheckConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HealthCheck.HealthCheckTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html#cfn-route53-healthcheck-healthchecktags
     * @external
     */
    healthCheckTags: Array<CfnHealthCheck.HealthCheckTagProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::HealthCheck`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHealthCheckProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 */
export declare namespace CfnHealthCheck {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html
     * @external
     */
    interface AlarmIdentifierProperty {
        /**
         * `CfnHealthCheck.AlarmIdentifierProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnHealthCheck.AlarmIdentifierProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-alarmidentifier.html#cfn-route53-healthcheck-alarmidentifier-region
         * @external
         */
        readonly region: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 */
export declare namespace CfnHealthCheck {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html
     * @external
     */
    interface HealthCheckConfigProperty {
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.AlarmIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-alarmidentifier
         * @external
         */
        readonly alarmIdentifier?: CfnHealthCheck.AlarmIdentifierProperty | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.ChildHealthChecks`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-childhealthchecks
         * @external
         */
        readonly childHealthChecks?: string[];
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.EnableSNI`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-enablesni
         * @external
         */
        readonly enableSni?: boolean | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.FailureThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-failurethreshold
         * @external
         */
        readonly failureThreshold?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.FullyQualifiedDomainName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-fullyqualifieddomainname
         * @external
         */
        readonly fullyQualifiedDomainName?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.HealthThreshold`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-healththreshold
         * @external
         */
        readonly healthThreshold?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.IPAddress`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-ipaddress
         * @external
         */
        readonly ipAddress?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.InsufficientDataHealthStatus`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-insufficientdatahealthstatus
         * @external
         */
        readonly insufficientDataHealthStatus?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Inverted`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-inverted
         * @external
         */
        readonly inverted?: boolean | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.MeasureLatency`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-measurelatency
         * @external
         */
        readonly measureLatency?: boolean | cdk.IResolvable;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Port`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-port
         * @external
         */
        readonly port?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Regions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-regions
         * @external
         */
        readonly regions?: string[];
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.RequestInterval`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-requestinterval
         * @external
         */
        readonly requestInterval?: number;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.ResourcePath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-resourcepath
         * @external
         */
        readonly resourcePath?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.SearchString`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-searchstring
         * @external
         */
        readonly searchString?: string;
        /**
         * `CfnHealthCheck.HealthCheckConfigProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthcheckconfig.html#cfn-route53-healthcheck-healthcheckconfig-type
         * @external
         */
        readonly type: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HealthCheck`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-healthcheck.html
 * @external
 * @cloudformationResource AWS::Route53::HealthCheck
 */
export declare namespace CfnHealthCheck {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html
     * @external
     */
    interface HealthCheckTagProperty {
        /**
         * `CfnHealthCheck.HealthCheckTagProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnHealthCheck.HealthCheckTagProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-healthcheck-healthchecktag.html#cfn-route53-healthcheck-healthchecktag-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::HostedZone`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 * @external
 */
export interface CfnHostedZoneProps {
    /**
     * `AWS::Route53::HostedZone.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     * @external
     */
    readonly hostedZoneConfig?: CfnHostedZone.HostedZoneConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     * @external
     */
    readonly hostedZoneTags?: CfnHostedZone.HostedZoneTagProperty[];
    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     * @external
     */
    readonly queryLoggingConfig?: CfnHostedZone.QueryLoggingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::HostedZone.VPCs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     * @external
     */
    readonly vpcs?: Array<CfnHostedZone.VPCProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 */
export declare class CfnHostedZone extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::HostedZone";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnHostedZone;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute NameServers
     */
    readonly attrNameServers: string[];
    /**
     * `AWS::Route53::HostedZone.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-name
     * @external
     */
    name: string;
    /**
     * `AWS::Route53::HostedZone.HostedZoneConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzoneconfig
     * @external
     */
    hostedZoneConfig: CfnHostedZone.HostedZoneConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::HostedZone.HostedZoneTags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-hostedzonetags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Route53::HostedZone.QueryLoggingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-queryloggingconfig
     * @external
     */
    queryLoggingConfig: CfnHostedZone.QueryLoggingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::HostedZone.VPCs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html#cfn-route53-hostedzone-vpcs
     * @external
     */
    vpcs: Array<CfnHostedZone.VPCProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::HostedZone`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostedZoneProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 */
export declare namespace CfnHostedZone {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html
     * @external
     */
    interface HostedZoneConfigProperty {
        /**
         * `CfnHostedZone.HostedZoneConfigProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzoneconfig.html#cfn-route53-hostedzone-hostedzoneconfig-comment
         * @external
         */
        readonly comment?: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 */
export declare namespace CfnHostedZone {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetag.html
     * @external
     */
    interface HostedZoneTagProperty {
        /**
         * `CfnHostedZone.HostedZoneTagProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetag.html#cfn-route53-hostedzone-hostedzonetag-key
         * @external
         */
        readonly key: string;
        /**
         * `CfnHostedZone.HostedZoneTagProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-hostedzonetag.html#cfn-route53-hostedzone-hostedzonetag-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 */
export declare namespace CfnHostedZone {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html
     * @external
     */
    interface QueryLoggingConfigProperty {
        /**
         * `CfnHostedZone.QueryLoggingConfigProperty.CloudWatchLogsLogGroupArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-queryloggingconfig.html#cfn-route53-hostedzone-queryloggingconfig-cloudwatchlogsloggrouparn
         * @external
         */
        readonly cloudWatchLogsLogGroupArn: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::HostedZone`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-hostedzone.html
 * @external
 * @cloudformationResource AWS::Route53::HostedZone
 */
export declare namespace CfnHostedZone {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html
     * @external
     */
    interface VPCProperty {
        /**
         * `CfnHostedZone.VPCProperty.VPCId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html#cfn-route53-hostedzone-vpc-vpcid
         * @external
         */
        readonly vpcId: string;
        /**
         * `CfnHostedZone.VPCProperty.VPCRegion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-hostedzone-vpc.html#cfn-route53-hostedzone-vpc-vpcregion
         * @external
         */
        readonly vpcRegion: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::RecordSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 * @external
 */
export interface CfnRecordSetProps {
    /**
     * `AWS::Route53::RecordSet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Route53::RecordSet.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     * @external
     */
    readonly aliasTarget?: CfnRecordSet.AliasTargetProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.Comment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     * @external
     */
    readonly comment?: string;
    /**
     * `AWS::Route53::RecordSet.Failover`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     * @external
     */
    readonly failover?: string;
    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     * @external
     */
    readonly geoLocation?: CfnRecordSet.GeoLocationProperty | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.HealthCheckId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     * @external
     */
    readonly healthCheckId?: string;
    /**
     * `AWS::Route53::RecordSet.HostedZoneId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     * @external
     */
    readonly hostedZoneId?: string;
    /**
     * `AWS::Route53::RecordSet.HostedZoneName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     * @external
     */
    readonly hostedZoneName?: string;
    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     * @external
     */
    readonly multiValueAnswer?: boolean | cdk.IResolvable;
    /**
     * `AWS::Route53::RecordSet.Region`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     * @external
     */
    readonly region?: string;
    /**
     * `AWS::Route53::RecordSet.ResourceRecords`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     * @external
     */
    readonly resourceRecords?: string[];
    /**
     * `AWS::Route53::RecordSet.SetIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     * @external
     */
    readonly setIdentifier?: string;
    /**
     * `AWS::Route53::RecordSet.TTL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     * @external
     */
    readonly ttl?: string;
    /**
     * `AWS::Route53::RecordSet.Weight`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     * @external
     */
    readonly weight?: number;
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSet
 */
export declare class CfnRecordSet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSet";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRecordSet;
    /**
     * `AWS::Route53::RecordSet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
     * @external
     */
    name: string;
    /**
     * `AWS::Route53::RecordSet.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
     * @external
     */
    type: string;
    /**
     * `AWS::Route53::RecordSet.AliasTarget`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
     * @external
     */
    aliasTarget: CfnRecordSet.AliasTargetProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.Comment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
     * @external
     */
    comment: string | undefined;
    /**
     * `AWS::Route53::RecordSet.Failover`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
     * @external
     */
    failover: string | undefined;
    /**
     * `AWS::Route53::RecordSet.GeoLocation`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
     * @external
     */
    geoLocation: CfnRecordSet.GeoLocationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.HealthCheckId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
     * @external
     */
    healthCheckId: string | undefined;
    /**
     * `AWS::Route53::RecordSet.HostedZoneId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
     * @external
     */
    hostedZoneId: string | undefined;
    /**
     * `AWS::Route53::RecordSet.HostedZoneName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
     * @external
     */
    hostedZoneName: string | undefined;
    /**
     * `AWS::Route53::RecordSet.MultiValueAnswer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
     * @external
     */
    multiValueAnswer: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Route53::RecordSet.Region`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
     * @external
     */
    region: string | undefined;
    /**
     * `AWS::Route53::RecordSet.ResourceRecords`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
     * @external
     */
    resourceRecords: string[] | undefined;
    /**
     * `AWS::Route53::RecordSet.SetIdentifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
     * @external
     */
    setIdentifier: string | undefined;
    /**
     * `AWS::Route53::RecordSet.TTL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
     * @external
     */
    ttl: string | undefined;
    /**
     * `AWS::Route53::RecordSet.Weight`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
     * @external
     */
    weight: number | undefined;
    /**
     * Create a new `AWS::Route53::RecordSet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRecordSetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSet
 */
export declare namespace CfnRecordSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     * @external
     */
    interface AliasTargetProperty {
        /**
         * `CfnRecordSet.AliasTargetProperty.DNSName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         * @external
         */
        readonly dnsName: string;
        /**
         * `CfnRecordSet.AliasTargetProperty.EvaluateTargetHealth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         * @external
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSet.AliasTargetProperty.HostedZoneId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         * @external
         */
        readonly hostedZoneId: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::RecordSet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSet
 */
export declare namespace CfnRecordSet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     * @external
     */
    interface GeoLocationProperty {
        /**
         * `CfnRecordSet.GeoLocationProperty.ContinentCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-continentcode
         * @external
         */
        readonly continentCode?: string;
        /**
         * `CfnRecordSet.GeoLocationProperty.CountryCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         * @external
         */
        readonly countryCode?: string;
        /**
         * `CfnRecordSet.GeoLocationProperty.SubdivisionCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         * @external
         */
        readonly subdivisionCode?: string;
    }
}
/**
 * Properties for defining a `AWS::Route53::RecordSetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 * @external
 */
export interface CfnRecordSetGroupProps {
    /**
     * `AWS::Route53::RecordSetGroup.Comment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     * @external
     */
    readonly comment?: string;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     * @external
     */
    readonly hostedZoneId?: string;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     * @external
     */
    readonly hostedZoneName?: string;
    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     * @external
     */
    readonly recordSets?: Array<CfnRecordSetGroup.RecordSetProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 */
export declare class CfnRecordSetGroup extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Route53::RecordSetGroup";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRecordSetGroup;
    /**
     * `AWS::Route53::RecordSetGroup.Comment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-comment
     * @external
     */
    comment: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzoneid
     * @external
     */
    hostedZoneId: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.HostedZoneName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-hostedzonename
     * @external
     */
    hostedZoneName: string | undefined;
    /**
     * `AWS::Route53::RecordSetGroup.RecordSets`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html#cfn-route53-recordsetgroup-recordsets
     * @external
     */
    recordSets: Array<CfnRecordSetGroup.RecordSetProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Route53::RecordSetGroup`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnRecordSetGroupProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 */
export declare namespace CfnRecordSetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html
     * @external
     */
    interface AliasTargetProperty {
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.DNSName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-dnshostname
         * @external
         */
        readonly dnsName: string;
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.EvaluateTargetHealth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-evaluatetargethealth
         * @external
         */
        readonly evaluateTargetHealth?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.AliasTargetProperty.HostedZoneId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-aliastarget.html#cfn-route53-aliastarget-hostedzoneid
         * @external
         */
        readonly hostedZoneId: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 */
export declare namespace CfnRecordSetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html
     * @external
     */
    interface GeoLocationProperty {
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.ContinentCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordsetgroup-geolocation-continentcode
         * @external
         */
        readonly continentCode?: string;
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.CountryCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-countrycode
         * @external
         */
        readonly countryCode?: string;
        /**
         * `CfnRecordSetGroup.GeoLocationProperty.SubdivisionCode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset-geolocation.html#cfn-route53-recordset-geolocation-subdivisioncode
         * @external
         */
        readonly subdivisionCode?: string;
    }
}
/**
 * A CloudFormation `AWS::Route53::RecordSetGroup`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-route53-recordsetgroup.html
 * @external
 * @cloudformationResource AWS::Route53::RecordSetGroup
 */
export declare namespace CfnRecordSetGroup {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html
     * @external
     */
    interface RecordSetProperty {
        /**
         * `CfnRecordSetGroup.RecordSetProperty.AliasTarget`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-aliastarget
         * @external
         */
        readonly aliasTarget?: CfnRecordSetGroup.AliasTargetProperty | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Comment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-comment
         * @external
         */
        readonly comment?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Failover`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-failover
         * @external
         */
        readonly failover?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.GeoLocation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-geolocation
         * @external
         */
        readonly geoLocation?: CfnRecordSetGroup.GeoLocationProperty | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HealthCheckId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-healthcheckid
         * @external
         */
        readonly healthCheckId?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzoneid
         * @external
         */
        readonly hostedZoneId?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.HostedZoneName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-hostedzonename
         * @external
         */
        readonly hostedZoneName?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.MultiValueAnswer`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-multivalueanswer
         * @external
         */
        readonly multiValueAnswer?: boolean | cdk.IResolvable;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Region`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-region
         * @external
         */
        readonly region?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.ResourceRecords`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-resourcerecords
         * @external
         */
        readonly resourceRecords?: string[];
        /**
         * `CfnRecordSetGroup.RecordSetProperty.SetIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-setidentifier
         * @external
         */
        readonly setIdentifier?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.TTL`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-ttl
         * @external
         */
        readonly ttl?: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnRecordSetGroup.RecordSetProperty.Weight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-route53-recordset.html#cfn-route53-recordset-weight
         * @external
         */
        readonly weight?: number;
    }
}
