api_method_map = {
    'asset/create': 'POST',
    'blacklist/create': 'POST',
    'blacklist/delete': 'POST',
    'blacklist/list': 'GET',
    'channel-role/create': 'POST',
    'channel-role/delete': 'POST',
    'channel-role/index': 'GET',
    'channel-role/update': 'POST',
    'channel/create': 'POST',
    'channel/delete': 'POST',
    'channel/list': 'GET',
    'channel/move-user': 'POST',
    'channel/view': 'GET',
    'direct-message/add-reaction': 'POST',
    'direct-message/create': 'POST',
    'direct-message/delete': 'POST',
    'direct-message/delete-reaction': 'POST',
    'direct-message/list': 'GET',
    'direct-message/reaction-list': 'GET',
    'direct-message/update': 'POST',
    'gateway/index': 'GET',
    'guild-emoji/create': 'POST',
    'guild-emoji/delete': 'POST',
    'guild-emoji/list': 'GET',
    'guild-emoji/update': 'POST',
    'guild-mute/create': 'POST',
    'guild-mute/delete': 'POST',
    'guild-mute/list': 'GET',
    'guild-role/create': 'POST',
    'guild-role/delete': 'POST',
    'guild-role/grant': 'POST',
    'guild-role/list': 'GET',
    'guild-role/revoke': 'POST',
    'guild-role/update': 'POST',
    'guild/kickout': 'POST',
    'guild/leave': 'POST',
    'guild/list': 'GET',
    'guild/nickname': 'POST',
    'guild/user-list': 'GET',
    'guild/view': 'GET',
    'intimacy/index': 'GET',
    'intimacy/update': 'POST',
    'invite/create': 'POST',
    'invite/delete': 'POST',
    'invite/list': 'GET',
    'message/add-reaction': 'POST',
    'message/create': 'POST',
    'message/delete': 'POST',
    'message/delete-reaction': 'POST',
    'message/list': 'GET',
    'message/reaction-list': 'GET',
    'message/update': 'POST',
    'message/view': 'GET',
    'user-chat/create': 'POST',
    'user-chat/delete': 'POST',
    'user-chat/list': 'GET',
    'user-chat/view': 'GET',
    'user/me': 'GET',
    'user/offline': 'POST',
    'user/view': 'GET'
}

def get_api_method(api: str) -> str:
    return api_method_map.get(api, "POST")
