"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Kaniko = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const ec2 = require("@aws-cdk/aws-ec2");
const ecr = require("@aws-cdk/aws-ecr");
const ecs = require("@aws-cdk/aws-ecs");
const cdk = require("@aws-cdk/core");
const cdk_fargate_run_task_1 = require("cdk-fargate-run-task");
/**
 * @stability stable
 */
class Kaniko extends cdk.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e;
        super(scope, id);
        this.fargateSpot = (_b = props.fargateSpot) !== null && _b !== void 0 ? _b : false;
        this.vpc = getOrCreateVpc(this);
        this.cluster = new ecs.Cluster(this, 'Cluster', {
            vpc: this.vpc,
            capacityProviders: ['FARGATE', 'FARGATE_SPOT'],
        });
        this.destinationRepository = (_c = props.destinationRepository) !== null && _c !== void 0 ? _c : this._createDestinationRepository();
        const executorImage = ecs.ContainerImage.fromAsset(path.join(__dirname, '../docker.d'));
        this.task = new ecs.FargateTaskDefinition(this, 'BuildImageTask', {
            cpu: 512,
            memoryLimitMiB: 1024,
        });
        this.task.addContainer('kaniko', {
            image: executorImage,
            command: [
                '--context', props.context,
                '--context-sub-path',
                (_d = props.contextSubPath) !== null && _d !== void 0 ? _d : './',
                '--dockerfile',
                (_e = props.dockerfile) !== null && _e !== void 0 ? _e : 'Dockerfile',
                '--destination', this.destinationRepository.repositoryUri,
                '--force',
            ],
            logging: new ecs.AwsLogDriver({ streamPrefix: 'kaniko' }),
        });
        this.destinationRepository.grantPullPush(this.task.taskRole);
        new cdk.CfnOutput(this, 'Repository', {
            value: this.destinationRepository.repositoryName,
        });
    }
    _createDestinationRepository() {
        return new ecr.Repository(this, 'Repo', {
            removalPolicy: cdk.RemovalPolicy.DESTROY,
        });
    }
    /**
     * Build the image with kaniko.
     *
     * @param schedule The schedule to repeatedly build the image.
     * @stability stable
     */
    buildImage(id, schedule) {
        // run it just once
        const newRunTask = new cdk_fargate_run_task_1.RunTask(this, `BuildImage${id}`, {
            task: this.task,
            cluster: this.cluster,
            schedule,
            capacityProviderStrategy: this.fargateSpot ? [
                {
                    capacityProvider: 'FARGATE_SPOT',
                    weight: 1,
                },
            ] : undefined,
        });
        // if vpc is a new resource in this stack, run task job will add dependency on vpc created.
        if (this.node.tryFindChild('Vpc').node.children.find(c => c.cfnResourceType === 'AWS::EC2::VPC')) {
            newRunTask.node.addDependency(this.vpc);
        }
        ;
    }
}
exports.Kaniko = Kaniko;
_a = JSII_RTTI_SYMBOL_1;
Kaniko[_a] = { fqn: "cdk-kaniko.Kaniko", version: "0.2.25" };
function getOrCreateVpc(scope) {
    // use an existing vpc or create a new one
    return scope.node.tryGetContext('use_default_vpc') === '1'
        || process.env.CDK_USE_DEFAULT_VPC === '1' ? ec2.Vpc.fromLookup(scope, 'Vpc', { isDefault: true }) :
        scope.node.tryGetContext('use_vpc_id') ?
            ec2.Vpc.fromLookup(scope, 'Vpc', { vpcId: scope.node.tryGetContext('use_vpc_id') }) :
            new ec2.Vpc(scope, 'Vpc', { maxAzs: 3, natGateways: 1 });
}
//# sourceMappingURL=data:application/json;base64,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