# coding: utf-8

"""
    Knowledge-Graph Query API

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)  # noqa: E501

    The version of the OpenAPI document: 1.0.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from deepsearch.cps.apis.kg.query.api_client import ApiClient
from deepsearch.cps.apis.kg.query.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class QueryApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def query_auth_config(self, **kwargs):  # noqa: E501
        """query_auth_config  # noqa: E501

        Retrieve the current auth config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_auth_config(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: AuthConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_auth_config_with_http_info(**kwargs)  # noqa: E501

    def query_auth_config_with_http_info(self, **kwargs):  # noqa: E501
        """query_auth_config  # noqa: E501

        Retrieve the current auth config.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_auth_config_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(AuthConfig, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_auth_config" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/authConfig', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='AuthConfig',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_get_correlated_nodes_from_indices(self, a, b, normalization, indices, **kwargs):  # noqa: E501
        """query_get_correlated_nodes_from_indices  # noqa: E501

        Retrieve the correlated nodes for some initial nodes-indices.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_correlated_nodes_from_indices(a, b, normalization, indices, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str a: Find neighbours of nodes for this edge only. (required)
        :param str b: Find neighbours of nodes for this edge only. (required)
        :param str normalization: Rank the nodes according to L2- or Linf-normalization (required)
        :param list[int] indices: node-indices (required)
        :param str filter: Filter the retrieved nodes by this category.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_get_correlated_nodes_from_indices_with_http_info(a, b, normalization, indices, **kwargs)  # noqa: E501

    def query_get_correlated_nodes_from_indices_with_http_info(self, a, b, normalization, indices, **kwargs):  # noqa: E501
        """query_get_correlated_nodes_from_indices  # noqa: E501

        Retrieve the correlated nodes for some initial nodes-indices.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_correlated_nodes_from_indices_with_http_info(a, b, normalization, indices, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str a: Find neighbours of nodes for this edge only. (required)
        :param str b: Find neighbours of nodes for this edge only. (required)
        :param str normalization: Rank the nodes according to L2- or Linf-normalization (required)
        :param list[int] indices: node-indices (required)
        :param str filter: Filter the retrieved nodes by this category.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'a',
            'b',
            'normalization',
            'indices',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_get_correlated_nodes_from_indices" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'a' is set
        if self.api_client.client_side_validation and ('a' not in local_var_params or  # noqa: E501
                                                        local_var_params['a'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `a` when calling `query_get_correlated_nodes_from_indices`")  # noqa: E501
        # verify the required parameter 'b' is set
        if self.api_client.client_side_validation and ('b' not in local_var_params or  # noqa: E501
                                                        local_var_params['b'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `b` when calling `query_get_correlated_nodes_from_indices`")  # noqa: E501
        # verify the required parameter 'normalization' is set
        if self.api_client.client_side_validation and ('normalization' not in local_var_params or  # noqa: E501
                                                        local_var_params['normalization'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `normalization` when calling `query_get_correlated_nodes_from_indices`")  # noqa: E501
        # verify the required parameter 'indices' is set
        if self.api_client.client_side_validation and ('indices' not in local_var_params or  # noqa: E501
                                                        local_var_params['indices'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `indices` when calling `query_get_correlated_nodes_from_indices`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'a' in local_var_params and local_var_params['a'] is not None:  # noqa: E501
            query_params.append(('A', local_var_params['a']))  # noqa: E501
        if 'b' in local_var_params and local_var_params['b'] is not None:  # noqa: E501
            query_params.append(('B', local_var_params['b']))  # noqa: E501
        if 'normalization' in local_var_params and local_var_params['normalization'] is not None:  # noqa: E501
            query_params.append(('normalization', local_var_params['normalization']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'indices' in local_var_params:
            body_params = local_var_params['indices']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/getCorrelatedNodesFromIndices', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_get_correlated_nodes_from_names(self, epsilon, a, b, normalization, names, **kwargs):  # noqa: E501
        """query_get_correlated_nodes_from_names  # noqa: E501

        Retrieve the correlated nodes for some initial nodes-names.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_correlated_nodes_from_names(epsilon, a, b, normalization, names, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float epsilon: Find all nodes with a name similarity above epsilon. (required)
        :param str a: Find neighbours of nodes for this edge only. (required)
        :param str b: Find neighbours of nodes for this edge only. (required)
        :param str normalization: Rank the nodes according to L2- or Linf-normalization (required)
        :param list[str] names: Name of the nodes (required)
        :param str filter: Filter the retrieved nodes by this category
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_get_correlated_nodes_from_names_with_http_info(epsilon, a, b, normalization, names, **kwargs)  # noqa: E501

    def query_get_correlated_nodes_from_names_with_http_info(self, epsilon, a, b, normalization, names, **kwargs):  # noqa: E501
        """query_get_correlated_nodes_from_names  # noqa: E501

        Retrieve the correlated nodes for some initial nodes-names.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_correlated_nodes_from_names_with_http_info(epsilon, a, b, normalization, names, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param float epsilon: Find all nodes with a name similarity above epsilon. (required)
        :param str a: Find neighbours of nodes for this edge only. (required)
        :param str b: Find neighbours of nodes for this edge only. (required)
        :param str normalization: Rank the nodes according to L2- or Linf-normalization (required)
        :param list[str] names: Name of the nodes (required)
        :param str filter: Filter the retrieved nodes by this category
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'epsilon',
            'a',
            'b',
            'normalization',
            'names',
            'filter'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_get_correlated_nodes_from_names" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'epsilon' is set
        if self.api_client.client_side_validation and ('epsilon' not in local_var_params or  # noqa: E501
                                                        local_var_params['epsilon'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `epsilon` when calling `query_get_correlated_nodes_from_names`")  # noqa: E501
        # verify the required parameter 'a' is set
        if self.api_client.client_side_validation and ('a' not in local_var_params or  # noqa: E501
                                                        local_var_params['a'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `a` when calling `query_get_correlated_nodes_from_names`")  # noqa: E501
        # verify the required parameter 'b' is set
        if self.api_client.client_side_validation and ('b' not in local_var_params or  # noqa: E501
                                                        local_var_params['b'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `b` when calling `query_get_correlated_nodes_from_names`")  # noqa: E501
        # verify the required parameter 'normalization' is set
        if self.api_client.client_side_validation and ('normalization' not in local_var_params or  # noqa: E501
                                                        local_var_params['normalization'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `normalization` when calling `query_get_correlated_nodes_from_names`")  # noqa: E501
        # verify the required parameter 'names' is set
        if self.api_client.client_side_validation and ('names' not in local_var_params or  # noqa: E501
                                                        local_var_params['names'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `names` when calling `query_get_correlated_nodes_from_names`")  # noqa: E501

        if self.api_client.client_side_validation and 'epsilon' in local_var_params and local_var_params['epsilon'] > 1:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `epsilon` when calling `query_get_correlated_nodes_from_names`, must be a value less than or equal to `1`")  # noqa: E501
        if self.api_client.client_side_validation and 'epsilon' in local_var_params and local_var_params['epsilon'] < 0:  # noqa: E501
            raise ApiValueError("Invalid value for parameter `epsilon` when calling `query_get_correlated_nodes_from_names`, must be a value greater than or equal to `0`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'epsilon' in local_var_params and local_var_params['epsilon'] is not None:  # noqa: E501
            query_params.append(('epsilon', local_var_params['epsilon']))  # noqa: E501
        if 'a' in local_var_params and local_var_params['a'] is not None:  # noqa: E501
            query_params.append(('A', local_var_params['a']))  # noqa: E501
        if 'b' in local_var_params and local_var_params['b'] is not None:  # noqa: E501
            query_params.append(('B', local_var_params['b']))  # noqa: E501
        if 'normalization' in local_var_params and local_var_params['normalization'] is not None:  # noqa: E501
            query_params.append(('normalization', local_var_params['normalization']))  # noqa: E501
        if 'filter' in local_var_params and local_var_params['filter'] is not None:  # noqa: E501
            query_params.append(('filter', local_var_params['filter']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'names' in local_var_params:
            body_params = local_var_params['names']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/getCorrelatedNodesFromNames', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_get_degree(self, edge_name, degree_type, indices_type, indices, **kwargs):  # noqa: E501
        """query_get_degree  # noqa: E501

        Retrieve the in or out degree of nodes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_degree(edge_name, degree_type, indices_type, indices, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edge_name: name of the edge (required)
        :param str degree_type: select in or out degree of the nodes (required)
        :param str indices_type: select if you want to search in a specific set of indices or in a range of indices (required)
        :param list[int] indices: node-indices (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_get_degree_with_http_info(edge_name, degree_type, indices_type, indices, **kwargs)  # noqa: E501

    def query_get_degree_with_http_info(self, edge_name, degree_type, indices_type, indices, **kwargs):  # noqa: E501
        """query_get_degree  # noqa: E501

        Retrieve the in or out degree of nodes  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_degree_with_http_info(edge_name, degree_type, indices_type, indices, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str edge_name: name of the edge (required)
        :param str degree_type: select in or out degree of the nodes (required)
        :param str indices_type: select if you want to search in a specific set of indices or in a range of indices (required)
        :param list[int] indices: node-indices (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'edge_name',
            'degree_type',
            'indices_type',
            'indices'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_get_degree" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'edge_name' is set
        if self.api_client.client_side_validation and ('edge_name' not in local_var_params or  # noqa: E501
                                                        local_var_params['edge_name'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `edge_name` when calling `query_get_degree`")  # noqa: E501
        # verify the required parameter 'degree_type' is set
        if self.api_client.client_side_validation and ('degree_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['degree_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `degree_type` when calling `query_get_degree`")  # noqa: E501
        # verify the required parameter 'indices_type' is set
        if self.api_client.client_side_validation and ('indices_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['indices_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `indices_type` when calling `query_get_degree`")  # noqa: E501
        # verify the required parameter 'indices' is set
        if self.api_client.client_side_validation and ('indices' not in local_var_params or  # noqa: E501
                                                        local_var_params['indices'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `indices` when calling `query_get_degree`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'edge_name' in local_var_params and local_var_params['edge_name'] is not None:  # noqa: E501
            query_params.append(('edge_name', local_var_params['edge_name']))  # noqa: E501
        if 'degree_type' in local_var_params and local_var_params['degree_type'] is not None:  # noqa: E501
            query_params.append(('degree_type', local_var_params['degree_type']))  # noqa: E501
        if 'indices_type' in local_var_params and local_var_params['indices_type'] is not None:  # noqa: E501
            query_params.append(('indices_type', local_var_params['indices_type']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'indices' in local_var_params:
            body_params = local_var_params['indices']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/getDegree', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_get_neighbours(self, indices, **kwargs):  # noqa: E501
        """query_get_neighbours  # noqa: E501

        Retrieve the neighbours of nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_neighbours(indices, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] indices: node-indices (required)
        :param str edge: Find neighbours of nodes for this edge only. By default, we search the neighbours over all edges.
        :param int limit: Limit the total number of neighbours returned.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_get_neighbours_with_http_info(indices, **kwargs)  # noqa: E501

    def query_get_neighbours_with_http_info(self, indices, **kwargs):  # noqa: E501
        """query_get_neighbours  # noqa: E501

        Retrieve the neighbours of nodes.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_get_neighbours_with_http_info(indices, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[int] indices: node-indices (required)
        :param str edge: Find neighbours of nodes for this edge only. By default, we search the neighbours over all edges.
        :param int limit: Limit the total number of neighbours returned.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'indices',
            'edge',
            'limit'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_get_neighbours" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'indices' is set
        if self.api_client.client_side_validation and ('indices' not in local_var_params or  # noqa: E501
                                                        local_var_params['indices'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `indices` when calling `query_get_neighbours`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'edge' in local_var_params and local_var_params['edge'] is not None:  # noqa: E501
            query_params.append(('edge', local_var_params['edge']))  # noqa: E501
        if 'limit' in local_var_params and local_var_params['limit'] is not None:  # noqa: E501
            query_params.append(('limit', local_var_params['limit']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'indices' in local_var_params:
            body_params = local_var_params['indices']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/getNeighbours', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_run_parallel_workflow(self, pworkflow, **kwargs):  # noqa: E501
        """query_run_parallel_workflow  # noqa: E501

        Run in parallel Directed Acyclic Graph (DAG) workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_run_parallel_workflow(pworkflow, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param object pworkflow: Input for parallel Directed Acyclic Graph (DAG) workflows (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: WorkflowResponseModel
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_run_parallel_workflow_with_http_info(pworkflow, **kwargs)  # noqa: E501

    def query_run_parallel_workflow_with_http_info(self, pworkflow, **kwargs):  # noqa: E501
        """query_run_parallel_workflow  # noqa: E501

        Run in parallel Directed Acyclic Graph (DAG) workflows  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_run_parallel_workflow_with_http_info(pworkflow, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param object pworkflow: Input for parallel Directed Acyclic Graph (DAG) workflows (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(WorkflowResponseModel, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'pworkflow'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_run_parallel_workflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'pworkflow' is set
        if self.api_client.client_side_validation and ('pworkflow' not in local_var_params or  # noqa: E501
                                                        local_var_params['pworkflow'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `pworkflow` when calling `query_run_parallel_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'pworkflow' in local_var_params:
            body_params = local_var_params['pworkflow']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/runParallelWorkflow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='WorkflowResponseModel',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_run_workflow(self, workflow, **kwargs):  # noqa: E501
        """query_run_workflow  # noqa: E501

        Run a Directed Acyclic Graph (DAG) workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_run_workflow(workflow, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[dict(str, object)] workflow: Input for Directed Acyclic Graph (DAG) workflow (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[WorkflowResponse]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_run_workflow_with_http_info(workflow, **kwargs)  # noqa: E501

    def query_run_workflow_with_http_info(self, workflow, **kwargs):  # noqa: E501
        """query_run_workflow  # noqa: E501

        Run a Directed Acyclic Graph (DAG) workflow  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_run_workflow_with_http_info(workflow, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[dict(str, object)] workflow: Input for Directed Acyclic Graph (DAG) workflow (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[WorkflowResponse], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'workflow'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_run_workflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'workflow' is set
        if self.api_client.client_side_validation and ('workflow' not in local_var_params or  # noqa: E501
                                                        local_var_params['workflow'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `workflow` when calling `query_run_workflow`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'workflow' in local_var_params:
            body_params = local_var_params['workflow']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/runWorkflow', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[WorkflowResponse]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_suggest_workflow(self, search_string, **kwargs):  # noqa: E501
        """query_suggest_workflow  # noqa: E501

        Suggest a workflow based on a given search string.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_suggest_workflow(search_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str search_string: Query string to generate a workflow for. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_suggest_workflow_with_http_info(search_string, **kwargs)  # noqa: E501

    def query_suggest_workflow_with_http_info(self, search_string, **kwargs):  # noqa: E501
        """query_suggest_workflow  # noqa: E501

        Suggest a workflow based on a given search string.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_suggest_workflow_with_http_info(search_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str search_string: Query string to generate a workflow for. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'search_string'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_suggest_workflow" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'search_string' is set
        if self.api_client.client_side_validation and ('search_string' not in local_var_params or  # noqa: E501
                                                        local_var_params['search_string'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `search_string` when calling `query_suggest_workflow`")  # noqa: E501

        if self.api_client.client_side_validation and ('search_string' in local_var_params and  # noqa: E501
                                                        len(local_var_params['search_string']) > 256):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `search_string` when calling `query_suggest_workflow`, length must be less than or equal to `256`")  # noqa: E501
        if self.api_client.client_side_validation and ('search_string' in local_var_params and  # noqa: E501
                                                        len(local_var_params['search_string']) < 1):  # noqa: E501
            raise ApiValueError("Invalid value for parameter `search_string` when calling `query_suggest_workflow`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'search_string' in local_var_params and local_var_params['search_string'] is not None:  # noqa: E501
            query_params.append(('search_string', local_var_params['search_string']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Bearer']  # noqa: E501

        return self.api_client.call_api(
            '/query/suggestWorkflow', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
