import argparse
from swarm.blueprints.rue_code.blueprint_rue_code import RueCodeBlueprint
from swarm.blueprints.common.operation_box_utils import display_operation_box

def main():
    parser = argparse.ArgumentParser(description="RueCode: LLM code search/cost demo")
    parser.add_argument("--message", type=str, help="User message to process", default="Show me code cost demo")
    args = parser.parse_args()
    bp = RueCodeBlueprint(blueprint_id="cli")
    import asyncio
    async def run():
        async for result in bp.run([{"role": "user", "content": args.message}]):
            if isinstance(result, dict) and "messages" in result:
                print(result["messages"][0]["content"])
            elif isinstance(result, str):
                print(result)
            elif isinstance(result, dict) and (result.get("matches") or result.get("progress")):
                # Print the actual operation box for progressive output
                display_operation_box(
                    title="Progressive Operation",
                    content="\n".join(result.get("matches", [])),
                    style="bold cyan" if result.get("type") == "code_search" else "bold magenta",
                    result_count=len(result.get("matches", [])) if result.get("matches") is not None else None,
                    params={k: v for k, v in result.items() if k not in {'matches', 'progress', 'total', 'truncated', 'done'}},
                    progress_line=result.get('progress'),
                    total_lines=result.get('total'),
                    spinner_state=result.get('spinner_state'),
                    op_type=result.get("type", "search"),
                    emoji="🔍" if result.get("type") == "code_search" else "🧠"
                )
            else:
                print(str(result))
    asyncio.run(run())

if __name__ == "__main__":
    import sys
    if sys.argv[0].endswith("rue_code_cli.py") or sys.argv[0].endswith("rue_code_cli"):  # legacy
        print("[INFO] For future use, invoke this CLI as 'rue' instead of 'rue_code_cli'.")
        main()
    elif sys.argv[0].endswith("rue"):  # preferred new name
        main()
    else:
        main()
