/*
 * Decompiled with CFR 0.152.
 */
package be.fedict.eid.applet.service;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PhotoServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(PhotoServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOG.debug((Object)"doGet");
        response.setContentType("image/jpg");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate, max-age=-1");
        response.setHeader("Pragma", "no-cache, no-store");
        response.setDateHeader("Expires", -1L);
        ServletOutputStream out = response.getOutputStream();
        HttpSession session = request.getSession();
        byte[] photoData = (byte[])session.getAttribute("eid.photo");
        if (null != photoData) {
            BufferedImage photo = ImageIO.read(new ByteArrayInputStream(photoData));
            if (null == photo) {
                photo = new BufferedImage(140, 200, 1);
                Graphics2D graphics = (Graphics2D)photo.getGraphics();
                RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                graphics.setRenderingHints(renderingHints);
                graphics.setColor(Color.WHITE);
                graphics.fillRect(1, 1, 138, 198);
                graphics.setColor(Color.RED);
                graphics.setFont(new Font("Dialog", 1, 20));
                graphics.drawString("Photo Error", 0, 100);
                graphics.dispose();
                ImageIO.write((RenderedImage)photo, "jpg", (OutputStream)out);
            } else {
                out.write(photoData);
            }
        }
        out.close();
    }
}

