import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeSnapshotConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#description ComputeSnapshot#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Labels to apply to this Snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#labels ComputeSnapshot#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#name ComputeSnapshot#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#project ComputeSnapshot#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A reference to the disk used to create this snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#source_disk ComputeSnapshot#source_disk}
     *
     * @stability stable
     */
    readonly sourceDisk: string;
    /**
     * Cloud Storage bucket storage location of the snapshot (regional or multi-regional).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#storage_locations ComputeSnapshot#storage_locations}
     *
     * @stability stable
     */
    readonly storageLocations?: string[];
    /**
     * A reference to the zone where the disk is hosted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#zone ComputeSnapshot#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * snapshot_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#snapshot_encryption_key ComputeSnapshot#snapshot_encryption_key}
     *
     * @stability stable
     */
    readonly snapshotEncryptionKey?: ComputeSnapshotSnapshotEncryptionKey;
    /**
     * source_disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#source_disk_encryption_key ComputeSnapshot#source_disk_encryption_key}
     *
     * @stability stable
     */
    readonly sourceDiskEncryptionKey?: ComputeSnapshotSourceDiskEncryptionKey;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#timeouts ComputeSnapshot#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeSnapshotTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeSnapshotSnapshotEncryptionKey {
    /**
     * The name of the encryption key that is stored in Google Cloud KMS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#kms_key_self_link ComputeSnapshot#kms_key_self_link}
     *
     * @stability stable
     */
    readonly kmsKeySelfLink?: string;
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#kms_key_service_account ComputeSnapshot#kms_key_service_account}
     *
     * @stability stable
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#raw_key ComputeSnapshot#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
export declare function computeSnapshotSnapshotEncryptionKeyToTerraform(struct?: ComputeSnapshotSnapshotEncryptionKeyOutputReference | ComputeSnapshotSnapshotEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ComputeSnapshotSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSnapshotSnapshotEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSnapshotSnapshotEncryptionKey | undefined);
    private _kmsKeySelfLink?;
    /**
     * @stability stable
     */
    get kmsKeySelfLink(): string;
    /**
     * @stability stable
     */
    set kmsKeySelfLink(value: string);
    /**
     * @stability stable
     */
    resetKmsKeySelfLink(): void;
    /**
     * @stability stable
     */
    get kmsKeySelfLinkInput(): string | undefined;
    private _kmsKeyServiceAccount?;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccount(): string;
    /**
     * @stability stable
     */
    set kmsKeyServiceAccount(value: string);
    /**
     * @stability stable
     */
    resetKmsKeyServiceAccount(): void;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string;
    /**
     * @stability stable
     */
    set rawKey(value: string);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeSnapshotSourceDiskEncryptionKey {
    /**
     * The service account used for the encryption request for the given KMS key.
     *
     * If absent, the Compute Engine Service Agent service account is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#kms_key_service_account ComputeSnapshot#kms_key_service_account}
     *
     * @stability stable
     */
    readonly kmsKeyServiceAccount?: string;
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#raw_key ComputeSnapshot#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
export declare function computeSnapshotSourceDiskEncryptionKeyToTerraform(struct?: ComputeSnapshotSourceDiskEncryptionKeyOutputReference | ComputeSnapshotSourceDiskEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ComputeSnapshotSourceDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSnapshotSourceDiskEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSnapshotSourceDiskEncryptionKey | undefined);
    private _kmsKeyServiceAccount?;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccount(): string;
    /**
     * @stability stable
     */
    set kmsKeyServiceAccount(value: string);
    /**
     * @stability stable
     */
    resetKmsKeyServiceAccount(): void;
    /**
     * @stability stable
     */
    get kmsKeyServiceAccountInput(): string | undefined;
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string;
    /**
     * @stability stable
     */
    set rawKey(value: string);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeSnapshotTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#create ComputeSnapshot#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#delete ComputeSnapshot#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html#update ComputeSnapshot#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeSnapshotTimeoutsToTerraform(struct?: ComputeSnapshotTimeoutsOutputReference | ComputeSnapshotTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeSnapshotTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeSnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeSnapshotTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html google_compute_snapshot}.
 *
 * @stability stable
 */
export declare class ComputeSnapshot extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_snapshot.html google_compute_snapshot} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeSnapshotConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get licenses(): string[];
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get snapshotId(): number;
    private _sourceDisk?;
    /**
     * @stability stable
     */
    get sourceDisk(): string;
    /**
     * @stability stable
     */
    set sourceDisk(value: string);
    /**
     * @stability stable
     */
    get sourceDiskInput(): string | undefined;
    /**
     * @stability stable
     */
    get sourceDiskLink(): string;
    /**
     * @stability stable
     */
    get storageBytes(): number;
    private _storageLocations?;
    /**
     * @stability stable
     */
    get storageLocations(): string[];
    /**
     * @stability stable
     */
    set storageLocations(value: string[]);
    /**
     * @stability stable
     */
    resetStorageLocations(): void;
    /**
     * @stability stable
     */
    get storageLocationsInput(): string[] | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _snapshotEncryptionKey;
    /**
     * @stability stable
     */
    get snapshotEncryptionKey(): ComputeSnapshotSnapshotEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putSnapshotEncryptionKey(value: ComputeSnapshotSnapshotEncryptionKey): void;
    /**
     * @stability stable
     */
    resetSnapshotEncryptionKey(): void;
    /**
     * @stability stable
     */
    get snapshotEncryptionKeyInput(): ComputeSnapshotSnapshotEncryptionKey | undefined;
    private _sourceDiskEncryptionKey;
    /**
     * @stability stable
     */
    get sourceDiskEncryptionKey(): ComputeSnapshotSourceDiskEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putSourceDiskEncryptionKey(value: ComputeSnapshotSourceDiskEncryptionKey): void;
    /**
     * @stability stable
     */
    resetSourceDiskEncryptionKey(): void;
    /**
     * @stability stable
     */
    get sourceDiskEncryptionKeyInput(): ComputeSnapshotSourceDiskEncryptionKey | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeSnapshotTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeSnapshotTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeSnapshotTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
