import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeTargetInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#description ComputeTargetInstance#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The Compute instance VM handling traffic for this target instance.
     *
     * Accepts the instance self-link, relative path
     * (e.g. 'projects/project/zones/zone/instances/instance') or name. If
     * name is given, the zone will default to the given zone or
     * the provider-default zone and the project will default to the
     * provider-level project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#instance ComputeTargetInstance#instance}
     *
     * @stability stable
     */
    readonly instance: string;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#name ComputeTargetInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * NAT option controlling how IPs are NAT'ed to the instance.
     *
     * Currently only NO_NAT (default value) is supported. Default value: "NO_NAT" Possible values: ["NO_NAT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#nat_policy ComputeTargetInstance#nat_policy}
     *
     * @stability stable
     */
    readonly natPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#project ComputeTargetInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * URL of the zone where the target instance resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#zone ComputeTargetInstance#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#timeouts ComputeTargetInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeTargetInstanceTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeTargetInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#create ComputeTargetInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html#delete ComputeTargetInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function computeTargetInstanceTimeoutsToTerraform(struct?: ComputeTargetInstanceTimeoutsOutputReference | ComputeTargetInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeTargetInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeTargetInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeTargetInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html google_compute_target_instance}.
 *
 * @stability stable
 */
export declare class ComputeTargetInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_target_instance.html google_compute_target_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeTargetInstanceConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _instance?;
    /**
     * @stability stable
     */
    get instance(): string;
    /**
     * @stability stable
     */
    set instance(value: string);
    /**
     * @stability stable
     */
    get instanceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _natPolicy?;
    /**
     * @stability stable
     */
    get natPolicy(): string;
    /**
     * @stability stable
     */
    set natPolicy(value: string);
    /**
     * @stability stable
     */
    resetNatPolicy(): void;
    /**
     * @stability stable
     */
    get natPolicyInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeTargetInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeTargetInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeTargetInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
