import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleMonitoringClusterIstioServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the Kubernetes cluster in which this Istio service is defined.
     *
     * Corresponds to the clusterName resource label in k8s_cluster resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#cluster_name DataGoogleMonitoringClusterIstioService#cluster_name}
     *
     * @stability stable
     */
    readonly clusterName: string;
    /**
     * The location of the Kubernetes cluster in which this Istio service is defined.
     *
     * Corresponds to the location resource label in k8s_cluster resources.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#location DataGoogleMonitoringClusterIstioService#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#project DataGoogleMonitoringClusterIstioService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the Istio service underlying this service.
     *
     * Corresponds to the destination_service_name metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#service_name DataGoogleMonitoringClusterIstioService#service_name}
     *
     * @stability stable
     */
    readonly serviceName: string;
    /**
     * The namespace of the Istio service underlying this service.
     *
     * Corresponds to the destination_service_namespace metric label in Istio metrics.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html#service_namespace DataGoogleMonitoringClusterIstioService#service_namespace}
     *
     * @stability stable
     */
    readonly serviceNamespace: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleMonitoringClusterIstioServiceTelemetry extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get resourceName(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html google_monitoring_cluster_istio_service}.
 *
 * @stability stable
 */
export declare class DataGoogleMonitoringClusterIstioService extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/monitoring_cluster_istio_service.html google_monitoring_cluster_istio_service} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleMonitoringClusterIstioServiceConfig);
    private _clusterName?;
    /**
     * @stability stable
     */
    get clusterName(): string;
    /**
     * @stability stable
     */
    set clusterName(value: string);
    /**
     * @stability stable
     */
    get clusterNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceId(): string;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
    private _serviceNamespace?;
    /**
     * @stability stable
     */
    get serviceNamespace(): string;
    /**
     * @stability stable
     */
    set serviceNamespace(value: string);
    /**
     * @stability stable
     */
    get serviceNamespaceInput(): string | undefined;
    /**
     * @stability stable
     */
    telemetry(index: string): DataGoogleMonitoringClusterIstioServiceTelemetry;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
