# coding: utf-8

from __future__ import annotations

import re  # noqa: F401
from datetime import date, datetime  # noqa: F401
from typing import Any, Dict, List, Optional  # noqa: F401

from fastapi_camelcase import CamelModel  # noqa: F401
from pydantic import AnyUrl, Field

from telus_bulk.models.tmf_645.characteristic import Characteristic
from telus_bulk.models.tmf_645.constraint_ref import ConstraintRef
from telus_bulk.models.tmf_645.feature_relationship import FeatureRelationship


class Feature(CamelModel):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.

    Feature - a model defined in OpenAPI

        id: The id of this Feature [Optional].
        is_bundle: The is_bundle of this Feature [Optional].
        is_enabled: The is_enabled of this Feature [Optional].
        name: The name of this Feature.
        constraint: The constraint of this Feature [Optional].
        feature_characteristic: The feature_characteristic of this Feature.
        feature_relationship: The feature_relationship of this Feature [Optional].
        base_type: The base_type of this Feature [Optional].
        schema_location: The schema_location of this Feature [Optional].
        type: The type of this Feature [Optional].
    """

    id: Optional[str] = None
    is_bundle: Optional[bool] = None
    is_enabled: Optional[bool] = None
    name: str
    constraint: Optional[List[ConstraintRef]] = None
    feature_characteristic: List[Characteristic]
    feature_relationship: Optional[List[FeatureRelationship]] = None
    base_type: Optional[str] = None
    schema_location: Optional[AnyUrl] = None
    type: Optional[str] = Field(default=None, alias="@type")


Feature.update_forward_refs()
