import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GrantRoleConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the role that is granted to role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role#grant_role GrantRole#grant_role}
    */
    readonly grantRole: string;
    /**
    * The name of the role to grant grant_role
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role#role GrantRole#role}
    */
    readonly role: string;
    /**
    * Permit the grant recipient to grant it to others
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role#with_admin_option GrantRole#with_admin_option}
    */
    readonly withAdminOption?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role postgresql_grant_role}
*/
export declare class GrantRole extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_grant_role";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/grant_role postgresql_grant_role} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GrantRoleConfig
    */
    constructor(scope: Construct, id: string, config: GrantRoleConfig);
    private _grantRole?;
    get grantRole(): string;
    set grantRole(value: string);
    get grantRoleInput(): string | undefined;
    get id(): string;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _withAdminOption?;
    get withAdminOption(): boolean | cdktf.IResolvable;
    set withAdminOption(value: boolean | cdktf.IResolvable);
    resetWithAdminOption(): void;
    get withAdminOptionInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=grant-role.d.ts.map