import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SchemaConfig extends cdktf.TerraformMetaArguments {
    /**
    * The database name to alter schema
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#database Schema#database}
    */
    readonly database?: string;
    /**
    * When true, will also drop all the objects that are contained in the schema
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#drop_cascade Schema#drop_cascade}
    */
    readonly dropCascade?: boolean | cdktf.IResolvable;
    /**
    * When true, use the existing schema if it exists
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#if_not_exists Schema#if_not_exists}
    */
    readonly ifNotExists?: boolean | cdktf.IResolvable;
    /**
    * The name of the schema
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#name Schema#name}
    */
    readonly name: string;
    /**
    * The ROLE name who owns the schema
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#owner Schema#owner}
    */
    readonly owner?: string;
    /**
    * policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#policy Schema#policy}
    */
    readonly policy?: SchemaPolicy[] | cdktf.IResolvable;
}
export interface SchemaPolicy {
    /**
    * If true, allow the specified ROLEs to CREATE new objects within the schema(s)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#create Schema#create}
    */
    readonly create?: boolean | cdktf.IResolvable;
    /**
    * If true, allow the specified ROLEs to CREATE new objects within the schema(s) and GRANT the same CREATE privilege to different ROLEs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#create_with_grant Schema#create_with_grant}
    */
    readonly createWithGrant?: boolean | cdktf.IResolvable;
    /**
    * ROLE who will receive this policy (default: PUBLIC)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#role Schema#role}
    */
    readonly role?: string;
    /**
    * If true, allow the specified ROLEs to use objects within the schema(s)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#usage Schema#usage}
    */
    readonly usage?: boolean | cdktf.IResolvable;
    /**
    * If true, allow the specified ROLEs to use objects within the schema(s) and GRANT the same USAGE privilege to different ROLEs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/postgresql/r/schema#usage_with_grant Schema#usage_with_grant}
    */
    readonly usageWithGrant?: boolean | cdktf.IResolvable;
}
export declare function schemaPolicyToTerraform(struct?: SchemaPolicy | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/postgresql/r/schema postgresql_schema}
*/
export declare class Schema extends cdktf.TerraformResource {
    static readonly tfResourceType = "postgresql_schema";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/postgresql/r/schema postgresql_schema} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SchemaConfig
    */
    constructor(scope: Construct, id: string, config: SchemaConfig);
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _dropCascade?;
    get dropCascade(): boolean | cdktf.IResolvable;
    set dropCascade(value: boolean | cdktf.IResolvable);
    resetDropCascade(): void;
    get dropCascadeInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _ifNotExists?;
    get ifNotExists(): boolean | cdktf.IResolvable;
    set ifNotExists(value: boolean | cdktf.IResolvable);
    resetIfNotExists(): void;
    get ifNotExistsInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _owner?;
    get owner(): string;
    set owner(value: string);
    resetOwner(): void;
    get ownerInput(): string | undefined;
    private _policy?;
    get policy(): SchemaPolicy[] | cdktf.IResolvable;
    set policy(value: SchemaPolicy[] | cdktf.IResolvable);
    resetPolicy(): void;
    get policyInput(): cdktf.IResolvable | SchemaPolicy[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=schema.d.ts.map