# Generated by Django 2.2.28 on 2022-05-10 07:13

from django.db import migrations, models
import django.db.models.deletion

NEED_TO_FILL = 'need_to_fill'
NULL_EMAIL = 'email_is_null@a.com'


def fill_payment_provider(apps, schema_editor):
    AlipayPayment = apps.get_model('alipay', 'AlipayPayment')
    Provider = apps.get_model('alipay', 'Provider')

    emails = AlipayPayment.objects.values_list('seller_email', flat=True).distinct()
    emails = list(emails)
    print('email', emails)

    import time

    t = time.time()

    for email in emails:
        p = Provider.objects.create(app_id=NEED_TO_FILL, private_key=NEED_TO_FILL, seller_id=NEED_TO_FILL,
                                    sign_type='MD5', seller_email=email)
        AlipayPayment.objects.filter(seller_email=email).update(provider=p)

    if AlipayPayment.objects.filter(seller_email__isnull=True).exists():
        p = Provider.objects.create(app_id=NEED_TO_FILL, private_key=NEED_TO_FILL, seller_id=NEED_TO_FILL,
                                    sign_type='MD5', seller_email=NULL_EMAIL)
        AlipayPayment.objects.filter(seller_email__isnull=True).update(provider=p)

    print('done cost', time.time() - t)


class Migration(migrations.Migration):
    dependencies = [
        ('alipay', '0010_alipaypayment_refund_total'),
    ]

    operations = [
        migrations.CreateModel(
            name='Provider',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app_id', models.CharField(max_length=32)),
                ('private_key', models.TextField()),
                ('public_key', models.TextField(blank=True, null=True)),
                ('app_cert', models.TextField(blank=True, null=True)),
                ('alipay_root_cert', models.TextField(blank=True, null=True)),
                ('sign_type',
                 models.CharField(choices=[('MD5', 'MD5'), ('RSA', 'RSA'), ('RSA2', 'RSA2')], default='RSA',
                                  max_length=12)),
                ('seller_id', models.CharField(max_length=28)),
                ('seller_email', models.EmailField(blank=True, max_length=100, null=True)),
                ('gateway', models.CharField(default='https://openapi.alipay.com/gateway.do?', max_length=200)),
            ],
        ),

        migrations.AddField(
            model_name='alipaypayment',
            name='provider',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='alipay.Provider'),
        ),
        migrations.RunPython(fill_payment_provider),
        migrations.AlterField(
            model_name='alipaypayment',
            name='provider',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='alipay.Provider'),
        ),
        migrations.RemoveField(
            model_name='alipaypayment',
            name='seller_email',
        ),
    ]
