"""System Wide Constants for pymeteobridgedata."""
from __future__ import annotations

FIELDS_OBSERVATION = [
    ["timestamp", "epoch", "int"],
    ["temperature", "th0temp-act:None", "float"],
    ["pressure", "thb0seapress-act:None", "float"],
    ["air_pm_10", "air0pm-act:None", "float"],
    ["air_pm_25", "air1pm-act:None", "float"],
    ["air_pm_1", "air2pm-act:None", "float"],
    ["heatindex", "th0heatindex-act:None", "float"],
    ["humidity", "th0hum-act:None", "int"],
    ["windspeedavg", "wind0avgwind-act:None", "float"],
    ["windgust", "wind0wind-max1:None", "float"],
    ["windspeed", "wind0wind-act:None", "float"],
    ["windbearing", "wind0dir-avg5.0:None", "int"],
    ["raintoday", "rain0total-daysum:None", "float"],
    ["rainrate", "rain0rate-act:None", "float"],
    ["dewpoint", "th0dew-act:None", "float"],
    ["windchill", "wind0chill-act:None", "float"],
    ["is_lowbat", "th0lowbat-act.0:None", "int"],
    ["in_temperature", "thb0temp-act:None", "float"],
    ["in_humidity", "thb0hum-act.0:None", "int"],
    ["temphigh", "th0temp-dmax:None", "float"],
    ["templow", "th0temp-dmin:None", "float"],
    ["uvindex", "uv0index-act:None", "float"],
    ["solarrad", "sol0rad-act:None", "float"],
    ["temp_month_min", "th0temp-mmin.1:None", "float"],
    ["temp_month_max", "th0temp-mmax.1:None", "float"],
    ["temp_year_min", "th0temp-ymin.1:None", "float"],
    ["temp_year_max", "th0temp-ymax.1:None", "float"],
    ["wind_month_max", "wind0wind-mmax.1:None", "float"],
    ["wind_year_max", "wind0wind-ymax.1:None", "float"],
    ["rain_month_max", "rain0total-mmax.1:None", "float"],
    ["rain_year_max", "rain0total-ymax.1:None", "float"],
    ["rainrate_month_max", "rain0rate-mmax.1:None", "float"],
    ["rainrate_year_max", "rain0rate-ymax.1:None", "float"],
    ["lightning_count", "lgt0total-act.0:None", "float"],
    ["lightning_energy", "lgt0energy-act.0:None", "float"],
    ["lightning_distance", "lgt0dist-act.0:None", "float"],
    ["bft_value", "wind0wind-act=bft.0:None", "int"],
    ["trend_temperature", "th0temp-delta10:None", "float"],
    ["trend_pressure", "thb0seapress-delta10:None", "float"],
    ["absolute_pressure", "thb0press-act:None", "float"],
    ["forecast", "forecast-text:None", "str"],
    ["temperature_2", "th1temp-act:None", "float"],
    ["humidity_2", "th1hum-act:None", "float"],
    ["heatindex_2", "th1heatindex-act.1:None", "float"],
    ["temperature_3", "th2temp-act:None", "float"],
    ["humidity_3", "th2hum-act:None", "float"],
    ["heatindex_3", "th2heatindex-act.1:None", "float"],
    ["temperature_4", "th3temp-act:None", "float"],
    ["humidity_4", "th3hum-act:None", "float"],
    ["heatindex_4", "th3heatindex-act.1:None", "float"],
    ["temperature_5", "th4temp-act:None", "float"],
    ["humidity_5", "th4hum-act:None", "float"],
    ["heatindex_5", "th4heatindex-act.1:None", "float"],
    ["temperature_6", "th5temp-act:None", "float"],
    ["humidity_6", "th5hum-act:None", "float"],
    ["heatindex_6", "th5heatindex-act.1:None", "float"],
    ["temperature_7", "th6temp-act:None", "float"],
    ["humidity_7", "th6hum-act:None", "float"],
    ["heatindex_7", "th6heatindex-act.1:None", "float"],
    ["temperature_8", "th7temp-act:None", "float"],
    ["humidity_8", "th7hum-act:None", "float"],
    ["heatindex_8", "th7heatindex-act.1:None", "float"],
]

FIELDS_STATION = [
    ["mac", "mbsystem-mac:--", "str"],
    ["swversion", "mbsystem-swversion:--", "float"],
    ["platform", "mbsystem-platform:--", "str"],
    ["station", "mbsystem-station:--", "str"],
    ["timezone", "mbsystem-timezone:--", "str"],
    ["uptime", "mbsystem-uptime:--", "int"],
    ["ip", "mbsystem-ip:--", "str"],
]

UNIT_TYPE_METRIC = "metric"
UNIT_TYPE_IMPERIAL = "imperial"
VALID_UNIT_TYPES = [UNIT_TYPE_IMPERIAL, UNIT_TYPE_METRIC]
