# coding: utf-8

"""
    VeeRoute.LSS Delivery

    VeeRoute.LSS Delivery API  # noqa: E501

    The version of the OpenAPI document: 3.6.163909
    Contact: support@veeroute.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from vrt_lss_delivery.configuration import Configuration


class Trip(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'trip_time': 'TimeWindow',
        'performer_key': 'str',
        'actions': 'list[TripAction]',
        'waitlist': 'list[str]'
    }

    attribute_map = {
        'key': 'key',
        'trip_time': 'trip_time',
        'performer_key': 'performer_key',
        'actions': 'actions',
        'waitlist': 'waitlist'
    }

    def __init__(self, key=None, trip_time=None, performer_key=None, actions=None, waitlist=None, local_vars_configuration=None):  # noqa: E501
        """Trip - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._trip_time = None
        self._performer_key = None
        self._actions = None
        self._waitlist = None
        self.discriminator = None

        self.key = key
        self.trip_time = trip_time
        self.performer_key = performer_key
        if actions is not None:
            self.actions = actions
        if waitlist is not None:
            self.waitlist = waitlist

    @property
    def key(self):
        """Gets the key of this Trip.  # noqa: E501

        Unique trip ID.  # noqa: E501

        :return: The key of this Trip.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this Trip.

        Unique trip ID.  # noqa: E501

        :param key: The key of this Trip.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and key is None:  # noqa: E501
            raise ValueError("Invalid value for `key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) > 1024):
            raise ValueError("Invalid value for `key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                key is not None and len(key) < 1):
            raise ValueError("Invalid value for `key`, length must be greater than or equal to `1`")  # noqa: E501

        self._key = key

    @property
    def trip_time(self):
        """Gets the trip_time of this Trip.  # noqa: E501


        :return: The trip_time of this Trip.  # noqa: E501
        :rtype: TimeWindow
        """
        return self._trip_time

    @trip_time.setter
    def trip_time(self, trip_time):
        """Sets the trip_time of this Trip.


        :param trip_time: The trip_time of this Trip.  # noqa: E501
        :type: TimeWindow
        """
        if self.local_vars_configuration.client_side_validation and trip_time is None:  # noqa: E501
            raise ValueError("Invalid value for `trip_time`, must not be `None`")  # noqa: E501

        self._trip_time = trip_time

    @property
    def performer_key(self):
        """Gets the performer_key of this Trip.  # noqa: E501

        Performer's key.  # noqa: E501

        :return: The performer_key of this Trip.  # noqa: E501
        :rtype: str
        """
        return self._performer_key

    @performer_key.setter
    def performer_key(self, performer_key):
        """Sets the performer_key of this Trip.

        Performer's key.  # noqa: E501

        :param performer_key: The performer_key of this Trip.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and performer_key is None:  # noqa: E501
            raise ValueError("Invalid value for `performer_key`, must not be `None`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                performer_key is not None and len(performer_key) > 1024):
            raise ValueError("Invalid value for `performer_key`, length must be less than or equal to `1024`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                performer_key is not None and len(performer_key) < 1):
            raise ValueError("Invalid value for `performer_key`, length must be greater than or equal to `1`")  # noqa: E501

        self._performer_key = performer_key

    @property
    def actions(self):
        """Gets the actions of this Trip.  # noqa: E501

        List of actions on orders.  # noqa: E501

        :return: The actions of this Trip.  # noqa: E501
        :rtype: list[TripAction]
        """
        return self._actions

    @actions.setter
    def actions(self, actions):
        """Sets the actions of this Trip.

        List of actions on orders.  # noqa: E501

        :param actions: The actions of this Trip.  # noqa: E501
        :type: list[TripAction]
        """

        self._actions = actions

    @property
    def waitlist(self):
        """Gets the waitlist of this Trip.  # noqa: E501

        Keys list for orders, assigned to the performer, but not scheduled for a specific time.  # noqa: E501

        :return: The waitlist of this Trip.  # noqa: E501
        :rtype: list[str]
        """
        return self._waitlist

    @waitlist.setter
    def waitlist(self, waitlist):
        """Sets the waitlist of this Trip.

        Keys list for orders, assigned to the performer, but not scheduled for a specific time.  # noqa: E501

        :param waitlist: The waitlist of this Trip.  # noqa: E501
        :type: list[str]
        """

        self._waitlist = waitlist

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Trip):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Trip):
            return True

        return self.to_dict() != other.to_dict()
