# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class JobArraySpec(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'name': 'str',
        'config': 'JobConfiguration',
        'jobs': 'list[JobDataBinding]',
        'common_data': 'DataSpec'
    }

    attribute_map = {
        'name': 'name',
        'config': 'config',
        'jobs': 'jobs',
        'common_data': 'common_data'
    }

    def __init__(self, name='Job Array', config=None, jobs=None, common_data=None, local_vars_configuration=None):  # noqa: E501
        """JobArraySpec - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._config = None
        self._jobs = None
        self._common_data = None
        self.discriminator = None

        if name is not None:
            self.name = name
        self.config = config
        self.jobs = jobs
        if common_data is not None:
            self.common_data = common_data

    @property
    def name(self):
        """Gets the name of this JobArraySpec.  # noqa: E501

        Name of job array - only required for more than one job  # noqa: E501

        :return: The name of this JobArraySpec.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this JobArraySpec.

        Name of job array - only required for more than one job  # noqa: E501

        :param name: The name of this JobArraySpec.  # noqa: E501
        :type name: str
        """
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) > 100):
            raise ValueError("Invalid value for `name`, length must be less than or equal to `100`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                name is not None and len(name) < 1):
            raise ValueError("Invalid value for `name`, length must be greater than or equal to `1`")  # noqa: E501

        self._name = name

    @property
    def config(self):
        """Gets the config of this JobArraySpec.  # noqa: E501


        :return: The config of this JobArraySpec.  # noqa: E501
        :rtype: JobConfiguration
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this JobArraySpec.


        :param config: The config of this JobArraySpec.  # noqa: E501
        :type config: JobConfiguration
        """
        if self.local_vars_configuration.client_side_validation and config is None:  # noqa: E501
            raise ValueError("Invalid value for `config`, must not be `None`")  # noqa: E501

        self._config = config

    @property
    def jobs(self):
        """Gets the jobs of this JobArraySpec.  # noqa: E501

        List of job specs to launch  # noqa: E501

        :return: The jobs of this JobArraySpec.  # noqa: E501
        :rtype: list[JobDataBinding]
        """
        return self._jobs

    @jobs.setter
    def jobs(self, jobs):
        """Sets the jobs of this JobArraySpec.

        List of job specs to launch  # noqa: E501

        :param jobs: The jobs of this JobArraySpec.  # noqa: E501
        :type jobs: list[JobDataBinding]
        """
        if self.local_vars_configuration.client_side_validation and jobs is None:  # noqa: E501
            raise ValueError("Invalid value for `jobs`, must not be `None`")  # noqa: E501

        self._jobs = jobs

    @property
    def common_data(self):
        """Gets the common_data of this JobArraySpec.  # noqa: E501


        :return: The common_data of this JobArraySpec.  # noqa: E501
        :rtype: DataSpec
        """
        return self._common_data

    @common_data.setter
    def common_data(self, common_data):
        """Sets the common_data of this JobArraySpec.


        :param common_data: The common_data of this JobArraySpec.  # noqa: E501
        :type common_data: DataSpec
        """

        self._common_data = common_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobArraySpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobArraySpec):
            return True

        return self.to_dict() != other.to_dict()
