# coding: utf-8

"""
    EPIC API

    REST API for interacting with EPIC (https://epic.zenotech.com) services. <br />                             Please note this API is in BETA and does not yet contain                             all EPIC functionality.  # noqa: E501

    The version of the OpenAPI document: 2.0.0
    Contact: support@zenotech.com
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from epiccore.configuration import Configuration


class JobConfiguration(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'upload': 'list[str]',
        'overwrite_existing': 'bool',
        'data_sync_interval': 'int'
    }

    attribute_map = {
        'upload': 'upload',
        'overwrite_existing': 'overwrite_existing',
        'data_sync_interval': 'data_sync_interval'
    }

    def __init__(self, upload=None, overwrite_existing=True, data_sync_interval=None, local_vars_configuration=None):  # noqa: E501
        """JobConfiguration - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._upload = None
        self._overwrite_existing = None
        self._data_sync_interval = None
        self.discriminator = None

        if upload is not None:
            self.upload = upload
        if overwrite_existing is not None:
            self.overwrite_existing = overwrite_existing
        if data_sync_interval is not None:
            self.data_sync_interval = data_sync_interval

    @property
    def upload(self):
        """Gets the upload of this JobConfiguration.  # noqa: E501

        When should data be uploaded?  # noqa: E501

        :return: The upload of this JobConfiguration.  # noqa: E501
        :rtype: list[str]
        """
        return self._upload

    @upload.setter
    def upload(self, upload):
        """Sets the upload of this JobConfiguration.

        When should data be uploaded?  # noqa: E501

        :param upload: The upload of this JobConfiguration.  # noqa: E501
        :type upload: list[str]
        """
        allowed_values = ["complete", "failure", "cancel"]  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                not set(upload).issubset(set(allowed_values))):  # noqa: E501
            raise ValueError(
                "Invalid values for `upload` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(upload) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._upload = upload

    @property
    def overwrite_existing(self):
        """Gets the overwrite_existing of this JobConfiguration.  # noqa: E501

        Should uploads overwrite existing data files?  # noqa: E501

        :return: The overwrite_existing of this JobConfiguration.  # noqa: E501
        :rtype: bool
        """
        return self._overwrite_existing

    @overwrite_existing.setter
    def overwrite_existing(self, overwrite_existing):
        """Sets the overwrite_existing of this JobConfiguration.

        Should uploads overwrite existing data files?  # noqa: E501

        :param overwrite_existing: The overwrite_existing of this JobConfiguration.  # noqa: E501
        :type overwrite_existing: bool
        """

        self._overwrite_existing = overwrite_existing

    @property
    def data_sync_interval(self):
        """Gets the data_sync_interval of this JobConfiguration.  # noqa: E501

        How frequently should the data be uploaded back to the EPIC data store?  # noqa: E501

        :return: The data_sync_interval of this JobConfiguration.  # noqa: E501
        :rtype: int
        """
        return self._data_sync_interval

    @data_sync_interval.setter
    def data_sync_interval(self, data_sync_interval):
        """Sets the data_sync_interval of this JobConfiguration.

        How frequently should the data be uploaded back to the EPIC data store?  # noqa: E501

        :param data_sync_interval: The data_sync_interval of this JobConfiguration.  # noqa: E501
        :type data_sync_interval: int
        """
        if (self.local_vars_configuration.client_side_validation and
                data_sync_interval is not None and data_sync_interval < 0):  # noqa: E501
            raise ValueError("Invalid value for `data_sync_interval`, must be a value greater than or equal to `0`")  # noqa: E501

        self._data_sync_interval = data_sync_interval

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobConfiguration):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobConfiguration):
            return True

        return self.to_dict() != other.to_dict()
