# mypy-boto3-ec2

[![PyPI - mypy-boto3-ec2](https://img.shields.io/pypi/v/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.EC2 1.13.25](https://boto3.amazonaws.com/v1/documentation/api/1.13.25/reference/services/ec2.html#EC2) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `EC2` service.

```bash
python -m pip install boto3-stubs[ec2]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_ec2` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_ec2 import EC2Client

# Now mypy can check if your code is valid.
client: EC2Client = boto3.client("ec2")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EC2Client = session.client("ec2")

# Do you prefer resource approach? We've got you covered!
from mypy_boto3_ec2 import EC2ServiceResource

resource: ec2.EC2ServiceResource = boto3.resource("ec2")


# Waiters are also supported

import mypy_boto3_ec2.waiter as ec2_waiters

bundle_task_complete_waiter: ec2_waiters.BundleTaskCompleteWaiter = client.get_waiter("bundle_task_complete")
conversion_task_cancelled_waiter: ec2_waiters.ConversionTaskCancelledWaiter = client.get_waiter("conversion_task_cancelled")
conversion_task_completed_waiter: ec2_waiters.ConversionTaskCompletedWaiter = client.get_waiter("conversion_task_completed")
conversion_task_deleted_waiter: ec2_waiters.ConversionTaskDeletedWaiter = client.get_waiter("conversion_task_deleted")
customer_gateway_available_waiter: ec2_waiters.CustomerGatewayAvailableWaiter = client.get_waiter("customer_gateway_available")
export_task_cancelled_waiter: ec2_waiters.ExportTaskCancelledWaiter = client.get_waiter("export_task_cancelled")
export_task_completed_waiter: ec2_waiters.ExportTaskCompletedWaiter = client.get_waiter("export_task_completed")
image_available_waiter: ec2_waiters.ImageAvailableWaiter = client.get_waiter("image_available")
image_exists_waiter: ec2_waiters.ImageExistsWaiter = client.get_waiter("image_exists")
instance_exists_waiter: ec2_waiters.InstanceExistsWaiter = client.get_waiter("instance_exists")
instance_running_waiter: ec2_waiters.InstanceRunningWaiter = client.get_waiter("instance_running")
instance_status_ok_waiter: ec2_waiters.InstanceStatusOkWaiter = client.get_waiter("instance_status_ok")
instance_stopped_waiter: ec2_waiters.InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: ec2_waiters.InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
key_pair_exists_waiter: ec2_waiters.KeyPairExistsWaiter = client.get_waiter("key_pair_exists")
nat_gateway_available_waiter: ec2_waiters.NatGatewayAvailableWaiter = client.get_waiter("nat_gateway_available")
network_interface_available_waiter: ec2_waiters.NetworkInterfaceAvailableWaiter = client.get_waiter("network_interface_available")
password_data_available_waiter: ec2_waiters.PasswordDataAvailableWaiter = client.get_waiter("password_data_available")
security_group_exists_waiter: ec2_waiters.SecurityGroupExistsWaiter = client.get_waiter("security_group_exists")
snapshot_completed_waiter: ec2_waiters.SnapshotCompletedWaiter = client.get_waiter("snapshot_completed")
spot_instance_request_fulfilled_waiter: ec2_waiters.SpotInstanceRequestFulfilledWaiter = client.get_waiter("spot_instance_request_fulfilled")
subnet_available_waiter: ec2_waiters.SubnetAvailableWaiter = client.get_waiter("subnet_available")
system_status_ok_waiter: ec2_waiters.SystemStatusOkWaiter = client.get_waiter("system_status_ok")
volume_available_waiter: ec2_waiters.VolumeAvailableWaiter = client.get_waiter("volume_available")
volume_deleted_waiter: ec2_waiters.VolumeDeletedWaiter = client.get_waiter("volume_deleted")
volume_in_use_waiter: ec2_waiters.VolumeInUseWaiter = client.get_waiter("volume_in_use")
vpc_available_waiter: ec2_waiters.VpcAvailableWaiter = client.get_waiter("vpc_available")
vpc_exists_waiter: ec2_waiters.VpcExistsWaiter = client.get_waiter("vpc_exists")
vpc_peering_connection_deleted_waiter: ec2_waiters.VpcPeeringConnectionDeletedWaiter = client.get_waiter("vpc_peering_connection_deleted")
vpc_peering_connection_exists_waiter: ec2_waiters.VpcPeeringConnectionExistsWaiter = client.get_waiter("vpc_peering_connection_exists")
vpn_connection_available_waiter: ec2_waiters.VpnConnectionAvailableWaiter = client.get_waiter("vpn_connection_available")
vpn_connection_deleted_waiter: ec2_waiters.VpnConnectionDeletedWaiter = client.get_waiter("vpn_connection_deleted")


# Annotated paginators are included as well

import mypy_boto3_ec2.paginator as ec2_paginators

describe_byoip_cidrs_paginator: ec2_paginators.DescribeByoipCidrsPaginator = client.get_paginator("describe_byoip_cidrs")
describe_capacity_reservations_paginator: ec2_paginators.DescribeCapacityReservationsPaginator = client.get_paginator("describe_capacity_reservations")
describe_classic_link_instances_paginator: ec2_paginators.DescribeClassicLinkInstancesPaginator = client.get_paginator("describe_classic_link_instances")
describe_client_vpn_authorization_rules_paginator: ec2_paginators.DescribeClientVpnAuthorizationRulesPaginator = client.get_paginator("describe_client_vpn_authorization_rules")
describe_client_vpn_connections_paginator: ec2_paginators.DescribeClientVpnConnectionsPaginator = client.get_paginator("describe_client_vpn_connections")
describe_client_vpn_endpoints_paginator: ec2_paginators.DescribeClientVpnEndpointsPaginator = client.get_paginator("describe_client_vpn_endpoints")
describe_client_vpn_routes_paginator: ec2_paginators.DescribeClientVpnRoutesPaginator = client.get_paginator("describe_client_vpn_routes")
describe_client_vpn_target_networks_paginator: ec2_paginators.DescribeClientVpnTargetNetworksPaginator = client.get_paginator("describe_client_vpn_target_networks")
describe_coip_pools_paginator: ec2_paginators.DescribeCoipPoolsPaginator = client.get_paginator("describe_coip_pools")
describe_dhcp_options_paginator: ec2_paginators.DescribeDhcpOptionsPaginator = client.get_paginator("describe_dhcp_options")
describe_egress_only_internet_gateways_paginator: ec2_paginators.DescribeEgressOnlyInternetGatewaysPaginator = client.get_paginator("describe_egress_only_internet_gateways")
describe_export_image_tasks_paginator: ec2_paginators.DescribeExportImageTasksPaginator = client.get_paginator("describe_export_image_tasks")
describe_fast_snapshot_restores_paginator: ec2_paginators.DescribeFastSnapshotRestoresPaginator = client.get_paginator("describe_fast_snapshot_restores")
describe_fleets_paginator: ec2_paginators.DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_flow_logs_paginator: ec2_paginators.DescribeFlowLogsPaginator = client.get_paginator("describe_flow_logs")
describe_fpga_images_paginator: ec2_paginators.DescribeFpgaImagesPaginator = client.get_paginator("describe_fpga_images")
describe_host_reservation_offerings_paginator: ec2_paginators.DescribeHostReservationOfferingsPaginator = client.get_paginator("describe_host_reservation_offerings")
describe_host_reservations_paginator: ec2_paginators.DescribeHostReservationsPaginator = client.get_paginator("describe_host_reservations")
describe_hosts_paginator: ec2_paginators.DescribeHostsPaginator = client.get_paginator("describe_hosts")
describe_iam_instance_profile_associations_paginator: ec2_paginators.DescribeIamInstanceProfileAssociationsPaginator = client.get_paginator("describe_iam_instance_profile_associations")
describe_import_image_tasks_paginator: ec2_paginators.DescribeImportImageTasksPaginator = client.get_paginator("describe_import_image_tasks")
describe_import_snapshot_tasks_paginator: ec2_paginators.DescribeImportSnapshotTasksPaginator = client.get_paginator("describe_import_snapshot_tasks")
describe_instance_credit_specifications_paginator: ec2_paginators.DescribeInstanceCreditSpecificationsPaginator = client.get_paginator("describe_instance_credit_specifications")
describe_instance_status_paginator: ec2_paginators.DescribeInstanceStatusPaginator = client.get_paginator("describe_instance_status")
describe_instance_type_offerings_paginator: ec2_paginators.DescribeInstanceTypeOfferingsPaginator = client.get_paginator("describe_instance_type_offerings")
describe_instance_types_paginator: ec2_paginators.DescribeInstanceTypesPaginator = client.get_paginator("describe_instance_types")
describe_instances_paginator: ec2_paginators.DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_internet_gateways_paginator: ec2_paginators.DescribeInternetGatewaysPaginator = client.get_paginator("describe_internet_gateways")
describe_ipv6_pools_paginator: ec2_paginators.DescribeIpv6PoolsPaginator = client.get_paginator("describe_ipv6_pools")
describe_launch_template_versions_paginator: ec2_paginators.DescribeLaunchTemplateVersionsPaginator = client.get_paginator("describe_launch_template_versions")
describe_launch_templates_paginator: ec2_paginators.DescribeLaunchTemplatesPaginator = client.get_paginator("describe_launch_templates")
describe_local_gateway_route_table_virtual_interface_group_associations_paginator: ec2_paginators.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_virtual_interface_group_associations")
describe_local_gateway_route_table_vpc_associations_paginator: ec2_paginators.DescribeLocalGatewayRouteTableVpcAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_vpc_associations")
describe_local_gateway_route_tables_paginator: ec2_paginators.DescribeLocalGatewayRouteTablesPaginator = client.get_paginator("describe_local_gateway_route_tables")
describe_local_gateway_virtual_interface_groups_paginator: ec2_paginators.DescribeLocalGatewayVirtualInterfaceGroupsPaginator = client.get_paginator("describe_local_gateway_virtual_interface_groups")
describe_local_gateway_virtual_interfaces_paginator: ec2_paginators.DescribeLocalGatewayVirtualInterfacesPaginator = client.get_paginator("describe_local_gateway_virtual_interfaces")
describe_local_gateways_paginator: ec2_paginators.DescribeLocalGatewaysPaginator = client.get_paginator("describe_local_gateways")
describe_moving_addresses_paginator: ec2_paginators.DescribeMovingAddressesPaginator = client.get_paginator("describe_moving_addresses")
describe_nat_gateways_paginator: ec2_paginators.DescribeNatGatewaysPaginator = client.get_paginator("describe_nat_gateways")
describe_network_acls_paginator: ec2_paginators.DescribeNetworkAclsPaginator = client.get_paginator("describe_network_acls")
describe_network_interface_permissions_paginator: ec2_paginators.DescribeNetworkInterfacePermissionsPaginator = client.get_paginator("describe_network_interface_permissions")
describe_network_interfaces_paginator: ec2_paginators.DescribeNetworkInterfacesPaginator = client.get_paginator("describe_network_interfaces")
describe_prefix_lists_paginator: ec2_paginators.DescribePrefixListsPaginator = client.get_paginator("describe_prefix_lists")
describe_principal_id_format_paginator: ec2_paginators.DescribePrincipalIdFormatPaginator = client.get_paginator("describe_principal_id_format")
describe_public_ipv4_pools_paginator: ec2_paginators.DescribePublicIpv4PoolsPaginator = client.get_paginator("describe_public_ipv4_pools")
describe_reserved_instances_modifications_paginator: ec2_paginators.DescribeReservedInstancesModificationsPaginator = client.get_paginator("describe_reserved_instances_modifications")
describe_reserved_instances_offerings_paginator: ec2_paginators.DescribeReservedInstancesOfferingsPaginator = client.get_paginator("describe_reserved_instances_offerings")
describe_route_tables_paginator: ec2_paginators.DescribeRouteTablesPaginator = client.get_paginator("describe_route_tables")
describe_scheduled_instance_availability_paginator: ec2_paginators.DescribeScheduledInstanceAvailabilityPaginator = client.get_paginator("describe_scheduled_instance_availability")
describe_scheduled_instances_paginator: ec2_paginators.DescribeScheduledInstancesPaginator = client.get_paginator("describe_scheduled_instances")
describe_security_groups_paginator: ec2_paginators.DescribeSecurityGroupsPaginator = client.get_paginator("describe_security_groups")
describe_snapshots_paginator: ec2_paginators.DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_spot_fleet_instances_paginator: ec2_paginators.DescribeSpotFleetInstancesPaginator = client.get_paginator("describe_spot_fleet_instances")
describe_spot_fleet_requests_paginator: ec2_paginators.DescribeSpotFleetRequestsPaginator = client.get_paginator("describe_spot_fleet_requests")
describe_spot_instance_requests_paginator: ec2_paginators.DescribeSpotInstanceRequestsPaginator = client.get_paginator("describe_spot_instance_requests")
describe_spot_price_history_paginator: ec2_paginators.DescribeSpotPriceHistoryPaginator = client.get_paginator("describe_spot_price_history")
describe_stale_security_groups_paginator: ec2_paginators.DescribeStaleSecurityGroupsPaginator = client.get_paginator("describe_stale_security_groups")
describe_subnets_paginator: ec2_paginators.DescribeSubnetsPaginator = client.get_paginator("describe_subnets")
describe_tags_paginator: ec2_paginators.DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_traffic_mirror_filters_paginator: ec2_paginators.DescribeTrafficMirrorFiltersPaginator = client.get_paginator("describe_traffic_mirror_filters")
describe_traffic_mirror_sessions_paginator: ec2_paginators.DescribeTrafficMirrorSessionsPaginator = client.get_paginator("describe_traffic_mirror_sessions")
describe_traffic_mirror_targets_paginator: ec2_paginators.DescribeTrafficMirrorTargetsPaginator = client.get_paginator("describe_traffic_mirror_targets")
describe_transit_gateway_attachments_paginator: ec2_paginators.DescribeTransitGatewayAttachmentsPaginator = client.get_paginator("describe_transit_gateway_attachments")
describe_transit_gateway_multicast_domains_paginator: ec2_paginators.DescribeTransitGatewayMulticastDomainsPaginator = client.get_paginator("describe_transit_gateway_multicast_domains")
describe_transit_gateway_peering_attachments_paginator: ec2_paginators.DescribeTransitGatewayPeeringAttachmentsPaginator = client.get_paginator("describe_transit_gateway_peering_attachments")
describe_transit_gateway_route_tables_paginator: ec2_paginators.DescribeTransitGatewayRouteTablesPaginator = client.get_paginator("describe_transit_gateway_route_tables")
describe_transit_gateway_vpc_attachments_paginator: ec2_paginators.DescribeTransitGatewayVpcAttachmentsPaginator = client.get_paginator("describe_transit_gateway_vpc_attachments")
describe_transit_gateways_paginator: ec2_paginators.DescribeTransitGatewaysPaginator = client.get_paginator("describe_transit_gateways")
describe_volume_status_paginator: ec2_paginators.DescribeVolumeStatusPaginator = client.get_paginator("describe_volume_status")
describe_volumes_paginator: ec2_paginators.DescribeVolumesPaginator = client.get_paginator("describe_volumes")
describe_volumes_modifications_paginator: ec2_paginators.DescribeVolumesModificationsPaginator = client.get_paginator("describe_volumes_modifications")
describe_vpc_classic_link_dns_support_paginator: ec2_paginators.DescribeVpcClassicLinkDnsSupportPaginator = client.get_paginator("describe_vpc_classic_link_dns_support")
describe_vpc_endpoint_connection_notifications_paginator: ec2_paginators.DescribeVpcEndpointConnectionNotificationsPaginator = client.get_paginator("describe_vpc_endpoint_connection_notifications")
describe_vpc_endpoint_connections_paginator: ec2_paginators.DescribeVpcEndpointConnectionsPaginator = client.get_paginator("describe_vpc_endpoint_connections")
describe_vpc_endpoint_service_configurations_paginator: ec2_paginators.DescribeVpcEndpointServiceConfigurationsPaginator = client.get_paginator("describe_vpc_endpoint_service_configurations")
describe_vpc_endpoint_service_permissions_paginator: ec2_paginators.DescribeVpcEndpointServicePermissionsPaginator = client.get_paginator("describe_vpc_endpoint_service_permissions")
describe_vpc_endpoint_services_paginator: ec2_paginators.DescribeVpcEndpointServicesPaginator = client.get_paginator("describe_vpc_endpoint_services")
describe_vpc_endpoints_paginator: ec2_paginators.DescribeVpcEndpointsPaginator = client.get_paginator("describe_vpc_endpoints")
describe_vpc_peering_connections_paginator: ec2_paginators.DescribeVpcPeeringConnectionsPaginator = client.get_paginator("describe_vpc_peering_connections")
describe_vpcs_paginator: ec2_paginators.DescribeVpcsPaginator = client.get_paginator("describe_vpcs")
get_associated_ipv6_pool_cidrs_paginator: ec2_paginators.GetAssociatedIpv6PoolCidrsPaginator = client.get_paginator("get_associated_ipv6_pool_cidrs")
get_transit_gateway_attachment_propagations_paginator: ec2_paginators.GetTransitGatewayAttachmentPropagationsPaginator = client.get_paginator("get_transit_gateway_attachment_propagations")
get_transit_gateway_multicast_domain_associations_paginator: ec2_paginators.GetTransitGatewayMulticastDomainAssociationsPaginator = client.get_paginator("get_transit_gateway_multicast_domain_associations")
get_transit_gateway_route_table_associations_paginator: ec2_paginators.GetTransitGatewayRouteTableAssociationsPaginator = client.get_paginator("get_transit_gateway_route_table_associations")
get_transit_gateway_route_table_propagations_paginator: ec2_paginators.GetTransitGatewayRouteTablePropagationsPaginator = client.get_paginator("get_transit_gateway_route_table_propagations")
search_local_gateway_routes_paginator: ec2_paginators.SearchLocalGatewayRoutesPaginator = client.get_paginator("search_local_gateway_routes")
search_transit_gateway_multicast_groups_paginator: ec2_paginators.SearchTransitGatewayMulticastGroupsPaginator = client.get_paginator("search_transit_gateway_multicast_groups")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_ec2` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_ec2 as ec2
from mypy_boto3_ec2 import EC2Client

# with these
from mypy_boto3 import ec2
from mypy_boto3.ec2 import EC2Client
```