import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineServiceNetworkSettingsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#project AppEngineServiceNetworkSettings#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the service these settings apply to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#service AppEngineServiceNetworkSettings#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * network_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#network_settings AppEngineServiceNetworkSettings#network_settings}
     *
     * @stability stable
     */
    readonly networkSettings: AppEngineServiceNetworkSettingsNetworkSettings;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#timeouts AppEngineServiceNetworkSettings#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineServiceNetworkSettingsTimeouts;
}
/**
 * @stability stable
 */
export interface AppEngineServiceNetworkSettingsNetworkSettings {
    /**
     * The ingress settings for version or service. Default value: "INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED" Possible values: ["INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED", "INGRESS_TRAFFIC_ALLOWED_ALL", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_ONLY", "INGRESS_TRAFFIC_ALLOWED_INTERNAL_AND_LB"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#ingress_traffic_allowed AppEngineServiceNetworkSettings#ingress_traffic_allowed}
     *
     * @stability stable
     */
    readonly ingressTrafficAllowed?: string;
}
export declare function appEngineServiceNetworkSettingsNetworkSettingsToTerraform(struct?: AppEngineServiceNetworkSettingsNetworkSettingsOutputReference | AppEngineServiceNetworkSettingsNetworkSettings): any;
/**
 * @stability stable
 */
export declare class AppEngineServiceNetworkSettingsNetworkSettingsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineServiceNetworkSettingsNetworkSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineServiceNetworkSettingsNetworkSettings | undefined);
    private _ingressTrafficAllowed?;
    /**
     * @stability stable
     */
    get ingressTrafficAllowed(): string;
    /**
     * @stability stable
     */
    set ingressTrafficAllowed(value: string);
    /**
     * @stability stable
     */
    resetIngressTrafficAllowed(): void;
    /**
     * @stability stable
     */
    get ingressTrafficAllowedInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineServiceNetworkSettingsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#create AppEngineServiceNetworkSettings#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#delete AppEngineServiceNetworkSettings#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html#update AppEngineServiceNetworkSettings#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appEngineServiceNetworkSettingsTimeoutsToTerraform(struct?: AppEngineServiceNetworkSettingsTimeoutsOutputReference | AppEngineServiceNetworkSettingsTimeouts): any;
/**
 * @stability stable
 */
export declare class AppEngineServiceNetworkSettingsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineServiceNetworkSettingsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineServiceNetworkSettingsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html google_app_engine_service_network_settings}.
 *
 * @stability stable
 */
export declare class AppEngineServiceNetworkSettings extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_service_network_settings.html google_app_engine_service_network_settings} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineServiceNetworkSettingsConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _networkSettings;
    /**
     * @stability stable
     */
    get networkSettings(): AppEngineServiceNetworkSettingsNetworkSettingsOutputReference;
    /**
     * @stability stable
     */
    putNetworkSettings(value: AppEngineServiceNetworkSettingsNetworkSettings): void;
    /**
     * @stability stable
     */
    get networkSettingsInput(): AppEngineServiceNetworkSettingsNetworkSettings | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineServiceNetworkSettingsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppEngineServiceNetworkSettingsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineServiceNetworkSettingsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
