import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BigqueryRoutineConfig extends cdktf.TerraformMetaArguments {
    /**
     * The ID of the dataset containing this routine.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#dataset_id BigqueryRoutine#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
    /**
     * The body of the routine.
     *
     * For functions, this is the expression in the AS clause.
     * If language=SQL, it is the substring inside (but excluding) the parentheses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#definition_body BigqueryRoutine#definition_body}
     *
     * @stability stable
     */
    readonly definitionBody: string;
    /**
     * The description of the routine if defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#description BigqueryRoutine#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The determinism level of the JavaScript UDF if defined. Possible values: ["DETERMINISM_LEVEL_UNSPECIFIED", "DETERMINISTIC", "NOT_DETERMINISTIC"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#determinism_level BigqueryRoutine#determinism_level}
     *
     * @stability stable
     */
    readonly determinismLevel?: string;
    /**
     * Optional. If language = "JAVASCRIPT", this field stores the path of the imported JAVASCRIPT libraries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#imported_libraries BigqueryRoutine#imported_libraries}
     *
     * @stability stable
     */
    readonly importedLibraries?: string[];
    /**
     * The language of the routine. Possible values: ["SQL", "JAVASCRIPT"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#language BigqueryRoutine#language}
     *
     * @stability stable
     */
    readonly language?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#project BigqueryRoutine#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A JSON schema for the return type.
     *
     * Optional if language = "SQL"; required otherwise.
     * If absent, the return type is inferred from definitionBody at query time in each query
     * that references this routine. If present, then the evaluated result will be cast to
     * the specified returned type at query time. ~>**NOTE**: Because this field expects a JSON
     * string, any changes to the string will create a diff, even if the JSON itself hasn't
     * changed. If the API returns a different value for the same schema, e.g. it switche
     * d the order of values or replaced STRUCT field type with RECORD field type, we currently
     * cannot suppress the recurring diff this causes. As a workaround, we recommend using
     * the schema as returned by the API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#return_type BigqueryRoutine#return_type}
     *
     * @stability stable
     */
    readonly returnType?: string;
    /**
     * The ID of the the routine.
     *
     * The ID must contain only letters (a-z, A-Z), numbers (0-9), or underscores (_). The maximum length is 256 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#routine_id BigqueryRoutine#routine_id}
     *
     * @stability stable
     */
    readonly routineId: string;
    /**
     * The type of routine. Possible values: ["SCALAR_FUNCTION", "PROCEDURE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#routine_type BigqueryRoutine#routine_type}
     *
     * @stability stable
     */
    readonly routineType?: string;
    /**
     * arguments block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#arguments BigqueryRoutine#arguments}
     *
     * @stability stable
     */
    readonly arguments?: BigqueryRoutineArguments[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#timeouts BigqueryRoutine#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BigqueryRoutineTimeouts;
}
/**
 * @stability stable
 */
export interface BigqueryRoutineArguments {
    /**
     * Defaults to FIXED_TYPE. Default value: "FIXED_TYPE" Possible values: ["FIXED_TYPE", "ANY_TYPE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#argument_kind BigqueryRoutine#argument_kind}
     *
     * @stability stable
     */
    readonly argumentKind?: string;
    /**
     * A JSON schema for the data type.
     *
     * Required unless argumentKind = ANY_TYPE.
     * ~>**NOTE**: Because this field expects a JSON string, any changes to the string
     * will create a diff, even if the JSON itself hasn't changed. If the API returns
     * a different value for the same schema, e.g. it switched the order of values
     * or replaced STRUCT field type with RECORD field type, we currently cannot
     * suppress the recurring diff this causes. As a workaround, we recommend using
     * the schema as returned by the API.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#data_type BigqueryRoutine#data_type}
     *
     * @stability stable
     */
    readonly dataType?: string;
    /**
     * Specifies whether the argument is input or output. Can be set for procedures only. Possible values: ["IN", "OUT", "INOUT"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#mode BigqueryRoutine#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * The name of this argument. Can be absent for function return argument.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#name BigqueryRoutine#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
export declare function bigqueryRoutineArgumentsToTerraform(struct?: BigqueryRoutineArguments): any;
/**
 * @stability stable
 */
export interface BigqueryRoutineTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#create BigqueryRoutine#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#delete BigqueryRoutine#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html#update BigqueryRoutine#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function bigqueryRoutineTimeoutsToTerraform(struct?: BigqueryRoutineTimeoutsOutputReference | BigqueryRoutineTimeouts): any;
/**
 * @stability stable
 */
export declare class BigqueryRoutineTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BigqueryRoutineTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BigqueryRoutineTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html google_bigquery_routine}.
 *
 * @stability stable
 */
export declare class BigqueryRoutine extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_routine.html google_bigquery_routine} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BigqueryRoutineConfig);
    /**
     * @stability stable
     */
    get creationTime(): number;
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
    private _definitionBody?;
    /**
     * @stability stable
     */
    get definitionBody(): string;
    /**
     * @stability stable
     */
    set definitionBody(value: string);
    /**
     * @stability stable
     */
    get definitionBodyInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _determinismLevel?;
    /**
     * @stability stable
     */
    get determinismLevel(): string;
    /**
     * @stability stable
     */
    set determinismLevel(value: string);
    /**
     * @stability stable
     */
    resetDeterminismLevel(): void;
    /**
     * @stability stable
     */
    get determinismLevelInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _importedLibraries?;
    /**
     * @stability stable
     */
    get importedLibraries(): string[];
    /**
     * @stability stable
     */
    set importedLibraries(value: string[]);
    /**
     * @stability stable
     */
    resetImportedLibraries(): void;
    /**
     * @stability stable
     */
    get importedLibrariesInput(): string[] | undefined;
    private _language?;
    /**
     * @stability stable
     */
    get language(): string;
    /**
     * @stability stable
     */
    set language(value: string);
    /**
     * @stability stable
     */
    resetLanguage(): void;
    /**
     * @stability stable
     */
    get languageInput(): string | undefined;
    /**
     * @stability stable
     */
    get lastModifiedTime(): number;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _returnType?;
    /**
     * @stability stable
     */
    get returnType(): string;
    /**
     * @stability stable
     */
    set returnType(value: string);
    /**
     * @stability stable
     */
    resetReturnType(): void;
    /**
     * @stability stable
     */
    get returnTypeInput(): string | undefined;
    private _routineId?;
    /**
     * @stability stable
     */
    get routineId(): string;
    /**
     * @stability stable
     */
    set routineId(value: string);
    /**
     * @stability stable
     */
    get routineIdInput(): string | undefined;
    private _routineType?;
    /**
     * @stability stable
     */
    get routineType(): string;
    /**
     * @stability stable
     */
    set routineType(value: string);
    /**
     * @stability stable
     */
    resetRoutineType(): void;
    /**
     * @stability stable
     */
    get routineTypeInput(): string | undefined;
    private _arguments?;
    /**
     * @stability stable
     */
    get arguments(): BigqueryRoutineArguments[];
    /**
     * @stability stable
     */
    set arguments(value: BigqueryRoutineArguments[]);
    /**
     * @stability stable
     */
    resetArguments(): void;
    /**
     * @stability stable
     */
    get argumentsInput(): BigqueryRoutineArguments[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BigqueryRoutineTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BigqueryRoutineTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BigqueryRoutineTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
