import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BillingAccountIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#billing_account_id BillingAccountIamMember#billing_account_id}.
     *
     * @stability stable
     */
    readonly billingAccountId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#member BillingAccountIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#role BillingAccountIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#condition BillingAccountIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: BillingAccountIamMemberCondition;
}
/**
 * @stability stable
 */
export interface BillingAccountIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#description BillingAccountIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#expression BillingAccountIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html#title BillingAccountIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function billingAccountIamMemberConditionToTerraform(struct?: BillingAccountIamMemberConditionOutputReference | BillingAccountIamMemberCondition): any;
/**
 * @stability stable
 */
export declare class BillingAccountIamMemberConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BillingAccountIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BillingAccountIamMemberCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html google_billing_account_iam_member}.
 *
 * @stability stable
 */
export declare class BillingAccountIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_account_iam_member.html google_billing_account_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BillingAccountIamMemberConfig);
    private _billingAccountId?;
    /**
     * @stability stable
     */
    get billingAccountId(): string;
    /**
     * @stability stable
     */
    set billingAccountId(value: string);
    /**
     * @stability stable
     */
    get billingAccountIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): BillingAccountIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: BillingAccountIamMemberCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): BillingAccountIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
