import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface CloudRunServiceIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#location CloudRunServiceIamMember#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#member CloudRunServiceIamMember#member}.
     *
     * @stability stable
     */
    readonly member: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#project CloudRunServiceIamMember#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#role CloudRunServiceIamMember#role}.
     *
     * @stability stable
     */
    readonly role: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#service CloudRunServiceIamMember#service}.
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#condition CloudRunServiceIamMember#condition}
     *
     * @stability stable
     */
    readonly condition?: CloudRunServiceIamMemberCondition;
}
/**
 * @stability stable
 */
export interface CloudRunServiceIamMemberCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#description CloudRunServiceIamMember#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#expression CloudRunServiceIamMember#expression}.
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html#title CloudRunServiceIamMember#title}.
     *
     * @stability stable
     */
    readonly title: string;
}
export declare function cloudRunServiceIamMemberConditionToTerraform(struct?: CloudRunServiceIamMemberConditionOutputReference | CloudRunServiceIamMemberCondition): any;
/**
 * @stability stable
 */
export declare class CloudRunServiceIamMemberConditionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): CloudRunServiceIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: CloudRunServiceIamMemberCondition | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html google_cloud_run_service_iam_member}.
 *
 * @stability stable
 */
export declare class CloudRunServiceIamMember extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/cloud_run_service_iam_member.html google_cloud_run_service_iam_member} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: CloudRunServiceIamMemberConfig);
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _member?;
    /**
     * @stability stable
     */
    get member(): string;
    /**
     * @stability stable
     */
    set member(value: string);
    /**
     * @stability stable
     */
    get memberInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _role?;
    /**
     * @stability stable
     */
    get role(): string;
    /**
     * @stability stable
     */
    set role(value: string);
    /**
     * @stability stable
     */
    get roleInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _condition;
    /**
     * @stability stable
     */
    get condition(): CloudRunServiceIamMemberConditionOutputReference;
    /**
     * @stability stable
     */
    putCondition(value: CloudRunServiceIamMemberCondition): void;
    /**
     * @stability stable
     */
    resetCondition(): void;
    /**
     * @stability stable
     */
    get conditionInput(): CloudRunServiceIamMemberCondition | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
