import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleStorageBucketObjectConfig extends cdktf.TerraformMetaArguments {
    /**
     * The name of the containing bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html#bucket DataGoogleStorageBucketObject#bucket}
     *
     * @stability stable
     */
    readonly bucket?: string;
    /**
     * The name of the object. If you're interpolating the name of this object, see output_name instead.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html#name DataGoogleStorageBucketObject#name}
     *
     * @stability stable
     */
    readonly name?: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleStorageBucketObjectCustomerEncryption extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get encryptionAlgorithm(): string;
    /**
     * @stability stable
     */
    get encryptionKey(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html google_storage_bucket_object}.
 *
 * @stability stable
 */
export declare class DataGoogleStorageBucketObject extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/storage_bucket_object.html google_storage_bucket_object} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: DataGoogleStorageBucketObjectConfig);
    private _bucket?;
    /**
     * @stability stable
     */
    get bucket(): string;
    /**
     * @stability stable
     */
    set bucket(value: string);
    /**
     * @stability stable
     */
    resetBucket(): void;
    /**
     * @stability stable
     */
    get bucketInput(): string | undefined;
    /**
     * @stability stable
     */
    get cacheControl(): string;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    get contentDisposition(): string;
    /**
     * @stability stable
     */
    get contentEncoding(): string;
    /**
     * @stability stable
     */
    get contentLanguage(): string;
    /**
     * @stability stable
     */
    get contentType(): string;
    /**
     * @stability stable
     */
    get crc32C(): string;
    /**
     * @stability stable
     */
    customerEncryption(index: string): DataGoogleStorageBucketObjectCustomerEncryption;
    /**
     * @stability stable
     */
    get detectMd5Hash(): string;
    /**
     * @stability stable
     */
    get eventBasedHold(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kmsKeyName(): string;
    /**
     * @stability stable
     */
    get md5Hash(): string;
    /**
     * @stability stable
     */
    get mediaLink(): string;
    /**
     * @stability stable
     */
    metadata(key: string): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    resetName(): void;
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outputName(): string;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get source(): string;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    get temporaryHold(): any;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
