import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IdentityPlatformTenantDefaultSupportedIdpConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * OAuth client ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#client_id IdentityPlatformTenantDefaultSupportedIdpConfig#client_id}
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * OAuth client secret.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#client_secret IdentityPlatformTenantDefaultSupportedIdpConfig#client_secret}
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * If this IDP allows the user to sign in.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#enabled IdentityPlatformTenantDefaultSupportedIdpConfig#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * ID of the IDP. Possible values include:.
     *
     * 'apple.com'
     *
     * 'facebook.com'
     *
     * 'gc.apple.com'
     *
     * 'github.com'
     *
     * 'google.com'
     *
     * 'linkedin.com'
     *
     * 'microsoft.com'
     *
     * 'playgames.google.com'
     *
     * 'twitter.com'
     *
     * 'yahoo.com'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#idp_id IdentityPlatformTenantDefaultSupportedIdpConfig#idp_id}
     *
     * @stability stable
     */
    readonly idpId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#project IdentityPlatformTenantDefaultSupportedIdpConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The name of the tenant where this DefaultSupportedIdpConfig resource exists.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#tenant IdentityPlatformTenantDefaultSupportedIdpConfig#tenant}
     *
     * @stability stable
     */
    readonly tenant: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#timeouts IdentityPlatformTenantDefaultSupportedIdpConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts;
}
/**
 * @stability stable
 */
export interface IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#create IdentityPlatformTenantDefaultSupportedIdpConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#delete IdentityPlatformTenantDefaultSupportedIdpConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html#update IdentityPlatformTenantDefaultSupportedIdpConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function identityPlatformTenantDefaultSupportedIdpConfigTimeoutsToTerraform(struct?: IdentityPlatformTenantDefaultSupportedIdpConfigTimeoutsOutputReference | IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class IdentityPlatformTenantDefaultSupportedIdpConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html google_identity_platform_tenant_default_supported_idp_config}.
 *
 * @stability stable
 */
export declare class IdentityPlatformTenantDefaultSupportedIdpConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/identity_platform_tenant_default_supported_idp_config.html google_identity_platform_tenant_default_supported_idp_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IdentityPlatformTenantDefaultSupportedIdpConfigConfig);
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _idpId?;
    /**
     * @stability stable
     */
    get idpId(): string;
    /**
     * @stability stable
     */
    set idpId(value: string);
    /**
     * @stability stable
     */
    get idpIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _tenant?;
    /**
     * @stability stable
     */
    get tenant(): string;
    /**
     * @stability stable
     */
    set tenant(value: string);
    /**
     * @stability stable
     */
    get tenantInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IdentityPlatformTenantDefaultSupportedIdpConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IdentityPlatformTenantDefaultSupportedIdpConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
