import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface LoggingProjectSinkConfig extends cdktf.TerraformMetaArguments {
    /**
     * A description of this sink. The maximum length of the description is 8000 characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#description LoggingProjectSink#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The destination of the sink (or, in other words, where logs are written to).
     *
     * Can be a Cloud Storage bucket, a PubSub topic, or a BigQuery dataset. Examples: "storage.googleapis.com/[GCS_BUCKET]" "bigquery.googleapis.com/projects/[PROJECT_ID]/datasets/[DATASET]" "pubsub.googleapis.com/projects/[PROJECT_ID]/topics/[TOPIC_ID]" The writer associated with the sink must have access to write to the above resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#destination LoggingProjectSink#destination}
     *
     * @stability stable
     */
    readonly destination: string;
    /**
     * If set to True, then this sink is disabled and it does not export any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#disabled LoggingProjectSink#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * The filter to apply when exporting logs. Only log entries that match the filter are exported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#filter LoggingProjectSink#filter}
     *
     * @stability stable
     */
    readonly filter?: string;
    /**
     * The name of the logging sink.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#name LoggingProjectSink#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project to create the sink in.
     *
     * If omitted, the project associated with the provider is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#project LoggingProjectSink#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Whether or not to create a unique identity associated with this sink.
     *
     * If false (the default), then the writer_identity used is serviceAccount:cloud-logs@system.gserviceaccount.com. If true, then a unique service account is created and used for this sink. If you wish to publish logs across projects, you must set unique_writer_identity to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#unique_writer_identity LoggingProjectSink#unique_writer_identity}
     *
     * @stability stable
     */
    readonly uniqueWriterIdentity?: boolean | cdktf.IResolvable;
    /**
     * bigquery_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#bigquery_options LoggingProjectSink#bigquery_options}
     *
     * @stability stable
     */
    readonly bigqueryOptions?: LoggingProjectSinkBigqueryOptions;
    /**
     * exclusions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#exclusions LoggingProjectSink#exclusions}
     *
     * @stability stable
     */
    readonly exclusions?: LoggingProjectSinkExclusions[];
}
/**
 * @stability stable
 */
export interface LoggingProjectSinkBigqueryOptions {
    /**
     * Whether to use BigQuery's partition tables.
     *
     * By default, Logging creates dated tables based on the log entries' timestamps, e.g. syslog_20170523. With partitioned tables the date suffix is no longer present and special query syntax has to be used instead. In both cases, tables are sharded based on UTC timezone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#use_partitioned_tables LoggingProjectSink#use_partitioned_tables}
     *
     * @stability stable
     */
    readonly usePartitionedTables: boolean | cdktf.IResolvable;
}
export declare function loggingProjectSinkBigqueryOptionsToTerraform(struct?: LoggingProjectSinkBigqueryOptionsOutputReference | LoggingProjectSinkBigqueryOptions): any;
/**
 * @stability stable
 */
export declare class LoggingProjectSinkBigqueryOptionsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): LoggingProjectSinkBigqueryOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: LoggingProjectSinkBigqueryOptions | undefined);
    private _usePartitionedTables?;
    /**
     * @stability stable
     */
    get usePartitionedTables(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set usePartitionedTables(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get usePartitionedTablesInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface LoggingProjectSinkExclusions {
    /**
     * A description of this exclusion.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#description LoggingProjectSink#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * If set to True, then this exclusion is disabled and it does not exclude any log entries.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#disabled LoggingProjectSink#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * An advanced logs filter that matches the log entries to be excluded.
     *
     * By using the sample function, you can exclude less than 100% of the matching log entries
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#filter LoggingProjectSink#filter}
     *
     * @stability stable
     */
    readonly filter: string;
    /**
     * A client-assigned identifier, such as "load-balancer-exclusion".
     *
     * Identifiers are limited to 100 characters and can include only letters, digits, underscores, hyphens, and periods. First character has to be alphanumeric.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html#name LoggingProjectSink#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function loggingProjectSinkExclusionsToTerraform(struct?: LoggingProjectSinkExclusions): any;
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html google_logging_project_sink}.
 *
 * @stability stable
 */
export declare class LoggingProjectSink extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/logging_project_sink.html google_logging_project_sink} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: LoggingProjectSinkConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _destination?;
    /**
     * @stability stable
     */
    get destination(): string;
    /**
     * @stability stable
     */
    set destination(value: string);
    /**
     * @stability stable
     */
    get destinationInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _uniqueWriterIdentity?;
    /**
     * @stability stable
     */
    get uniqueWriterIdentity(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set uniqueWriterIdentity(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUniqueWriterIdentity(): void;
    /**
     * @stability stable
     */
    get uniqueWriterIdentityInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get writerIdentity(): string;
    private _bigqueryOptions;
    /**
     * @stability stable
     */
    get bigqueryOptions(): LoggingProjectSinkBigqueryOptionsOutputReference;
    /**
     * @stability stable
     */
    putBigqueryOptions(value: LoggingProjectSinkBigqueryOptions): void;
    /**
     * @stability stable
     */
    resetBigqueryOptions(): void;
    /**
     * @stability stable
     */
    get bigqueryOptionsInput(): LoggingProjectSinkBigqueryOptions | undefined;
    private _exclusions?;
    /**
     * @stability stable
     */
    get exclusions(): LoggingProjectSinkExclusions[];
    /**
     * @stability stable
     */
    set exclusions(value: LoggingProjectSinkExclusions[]);
    /**
     * @stability stable
     */
    resetExclusions(): void;
    /**
     * @stability stable
     */
    get exclusionsInput(): LoggingProjectSinkExclusions[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
