import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheKeysetConfig extends cdktf.TerraformMetaArguments {
    /**
     * A human-readable description of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#description NetworkServicesEdgeCacheKeyset#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Set of label tags associated with the EdgeCache resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#labels NetworkServicesEdgeCacheKeyset#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource;
     *
     * provided by the client when the resource is created.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
     * and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#name NetworkServicesEdgeCacheKeyset#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#project NetworkServicesEdgeCacheKeyset#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * public_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#public_key NetworkServicesEdgeCacheKeyset#public_key}
     *
     * @stability stable
     */
    readonly publicKey: NetworkServicesEdgeCacheKeysetPublicKey[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#timeouts NetworkServicesEdgeCacheKeyset#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: NetworkServicesEdgeCacheKeysetTimeouts;
}
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheKeysetPublicKey {
    /**
     * The ID of the public key.
     *
     * The ID must be 1-63 characters long, and comply with RFC1035.
     * The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]*
     * which means the first character must be a letter, and all following characters must be a dash, underscore, letter or digit.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#id NetworkServicesEdgeCacheKeyset#id}
     *
     * @stability stable
     */
    readonly id: string;
    /**
     * The base64-encoded value of the Ed25519 public key.
     *
     * The base64 encoding can be padded (44 bytes) or unpadded (43 bytes).
     * Representations or encodings of the public key other than this will be rejected with an error.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#value NetworkServicesEdgeCacheKeyset#value}
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function networkServicesEdgeCacheKeysetPublicKeyToTerraform(struct?: NetworkServicesEdgeCacheKeysetPublicKey): any;
/**
 * @stability stable
 */
export interface NetworkServicesEdgeCacheKeysetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#create NetworkServicesEdgeCacheKeyset#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#delete NetworkServicesEdgeCacheKeyset#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html#update NetworkServicesEdgeCacheKeyset#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function networkServicesEdgeCacheKeysetTimeoutsToTerraform(struct?: NetworkServicesEdgeCacheKeysetTimeoutsOutputReference | NetworkServicesEdgeCacheKeysetTimeouts): any;
/**
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheKeysetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): NetworkServicesEdgeCacheKeysetTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: NetworkServicesEdgeCacheKeysetTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html google_network_services_edge_cache_keyset}.
 *
 * @stability stable
 */
export declare class NetworkServicesEdgeCacheKeyset extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/network_services_edge_cache_keyset.html google_network_services_edge_cache_keyset} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: NetworkServicesEdgeCacheKeysetConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _publicKey?;
    /**
     * @stability stable
     */
    get publicKey(): NetworkServicesEdgeCacheKeysetPublicKey[];
    /**
     * @stability stable
     */
    set publicKey(value: NetworkServicesEdgeCacheKeysetPublicKey[]);
    /**
     * @stability stable
     */
    get publicKeyInput(): NetworkServicesEdgeCacheKeysetPublicKey[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): NetworkServicesEdgeCacheKeysetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: NetworkServicesEdgeCacheKeysetTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): NetworkServicesEdgeCacheKeysetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
