import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface PubsubLiteTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name of the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#name PubsubLiteTopic#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#project PubsubLiteTopic#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The region of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#region PubsubLiteTopic#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The zone of the pubsub lite topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#zone PubsubLiteTopic#zone}
     *
     * @stability stable
     */
    readonly zone?: string;
    /**
     * partition_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#partition_config PubsubLiteTopic#partition_config}
     *
     * @stability stable
     */
    readonly partitionConfig?: PubsubLiteTopicPartitionConfig;
    /**
     * reservation_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#reservation_config PubsubLiteTopic#reservation_config}
     *
     * @stability stable
     */
    readonly reservationConfig?: PubsubLiteTopicReservationConfig;
    /**
     * retention_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#retention_config PubsubLiteTopic#retention_config}
     *
     * @stability stable
     */
    readonly retentionConfig?: PubsubLiteTopicRetentionConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#timeouts PubsubLiteTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: PubsubLiteTopicTimeouts;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicPartitionConfigCapacity {
    /**
     * Subscribe throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#publish_mib_per_sec PubsubLiteTopic#publish_mib_per_sec}
     *
     * @stability stable
     */
    readonly publishMibPerSec: number;
    /**
     * Publish throughput capacity per partition in MiB/s. Must be >= 4 and <= 16.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#subscribe_mib_per_sec PubsubLiteTopic#subscribe_mib_per_sec}
     *
     * @stability stable
     */
    readonly subscribeMibPerSec: number;
}
export declare function pubsubLiteTopicPartitionConfigCapacityToTerraform(struct?: PubsubLiteTopicPartitionConfigCapacityOutputReference | PubsubLiteTopicPartitionConfigCapacity): any;
/**
 * @stability stable
 */
export declare class PubsubLiteTopicPartitionConfigCapacityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubLiteTopicPartitionConfigCapacity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubLiteTopicPartitionConfigCapacity | undefined);
    private _publishMibPerSec?;
    /**
     * @stability stable
     */
    get publishMibPerSec(): number;
    /**
     * @stability stable
     */
    set publishMibPerSec(value: number);
    /**
     * @stability stable
     */
    get publishMibPerSecInput(): number | undefined;
    private _subscribeMibPerSec?;
    /**
     * @stability stable
     */
    get subscribeMibPerSec(): number;
    /**
     * @stability stable
     */
    set subscribeMibPerSec(value: number);
    /**
     * @stability stable
     */
    get subscribeMibPerSecInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicPartitionConfig {
    /**
     * The number of partitions in the topic. Must be at least 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#count PubsubLiteTopic#count}
     *
     * @stability stable
     */
    readonly count: number;
    /**
     * capacity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#capacity PubsubLiteTopic#capacity}
     *
     * @stability stable
     */
    readonly capacity?: PubsubLiteTopicPartitionConfigCapacity;
}
export declare function pubsubLiteTopicPartitionConfigToTerraform(struct?: PubsubLiteTopicPartitionConfigOutputReference | PubsubLiteTopicPartitionConfig): any;
/**
 * @stability stable
 */
export declare class PubsubLiteTopicPartitionConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubLiteTopicPartitionConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubLiteTopicPartitionConfig | undefined);
    private _count?;
    /**
     * @stability stable
     */
    get count(): number;
    /**
     * @stability stable
     */
    set count(value: number);
    /**
     * @stability stable
     */
    get countInput(): number | undefined;
    private _capacity;
    /**
     * @stability stable
     */
    get capacity(): PubsubLiteTopicPartitionConfigCapacityOutputReference;
    /**
     * @stability stable
     */
    putCapacity(value: PubsubLiteTopicPartitionConfigCapacity): void;
    /**
     * @stability stable
     */
    resetCapacity(): void;
    /**
     * @stability stable
     */
    get capacityInput(): PubsubLiteTopicPartitionConfigCapacity | undefined;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicReservationConfig {
    /**
     * The Reservation to use for this topic's throughput capacity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#throughput_reservation PubsubLiteTopic#throughput_reservation}
     *
     * @stability stable
     */
    readonly throughputReservation?: string;
}
export declare function pubsubLiteTopicReservationConfigToTerraform(struct?: PubsubLiteTopicReservationConfigOutputReference | PubsubLiteTopicReservationConfig): any;
/**
 * @stability stable
 */
export declare class PubsubLiteTopicReservationConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubLiteTopicReservationConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubLiteTopicReservationConfig | undefined);
    private _throughputReservation?;
    /**
     * @stability stable
     */
    get throughputReservation(): string;
    /**
     * @stability stable
     */
    set throughputReservation(value: string);
    /**
     * @stability stable
     */
    resetThroughputReservation(): void;
    /**
     * @stability stable
     */
    get throughputReservationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicRetentionConfig {
    /**
     * The provisioned storage, in bytes, per partition.
     *
     * If the number of bytes stored
     * in any of the topic's partitions grows beyond this value, older messages will be
     * dropped to make room for newer ones, regardless of the value of period.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#per_partition_bytes PubsubLiteTopic#per_partition_bytes}
     *
     * @stability stable
     */
    readonly perPartitionBytes: string;
    /**
     * How long a published message is retained.
     *
     * If unset, messages will be retained as
     * long as the bytes retained for each partition is below perPartitionBytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#period PubsubLiteTopic#period}
     *
     * @stability stable
     */
    readonly period?: string;
}
export declare function pubsubLiteTopicRetentionConfigToTerraform(struct?: PubsubLiteTopicRetentionConfigOutputReference | PubsubLiteTopicRetentionConfig): any;
/**
 * @stability stable
 */
export declare class PubsubLiteTopicRetentionConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubLiteTopicRetentionConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubLiteTopicRetentionConfig | undefined);
    private _perPartitionBytes?;
    /**
     * @stability stable
     */
    get perPartitionBytes(): string;
    /**
     * @stability stable
     */
    set perPartitionBytes(value: string);
    /**
     * @stability stable
     */
    get perPartitionBytesInput(): string | undefined;
    private _period?;
    /**
     * @stability stable
     */
    get period(): string;
    /**
     * @stability stable
     */
    set period(value: string);
    /**
     * @stability stable
     */
    resetPeriod(): void;
    /**
     * @stability stable
     */
    get periodInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface PubsubLiteTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#create PubsubLiteTopic#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#delete PubsubLiteTopic#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html#update PubsubLiteTopic#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function pubsubLiteTopicTimeoutsToTerraform(struct?: PubsubLiteTopicTimeoutsOutputReference | PubsubLiteTopicTimeouts): any;
/**
 * @stability stable
 */
export declare class PubsubLiteTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): PubsubLiteTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: PubsubLiteTopicTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html google_pubsub_lite_topic}.
 *
 * @stability stable
 */
export declare class PubsubLiteTopic extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/pubsub_lite_topic.html google_pubsub_lite_topic} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: PubsubLiteTopicConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _zone?;
    /**
     * @stability stable
     */
    get zone(): string;
    /**
     * @stability stable
     */
    set zone(value: string);
    /**
     * @stability stable
     */
    resetZone(): void;
    /**
     * @stability stable
     */
    get zoneInput(): string | undefined;
    private _partitionConfig;
    /**
     * @stability stable
     */
    get partitionConfig(): PubsubLiteTopicPartitionConfigOutputReference;
    /**
     * @stability stable
     */
    putPartitionConfig(value: PubsubLiteTopicPartitionConfig): void;
    /**
     * @stability stable
     */
    resetPartitionConfig(): void;
    /**
     * @stability stable
     */
    get partitionConfigInput(): PubsubLiteTopicPartitionConfig | undefined;
    private _reservationConfig;
    /**
     * @stability stable
     */
    get reservationConfig(): PubsubLiteTopicReservationConfigOutputReference;
    /**
     * @stability stable
     */
    putReservationConfig(value: PubsubLiteTopicReservationConfig): void;
    /**
     * @stability stable
     */
    resetReservationConfig(): void;
    /**
     * @stability stable
     */
    get reservationConfigInput(): PubsubLiteTopicReservationConfig | undefined;
    private _retentionConfig;
    /**
     * @stability stable
     */
    get retentionConfig(): PubsubLiteTopicRetentionConfigOutputReference;
    /**
     * @stability stable
     */
    putRetentionConfig(value: PubsubLiteTopicRetentionConfig): void;
    /**
     * @stability stable
     */
    resetRetentionConfig(): void;
    /**
     * @stability stable
     */
    get retentionConfigInput(): PubsubLiteTopicRetentionConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): PubsubLiteTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: PubsubLiteTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): PubsubLiteTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
