import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface RedisInstanceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Only applicable to STANDARD_HA tier which protects the instance against zonal failures by provisioning it across two zones.
     *
     * If provided, it must be a different zone from the one provided in
     * [locationId].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#alternative_location_id RedisInstance#alternative_location_id}
     *
     * @stability stable
     */
    readonly alternativeLocationId?: string;
    /**
     * Optional.
     *
     * Indicates whether OSS Redis AUTH is enabled for the
     * instance. If set to "true" AUTH is enabled on the instance.
     * Default value is "false" meaning AUTH is disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#auth_enabled RedisInstance#auth_enabled}
     *
     * @stability stable
     */
    readonly authEnabled?: boolean | cdktf.IResolvable;
    /**
     * The full name of the Google Compute Engine network to which the instance is connected.
     *
     * If left unspecified, the default network
     * will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#authorized_network RedisInstance#authorized_network}
     *
     * @stability stable
     */
    readonly authorizedNetwork?: string;
    /**
     * The connection mode of the Redis instance. Default value: "DIRECT_PEERING" Possible values: ["DIRECT_PEERING", "PRIVATE_SERVICE_ACCESS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#connect_mode RedisInstance#connect_mode}
     *
     * @stability stable
     */
    readonly connectMode?: string;
    /**
     * An arbitrary and optional user-provided name for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#display_name RedisInstance#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Resource labels to represent user provided metadata.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#labels RedisInstance#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The zone where the instance will be provisioned.
     *
     * If not provided,
     * the service will choose a zone for the instance. For STANDARD_HA tier,
     * instances will be created across two zones for protection against
     * zonal failures. If [alternativeLocationId] is also provided, it must
     * be different from [locationId].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#location_id RedisInstance#location_id}
     *
     * @stability stable
     */
    readonly locationId?: string;
    /**
     * Redis memory size in GiB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#memory_size_gb RedisInstance#memory_size_gb}
     *
     * @stability stable
     */
    readonly memorySizeGb: number;
    /**
     * The ID of the instance or a fully qualified identifier for the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#name RedisInstance#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#project RedisInstance#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Redis configuration parameters, according to http://redis.io/topics/config. Please check Memorystore documentation for the list of supported parameters: https://cloud.google.com/memorystore/docs/redis/reference/rest/v1/projects.locations.instances#Instance.FIELDS.redis_configs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#redis_configs RedisInstance#redis_configs}
     *
     * @stability stable
     */
    readonly redisConfigs?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The version of Redis software.
     *
     * If not provided, latest supported
     * version will be used. Please check the API documentation linked
     * at the top for the latest valid values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#redis_version RedisInstance#redis_version}
     *
     * @stability stable
     */
    readonly redisVersion?: string;
    /**
     * The name of the Redis region of the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#region RedisInstance#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The CIDR range of internal addresses that are reserved for this instance.
     *
     * If not provided, the service will choose an unused /29
     * block, for example, 10.0.0.0/29 or 192.168.0.0/29. Ranges must be
     * unique and non-overlapping with existing subnets in an authorized
     * network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#reserved_ip_range RedisInstance#reserved_ip_range}
     *
     * @stability stable
     */
    readonly reservedIpRange?: string;
    /**
     * The service tier of the instance. Must be one of these values:.
     *
     * - BASIC: standalone instance
     * - STANDARD_HA: highly available primary/replica instances Default value: "BASIC" Possible values: ["BASIC", "STANDARD_HA"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#tier RedisInstance#tier}
     *
     * @stability stable
     */
    readonly tier?: string;
    /**
     * The TLS mode of the Redis instance, If not provided, TLS is disabled for the instance.
     *
     * - SERVER_AUTHENTICATION: Client to Server traffic encryption enabled with server authentcation Default value: "DISABLED" Possible values: ["SERVER_AUTHENTICATION", "DISABLED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#transit_encryption_mode RedisInstance#transit_encryption_mode}
     *
     * @stability stable
     */
    readonly transitEncryptionMode?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#timeouts RedisInstance#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: RedisInstanceTimeouts;
}
/**
 * @stability stable
 */
export declare class RedisInstanceServerCaCerts extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get cert(): string;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get expireTime(): string;
    /**
     * @stability stable
     */
    get serialNumber(): string;
    /**
     * @stability stable
     */
    get sha1Fingerprint(): string;
}
/**
 * @stability stable
 */
export interface RedisInstanceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#create RedisInstance#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#delete RedisInstance#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html#update RedisInstance#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function redisInstanceTimeoutsToTerraform(struct?: RedisInstanceTimeoutsOutputReference | RedisInstanceTimeouts): any;
/**
 * @stability stable
 */
export declare class RedisInstanceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): RedisInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: RedisInstanceTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html google_redis_instance}.
 *
 * @stability stable
 */
export declare class RedisInstance extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/redis_instance.html google_redis_instance} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: RedisInstanceConfig);
    private _alternativeLocationId?;
    /**
     * @stability stable
     */
    get alternativeLocationId(): string;
    /**
     * @stability stable
     */
    set alternativeLocationId(value: string);
    /**
     * @stability stable
     */
    resetAlternativeLocationId(): void;
    /**
     * @stability stable
     */
    get alternativeLocationIdInput(): string | undefined;
    private _authEnabled?;
    /**
     * @stability stable
     */
    get authEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set authEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAuthEnabled(): void;
    /**
     * @stability stable
     */
    get authEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get authString(): string;
    private _authorizedNetwork?;
    /**
     * @stability stable
     */
    get authorizedNetwork(): string;
    /**
     * @stability stable
     */
    set authorizedNetwork(value: string);
    /**
     * @stability stable
     */
    resetAuthorizedNetwork(): void;
    /**
     * @stability stable
     */
    get authorizedNetworkInput(): string | undefined;
    private _connectMode?;
    /**
     * @stability stable
     */
    get connectMode(): string;
    /**
     * @stability stable
     */
    set connectMode(value: string);
    /**
     * @stability stable
     */
    resetConnectMode(): void;
    /**
     * @stability stable
     */
    get connectModeInput(): string | undefined;
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get currentLocationId(): string;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _locationId?;
    /**
     * @stability stable
     */
    get locationId(): string;
    /**
     * @stability stable
     */
    set locationId(value: string);
    /**
     * @stability stable
     */
    resetLocationId(): void;
    /**
     * @stability stable
     */
    get locationIdInput(): string | undefined;
    private _memorySizeGb?;
    /**
     * @stability stable
     */
    get memorySizeGb(): number;
    /**
     * @stability stable
     */
    set memorySizeGb(value: number);
    /**
     * @stability stable
     */
    get memorySizeGbInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get persistenceIamIdentity(): string;
    /**
     * @stability stable
     */
    get port(): number;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _redisConfigs?;
    /**
     * @stability stable
     */
    get redisConfigs(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set redisConfigs(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRedisConfigs(): void;
    /**
     * @stability stable
     */
    get redisConfigsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _redisVersion?;
    /**
     * @stability stable
     */
    get redisVersion(): string;
    /**
     * @stability stable
     */
    set redisVersion(value: string);
    /**
     * @stability stable
     */
    resetRedisVersion(): void;
    /**
     * @stability stable
     */
    get redisVersionInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _reservedIpRange?;
    /**
     * @stability stable
     */
    get reservedIpRange(): string;
    /**
     * @stability stable
     */
    set reservedIpRange(value: string);
    /**
     * @stability stable
     */
    resetReservedIpRange(): void;
    /**
     * @stability stable
     */
    get reservedIpRangeInput(): string | undefined;
    /**
     * @stability stable
     */
    serverCaCerts(index: string): RedisInstanceServerCaCerts;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    resetTier(): void;
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _transitEncryptionMode?;
    /**
     * @stability stable
     */
    get transitEncryptionMode(): string;
    /**
     * @stability stable
     */
    set transitEncryptionMode(value: string);
    /**
     * @stability stable
     */
    resetTransitEncryptionMode(): void;
    /**
     * @stability stable
     */
    get transitEncryptionModeInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): RedisInstanceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: RedisInstanceTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): RedisInstanceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
