# arthur_client.api_bindings.MetricFunctionsV1Api

All URIs are relative to *http://localhost*

Method | HTTP request | Description
------------- | ------------- | -------------
[**get_metric_functions_aggregations**](MetricFunctionsV1Api.md#get_metric_functions_aggregations) | **GET** /api/v1/metric_functions/aggregations | Get Aggregations Catalog


# **get_metric_functions_aggregations**
> ResourceListAggregationSpecSchema get_metric_functions_aggregations()

Get Aggregations Catalog

Get aggregations catalog.

### Example

* OAuth Authentication (OAuth2AuthorizationCode):

```python
import arthur_client.api_bindings
from arthur_client.api_bindings.models.resource_list_aggregation_spec_schema import ResourceListAggregationSpecSchema
from arthur_client.api_bindings.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = arthur_client.api_bindings.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

configuration.access_token = os.environ["ACCESS_TOKEN"]

# Enter a context with an instance of the API client
with arthur_client.api_bindings.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = arthur_client.api_bindings.MetricFunctionsV1Api(api_client)

    try:
        # Get Aggregations Catalog
        api_response = api_instance.get_metric_functions_aggregations()
        print("The response of MetricFunctionsV1Api->get_metric_functions_aggregations:\n")
        pprint(api_response)
    except Exception as e:
        print("Exception when calling MetricFunctionsV1Api->get_metric_functions_aggregations: %s\n" % e)
```



### Parameters

This endpoint does not need any parameter.

### Return type

[**ResourceListAggregationSpecSchema**](ResourceListAggregationSpecSchema.md)

### Authorization

[OAuth2AuthorizationCode](../README.md#OAuth2AuthorizationCode)

### HTTP request headers

 - **Content-Type**: Not defined
 - **Accept**: application/json

### HTTP response details

| Status code | Description | Response headers |
|-------------|-------------|------------------|
**200** | Successful Response |  -  |
**500** | Internal Server Error |  -  |

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

