# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from arthur_client.api_bindings.models.alert_bound import AlertBound
from arthur_client.api_bindings.models.alert_rule_interval import AlertRuleInterval
from typing import Optional, Set
from typing_extensions import Self

class Alert(BaseModel):
    """
    Alert
    """ # noqa: E501
    description: Optional[StrictStr]
    timestamp: datetime = Field(description="The timestamp of the alert.")
    value: Union[StrictFloat, StrictInt] = Field(description="The value of the metric that triggered the alert.")
    threshold: Union[StrictFloat, StrictInt] = Field(description="The threshold that triggered the alert.")
    bound: AlertBound = Field(description="The bound of the alert.")
    interval: AlertRuleInterval = Field(description="The interval of the alert rule, commonly '1 day', '1 hour', etc.")
    dimensions: Optional[Dict[str, Any]]
    alert_rule_id: StrictStr = Field(description="The alert rule id of the alert.")
    job_id: Optional[StrictStr] = None
    created_at: datetime = Field(description="Time of record creation.")
    updated_at: datetime = Field(description="Time of last record update.")
    id: StrictStr = Field(description="The id of the alert.")
    model_id: StrictStr = Field(description="The model id of the alert.")
    alert_rule_name: StrictStr = Field(description="The name of the alert rule.")
    alert_rule_metric_name: StrictStr = Field(description="The name of the metric returned by the alert rule query.")
    is_duplicate_of: Optional[StrictStr] = None
    __properties: ClassVar[List[str]] = ["description", "timestamp", "value", "threshold", "bound", "interval", "dimensions", "alert_rule_id", "job_id", "created_at", "updated_at", "id", "model_id", "alert_rule_name", "alert_rule_metric_name", "is_duplicate_of"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Alert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of interval
        if self.interval:
            _dict['interval'] = self.interval.to_dict()
        # set to None if description (nullable) is None
        # and model_fields_set contains the field
        if self.description is None and "description" in self.model_fields_set:
            _dict['description'] = None

        # set to None if dimensions (nullable) is None
        # and model_fields_set contains the field
        if self.dimensions is None and "dimensions" in self.model_fields_set:
            _dict['dimensions'] = None

        # set to None if job_id (nullable) is None
        # and model_fields_set contains the field
        if self.job_id is None and "job_id" in self.model_fields_set:
            _dict['job_id'] = None

        # set to None if is_duplicate_of (nullable) is None
        # and model_fields_set contains the field
        if self.is_duplicate_of is None and "is_duplicate_of" in self.model_fields_set:
            _dict['is_duplicate_of'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Alert from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "description": obj.get("description"),
            "timestamp": obj.get("timestamp"),
            "value": obj.get("value"),
            "threshold": obj.get("threshold"),
            "bound": obj.get("bound"),
            "interval": AlertRuleInterval.from_dict(obj["interval"]) if obj.get("interval") is not None else None,
            "dimensions": obj.get("dimensions"),
            "alert_rule_id": obj.get("alert_rule_id"),
            "job_id": obj.get("job_id"),
            "created_at": obj.get("created_at"),
            "updated_at": obj.get("updated_at"),
            "id": obj.get("id"),
            "model_id": obj.get("model_id"),
            "alert_rule_name": obj.get("alert_rule_name"),
            "alert_rule_metric_name": obj.get("alert_rule_metric_name"),
            "is_duplicate_of": obj.get("is_duplicate_of")
        })
        return _obj


