# coding: utf-8

"""
    Arthur Scope

    No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)

    The version of the OpenAPI document: 0.1.0
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from arthur_client.api_bindings.models.connector_pagination_options import ConnectorPaginationOptions
from arthur_client.api_bindings.models.data_result_filter import DataResultFilter
from typing import Optional, Set
from typing_extensions import Self

class PostDataRetrievalOperation(BaseModel):
    """
    PostDataRetrievalOperation
    """ # noqa: E501
    start_timestamp: datetime = Field(description="Start timestamp to retrieve data for.")
    end_timestamp: datetime = Field(description="End timestamp to retrieve data for.")
    data_retrieval_filters: Optional[List[DataResultFilter]] = Field(default=None, description="Filters to apply to retrieved data")
    pagination_options: Optional[ConnectorPaginationOptions] = Field(default=None, description="Pagination options to apply to retrieved data")
    __properties: ClassVar[List[str]] = ["start_timestamp", "end_timestamp", "data_retrieval_filters", "pagination_options"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PostDataRetrievalOperation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in data_retrieval_filters (list)
        _items = []
        if self.data_retrieval_filters:
            for _item_data_retrieval_filters in self.data_retrieval_filters:
                if _item_data_retrieval_filters:
                    _items.append(_item_data_retrieval_filters.to_dict())
            _dict['data_retrieval_filters'] = _items
        # override the default output from pydantic by calling `to_dict()` of pagination_options
        if self.pagination_options:
            _dict['pagination_options'] = self.pagination_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PostDataRetrievalOperation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "start_timestamp": obj.get("start_timestamp"),
            "end_timestamp": obj.get("end_timestamp"),
            "data_retrieval_filters": [DataResultFilter.from_dict(_item) for _item in obj["data_retrieval_filters"]] if obj.get("data_retrieval_filters") is not None else None,
            "pagination_options": ConnectorPaginationOptions.from_dict(obj["pagination_options"]) if obj.get("pagination_options") is not None else None
        })
        return _obj


