import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelConfig extends cdktf.TerraformMetaArguments {
    /**
     * Description of the AccessLevel and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#description AccessContextManagerAccessLevel#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource name for the Access Level.
     *
     * The short_name component must begin
     * with a letter and only include alphanumeric and '_'.
     * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#name AccessContextManagerAccessLevel#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The AccessPolicy this AccessLevel lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#parent AccessContextManagerAccessLevel#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#title AccessContextManagerAccessLevel#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * basic block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#basic AccessContextManagerAccessLevel#basic}
     *
     * @stability stable
     */
    readonly basic?: AccessContextManagerAccessLevelBasic;
    /**
     * custom block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#custom AccessContextManagerAccessLevel#custom}
     *
     * @stability stable
     */
    readonly custom?: AccessContextManagerAccessLevelCustom;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#timeouts AccessContextManagerAccessLevel#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerAccessLevelTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints {
    /**
     * The minimum allowed OS version.
     *
     * If not set, any version
     * of this OS satisfies the constraint.
     * Format: "major.minor.patch" such as "10.5.301", "9.2.1".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#minimum_version AccessContextManagerAccessLevel#minimum_version}
     *
     * @stability stable
     */
    readonly minimumVersion?: string;
    /**
     * The operating system type of the device. Possible values: ["OS_UNSPECIFIED", "DESKTOP_MAC", "DESKTOP_WINDOWS", "DESKTOP_LINUX", "DESKTOP_CHROME_OS", "ANDROID", "IOS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#os_type AccessContextManagerAccessLevel#os_type}
     *
     * @stability stable
     */
    readonly osType: string;
    /**
     * If you specify DESKTOP_CHROME_OS for osType, you can optionally include requireVerifiedChromeOs to require Chrome Verified Access.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#require_verified_chrome_os AccessContextManagerAccessLevel#require_verified_chrome_os}
     *
     * @stability stable
     */
    readonly requireVerifiedChromeOs?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraintsToTerraform(struct?: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints): any;
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelBasicConditionsDevicePolicy {
    /**
     * A list of allowed device management levels. An empty list allows all management levels. Possible values: ["MANAGEMENT_UNSPECIFIED", "NONE", "BASIC", "COMPLETE"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#allowed_device_management_levels AccessContextManagerAccessLevel#allowed_device_management_levels}
     *
     * @stability stable
     */
    readonly allowedDeviceManagementLevels?: string[];
    /**
     * A list of allowed encryptions statuses. An empty list allows all statuses. Possible values: ["ENCRYPTION_UNSPECIFIED", "ENCRYPTION_UNSUPPORTED", "UNENCRYPTED", "ENCRYPTED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#allowed_encryption_statuses AccessContextManagerAccessLevel#allowed_encryption_statuses}
     *
     * @stability stable
     */
    readonly allowedEncryptionStatuses?: string[];
    /**
     * Whether the device needs to be approved by the customer admin.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#require_admin_approval AccessContextManagerAccessLevel#require_admin_approval}
     *
     * @stability stable
     */
    readonly requireAdminApproval?: boolean | cdktf.IResolvable;
    /**
     * Whether the device needs to be corp owned.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#require_corp_owned AccessContextManagerAccessLevel#require_corp_owned}
     *
     * @stability stable
     */
    readonly requireCorpOwned?: boolean | cdktf.IResolvable;
    /**
     * Whether or not screenlock is required for the DevicePolicy to be true. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#require_screen_lock AccessContextManagerAccessLevel#require_screen_lock}
     *
     * @stability stable
     */
    readonly requireScreenLock?: boolean | cdktf.IResolvable;
    /**
     * os_constraints block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#os_constraints AccessContextManagerAccessLevel#os_constraints}
     *
     * @stability stable
     */
    readonly osConstraints?: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[];
}
export declare function accessContextManagerAccessLevelBasicConditionsDevicePolicyToTerraform(struct?: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference | AccessContextManagerAccessLevelBasicConditionsDevicePolicy): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelBasicConditionsDevicePolicyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelBasicConditionsDevicePolicy | undefined);
    private _allowedDeviceManagementLevels?;
    /**
     * @stability stable
     */
    get allowedDeviceManagementLevels(): string[];
    /**
     * @stability stable
     */
    set allowedDeviceManagementLevels(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedDeviceManagementLevels(): void;
    /**
     * @stability stable
     */
    get allowedDeviceManagementLevelsInput(): string[] | undefined;
    private _allowedEncryptionStatuses?;
    /**
     * @stability stable
     */
    get allowedEncryptionStatuses(): string[];
    /**
     * @stability stable
     */
    set allowedEncryptionStatuses(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedEncryptionStatuses(): void;
    /**
     * @stability stable
     */
    get allowedEncryptionStatusesInput(): string[] | undefined;
    private _requireAdminApproval?;
    /**
     * @stability stable
     */
    get requireAdminApproval(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireAdminApproval(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireAdminApproval(): void;
    /**
     * @stability stable
     */
    get requireAdminApprovalInput(): boolean | cdktf.IResolvable | undefined;
    private _requireCorpOwned?;
    /**
     * @stability stable
     */
    get requireCorpOwned(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireCorpOwned(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireCorpOwned(): void;
    /**
     * @stability stable
     */
    get requireCorpOwnedInput(): boolean | cdktf.IResolvable | undefined;
    private _requireScreenLock?;
    /**
     * @stability stable
     */
    get requireScreenLock(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireScreenLock(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireScreenLock(): void;
    /**
     * @stability stable
     */
    get requireScreenLockInput(): boolean | cdktf.IResolvable | undefined;
    private _osConstraints?;
    /**
     * @stability stable
     */
    get osConstraints(): AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[];
    /**
     * @stability stable
     */
    set osConstraints(value: AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[]);
    /**
     * @stability stable
     */
    resetOsConstraints(): void;
    /**
     * @stability stable
     */
    get osConstraintsInput(): AccessContextManagerAccessLevelBasicConditionsDevicePolicyOsConstraints[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelBasicConditions {
    /**
     * A list of CIDR block IP subnetwork specification.
     *
     * May be IPv4
     * or IPv6.
     * Note that for a CIDR IP address block, the specified IP address
     * portion must be properly truncated (i.e. all the host bits must
     * be zero) or the input is considered malformed. For example,
     * "192.0.2.0/24" is accepted but "192.0.2.1/24" is not. Similarly,
     * for IPv6, "2001:db8::/32" is accepted whereas "2001:db8::1/32"
     * is not. The originating IP of a request must be in one of the
     * listed subnets in order for this Condition to be true.
     * If empty, all IP addresses are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#ip_subnetworks AccessContextManagerAccessLevel#ip_subnetworks}
     *
     * @stability stable
     */
    readonly ipSubnetworks?: string[];
    /**
     * An allowed list of members (users, service accounts). Using groups is not supported yet.
     *
     * The signed-in user originating the request must be a part of one
     * of the provided members. If not specified, a request may come
     * from any user (logged in/not logged in, not present in any
     * groups, etc.).
     * Formats: 'user:{emailid}', 'serviceAccount:{emailid}'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#members AccessContextManagerAccessLevel#members}
     *
     * @stability stable
     */
    readonly members?: string[];
    /**
     * Whether to negate the Condition.
     *
     * If true, the Condition becomes
     * a NAND over its non-empty fields, each field must be false for
     * the Condition overall to be satisfied. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#negate AccessContextManagerAccessLevel#negate}
     *
     * @stability stable
     */
    readonly negate?: boolean | cdktf.IResolvable;
    /**
     * The request must originate from one of the provided countries/regions. Format: A valid ISO 3166-1 alpha-2 code.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#regions AccessContextManagerAccessLevel#regions}
     *
     * @stability stable
     */
    readonly regions?: string[];
    /**
     * A list of other access levels defined in the same Policy, referenced by resource name.
     *
     * Referencing an AccessLevel which
     * does not exist is an error. All access levels listed must be
     * granted for the Condition to be true.
     * Format: accessPolicies/{policy_id}/accessLevels/{short_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#required_access_levels AccessContextManagerAccessLevel#required_access_levels}
     *
     * @stability stable
     */
    readonly requiredAccessLevels?: string[];
    /**
     * device_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#device_policy AccessContextManagerAccessLevel#device_policy}
     *
     * @stability stable
     */
    readonly devicePolicy?: AccessContextManagerAccessLevelBasicConditionsDevicePolicy;
}
export declare function accessContextManagerAccessLevelBasicConditionsToTerraform(struct?: AccessContextManagerAccessLevelBasicConditions): any;
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelBasic {
    /**
     * How the conditions list should be combined to determine if a request is granted this AccessLevel.
     *
     * If AND is used, each Condition in
     * conditions must be satisfied for the AccessLevel to be applied. If
     * OR is used, at least one Condition in conditions must be satisfied
     * for the AccessLevel to be applied. Default value: "AND" Possible values: ["AND", "OR"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#combining_function AccessContextManagerAccessLevel#combining_function}
     *
     * @stability stable
     */
    readonly combiningFunction?: string;
    /**
     * conditions block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#conditions AccessContextManagerAccessLevel#conditions}
     *
     * @stability stable
     */
    readonly conditions: AccessContextManagerAccessLevelBasicConditions[];
}
export declare function accessContextManagerAccessLevelBasicToTerraform(struct?: AccessContextManagerAccessLevelBasicOutputReference | AccessContextManagerAccessLevelBasic): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelBasicOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelBasic | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelBasic | undefined);
    private _combiningFunction?;
    /**
     * @stability stable
     */
    get combiningFunction(): string;
    /**
     * @stability stable
     */
    set combiningFunction(value: string);
    /**
     * @stability stable
     */
    resetCombiningFunction(): void;
    /**
     * @stability stable
     */
    get combiningFunctionInput(): string | undefined;
    private _conditions?;
    /**
     * @stability stable
     */
    get conditions(): AccessContextManagerAccessLevelBasicConditions[];
    /**
     * @stability stable
     */
    set conditions(value: AccessContextManagerAccessLevelBasicConditions[]);
    /**
     * @stability stable
     */
    get conditionsInput(): AccessContextManagerAccessLevelBasicConditions[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelCustomExpr {
    /**
     * Description of the expression.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#description AccessContextManagerAccessLevel#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Textual representation of an expression in Common Expression Language syntax.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#expression AccessContextManagerAccessLevel#expression}
     *
     * @stability stable
     */
    readonly expression: string;
    /**
     * String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#location AccessContextManagerAccessLevel#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Title for the expression, i.e. a short string describing its purpose.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#title AccessContextManagerAccessLevel#title}
     *
     * @stability stable
     */
    readonly title?: string;
}
export declare function accessContextManagerAccessLevelCustomExprToTerraform(struct?: AccessContextManagerAccessLevelCustomExprOutputReference | AccessContextManagerAccessLevelCustomExpr): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelCustomExprOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelCustomExpr | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelCustomExpr | undefined);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _expression?;
    /**
     * @stability stable
     */
    get expression(): string;
    /**
     * @stability stable
     */
    set expression(value: string);
    /**
     * @stability stable
     */
    get expressionInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    resetTitle(): void;
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelCustom {
    /**
     * expr block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#expr AccessContextManagerAccessLevel#expr}
     *
     * @stability stable
     */
    readonly expr: AccessContextManagerAccessLevelCustomExpr;
}
export declare function accessContextManagerAccessLevelCustomToTerraform(struct?: AccessContextManagerAccessLevelCustomOutputReference | AccessContextManagerAccessLevelCustom): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelCustomOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelCustom | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelCustom | undefined);
    private _expr;
    /**
     * @stability stable
     */
    get expr(): AccessContextManagerAccessLevelCustomExprOutputReference;
    /**
     * @stability stable
     */
    putExpr(value: AccessContextManagerAccessLevelCustomExpr): void;
    /**
     * @stability stable
     */
    get exprInput(): AccessContextManagerAccessLevelCustomExpr | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerAccessLevelTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#create AccessContextManagerAccessLevel#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#delete AccessContextManagerAccessLevel#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html#update AccessContextManagerAccessLevel#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function accessContextManagerAccessLevelTimeoutsToTerraform(struct?: AccessContextManagerAccessLevelTimeoutsOutputReference | AccessContextManagerAccessLevelTimeouts): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerAccessLevelTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerAccessLevelTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerAccessLevelTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html google_access_context_manager_access_level}.
 *
 * @stability stable
 */
export declare class AccessContextManagerAccessLevel extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_access_level.html google_access_context_manager_access_level} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerAccessLevelConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _title?;
    /**
     * @stability stable
     */
    get title(): string;
    /**
     * @stability stable
     */
    set title(value: string);
    /**
     * @stability stable
     */
    get titleInput(): string | undefined;
    private _basic;
    /**
     * @stability stable
     */
    get basic(): AccessContextManagerAccessLevelBasicOutputReference;
    /**
     * @stability stable
     */
    putBasic(value: AccessContextManagerAccessLevelBasic): void;
    /**
     * @stability stable
     */
    resetBasic(): void;
    /**
     * @stability stable
     */
    get basicInput(): AccessContextManagerAccessLevelBasic | undefined;
    private _custom;
    /**
     * @stability stable
     */
    get custom(): AccessContextManagerAccessLevelCustomOutputReference;
    /**
     * @stability stable
     */
    putCustom(value: AccessContextManagerAccessLevelCustom): void;
    /**
     * @stability stable
     */
    resetCustom(): void;
    /**
     * @stability stable
     */
    get customInput(): AccessContextManagerAccessLevelCustom | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerAccessLevelTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AccessContextManagerAccessLevelTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerAccessLevelTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
