import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersConfig extends cdktf.TerraformMetaArguments {
    /**
     * The AccessPolicy this ServicePerimeter lives in. Format: accessPolicies/{policy_id}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#parent AccessContextManagerServicePerimeters#parent}
     *
     * @stability stable
     */
    readonly parent: string;
    /**
     * service_perimeters block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_perimeters AccessContextManagerServicePerimeters#service_perimeters}
     *
     * @stability stable
     */
    readonly servicePerimeters?: AccessContextManagerServicePerimetersServicePerimeters[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#timeouts AccessContextManagerServicePerimeters#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AccessContextManagerServicePerimetersTimeouts;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFromToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFromOutputReference | AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom | undefined);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[];
    /**
     * @stability stable
     */
    set identities(value: string[]);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string;
    /**
     * @stability stable
     */
    set identityType(value: string);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsMethodSelectors[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperationsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOutputReference | AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo | undefined);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[];
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[]);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_from AccessContextManagerServicePerimeters#egress_from}
     *
     * @stability stable
     */
    readonly egressFrom?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_to AccessContextManagerServicePerimeters#egress_to}
     *
     * @stability stable
     */
    readonly egressTo?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesEgressTo;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecEgressPoliciesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_level AccessContextManagerServicePerimeters#access_level}
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resource AccessContextManagerServicePerimeters#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSourcesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#sources AccessContextManagerServicePerimeters#sources}
     *
     * @stability stable
     */
    readonly sources?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromOutputReference | AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom | undefined);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[];
    /**
     * @stability stable
     */
    set identities(value: string[]);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string;
    /**
     * @stability stable
     */
    set identityType(value: string);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[];
    /**
     * @stability stable
     */
    set sources(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[]);
    /**
     * @stability stable
     */
    resetSources(): void;
    /**
     * @stability stable
     */
    get sourcesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFromSources[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsMethodSelectors[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperationsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOutputReference | AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo | undefined);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[];
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[]);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_from AccessContextManagerServicePerimeters#ingress_from}
     *
     * @stability stable
     */
    readonly ingressFrom?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_to AccessContextManagerServicePerimeters#ingress_to}
     *
     * @stability stable
     */
    readonly ingressTo?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesIngressTo;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecIngressPoliciesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#allowed_services AccessContextManagerServicePerimeters#allowed_services}
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#enable_restriction AccessContextManagerServicePerimeters#enable_restriction}
     *
     * @stability stable
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServicesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServicesOutputReference | AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices | undefined);
    private _allowedServices?;
    /**
     * @stability stable
     */
    get allowedServices(): string[];
    /**
     * @stability stable
     */
    set allowedServices(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedServices(): void;
    /**
     * @stability stable
     */
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    /**
     * @stability stable
     */
    get enableRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableRestriction(): void;
    /**
     * @stability stable
     */
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersSpec {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_levels AccessContextManagerServicePerimeters#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#restricted_services AccessContextManagerServicePerimeters#restricted_services}
     *
     * @stability stable
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_policies AccessContextManagerServicePerimeters#egress_policies}
     *
     * @stability stable
     */
    readonly egressPolicies?: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_policies AccessContextManagerServicePerimeters#ingress_policies}
     *
     * @stability stable
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#vpc_accessible_services AccessContextManagerServicePerimeters#vpc_accessible_services}
     *
     * @stability stable
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices;
}
export declare function accessContextManagerServicePerimetersServicePerimetersSpecToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersSpecOutputReference | AccessContextManagerServicePerimetersServicePerimetersSpec): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersSpecOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersSpec | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersSpec | undefined);
    private _accessLevels?;
    /**
     * @stability stable
     */
    get accessLevels(): string[];
    /**
     * @stability stable
     */
    set accessLevels(value: string[]);
    /**
     * @stability stable
     */
    resetAccessLevels(): void;
    /**
     * @stability stable
     */
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    /**
     * @stability stable
     */
    get restrictedServices(): string[];
    /**
     * @stability stable
     */
    set restrictedServices(value: string[]);
    /**
     * @stability stable
     */
    resetRestrictedServices(): void;
    /**
     * @stability stable
     */
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    /**
     * @stability stable
     */
    get egressPolicies(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[];
    /**
     * @stability stable
     */
    set egressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[]);
    /**
     * @stability stable
     */
    resetEgressPolicies(): void;
    /**
     * @stability stable
     */
    get egressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecEgressPolicies[] | undefined;
    private _ingressPolicies?;
    /**
     * @stability stable
     */
    get ingressPolicies(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[];
    /**
     * @stability stable
     */
    set ingressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[]);
    /**
     * @stability stable
     */
    resetIngressPolicies(): void;
    /**
     * @stability stable
     */
    get ingressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    /**
     * @stability stable
     */
    get vpcAccessibleServices(): AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServicesOutputReference;
    /**
     * @stability stable
     */
    putVpcAccessibleServices(value: AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices): void;
    /**
     * @stability stable
     */
    resetVpcAccessibleServices(): void;
    /**
     * @stability stable
     */
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimetersServicePerimetersSpecVpcAccessibleServices | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom {
    /**
     * A list of identities that are allowed access through this 'EgressPolicy'.
     *
     * Should be in the format of email address. The email address should
     * represent individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access to outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will
     * be allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFromToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFromOutputReference | AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom | undefined);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[];
    /**
     * @stability stable
     */
    set identities(value: string[]);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string;
    /**
     * @stability stable
     */
    set identityType(value: string);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors {
    /**
     * Value for 'method' should be a valid method name for the corresponding  'serviceName' in 'ApiOperation'.
     *
     * If '*' used as value for method,
     * then ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with serviceName
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsMethodSelectors[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperationsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', that match this to stanza.
     *
     * A request matches
     * if it contains a resource in this list. If * is specified for resources,
     * then this 'EgressTo' rule will authorize access to all resources outside
     * the perimeter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOutputReference | AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo | undefined);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[];
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[]);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies {
    /**
     * egress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_from AccessContextManagerServicePerimeters#egress_from}
     *
     * @stability stable
     */
    readonly egressFrom?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressFrom;
    /**
     * egress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_to AccessContextManagerServicePerimeters#egress_to}
     *
     * @stability stable
     */
    readonly egressTo?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesEgressTo;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusEgressPoliciesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources {
    /**
     * An 'AccessLevel' resource name that allow resources within the  'ServicePerimeters' to be accessed from the internet.
     *
     * 'AccessLevels' listed
     * must be in the same policy as this 'ServicePerimeter'. Referencing a nonexistent
     * 'AccessLevel' will cause an error. If no 'AccessLevel' names are listed,
     * resources within the perimeter can only be accessed via Google Cloud calls
     * with request origins within the perimeter.
     * Example 'accessPolicies/MY_POLICY/accessLevels/MY_LEVEL.'
     * If * is specified, then all IngressSources will be allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_level AccessContextManagerServicePerimeters#access_level}
     *
     * @stability stable
     */
    readonly accessLevel?: string;
    /**
     * A Google Cloud resource that is allowed to ingress the perimeter.
     *
     * Requests from these resources will be allowed to access perimeter data.
     * Currently only projects are allowed. Format 'projects/{project_number}'
     * The project may be in any Google Cloud organization, not just the
     * organization that the perimeter is defined in. '*' is not allowed, the case
     * of allowing all Google Cloud resources only is not supported.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resource AccessContextManagerServicePerimeters#resource}
     *
     * @stability stable
     */
    readonly resource?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSourcesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom {
    /**
     * A list of identities that are allowed access through this ingress policy.
     *
     * Should be in the format of email address. The email address should represent
     * individual user or service account only.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identities AccessContextManagerServicePerimeters#identities}
     *
     * @stability stable
     */
    readonly identities?: string[];
    /**
     * Specifies the type of identities that are allowed access from outside the  perimeter.
     *
     * If left unspecified, then members of 'identities' field will be
     * allowed access. Possible values: ["IDENTITY_TYPE_UNSPECIFIED", "ANY_IDENTITY", "ANY_USER_ACCOUNT", "ANY_SERVICE_ACCOUNT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#identity_type AccessContextManagerServicePerimeters#identity_type}
     *
     * @stability stable
     */
    readonly identityType?: string;
    /**
     * sources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#sources AccessContextManagerServicePerimeters#sources}
     *
     * @stability stable
     */
    readonly sources?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromOutputReference | AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom | undefined);
    private _identities?;
    /**
     * @stability stable
     */
    get identities(): string[];
    /**
     * @stability stable
     */
    set identities(value: string[]);
    /**
     * @stability stable
     */
    resetIdentities(): void;
    /**
     * @stability stable
     */
    get identitiesInput(): string[] | undefined;
    private _identityType?;
    /**
     * @stability stable
     */
    get identityType(): string;
    /**
     * @stability stable
     */
    set identityType(value: string);
    /**
     * @stability stable
     */
    resetIdentityType(): void;
    /**
     * @stability stable
     */
    get identityTypeInput(): string | undefined;
    private _sources?;
    /**
     * @stability stable
     */
    get sources(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[];
    /**
     * @stability stable
     */
    set sources(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[]);
    /**
     * @stability stable
     */
    resetSources(): void;
    /**
     * @stability stable
     */
    get sourcesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFromSources[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors {
    /**
     * Value for method should be a valid method name for the corresponding  serviceName in 'ApiOperation'.
     *
     * If '*' used as value for 'method', then
     * ALL methods and permissions are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method AccessContextManagerServicePerimeters#method}
     *
     * @stability stable
     */
    readonly method?: string;
    /**
     * Value for permission should be a valid Cloud IAM permission for the  corresponding 'serviceName' in 'ApiOperation'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#permission AccessContextManagerServicePerimeters#permission}
     *
     * @stability stable
     */
    readonly permission?: string;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectorsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations {
    /**
     * The name of the API whose methods or permissions the 'IngressPolicy' or  'EgressPolicy' want to allow.
     *
     * A single 'ApiOperation' with 'serviceName'
     * field set to '*' will allow all methods AND permissions for all services.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#service_name AccessContextManagerServicePerimeters#service_name}
     *
     * @stability stable
     */
    readonly serviceName?: string;
    /**
     * method_selectors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#method_selectors AccessContextManagerServicePerimeters#method_selectors}
     *
     * @stability stable
     */
    readonly methodSelectors?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsMethodSelectors[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperationsToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo {
    /**
     * A list of resources, currently only projects in the form  'projects/<projectnumber>', protected by this 'ServicePerimeter' that are allowed to be accessed by sources defined in the corresponding 'IngressFrom'.
     *
     * A request matches if it contains
     * a resource in this list. If '*' is specified for resources,
     * then this 'IngressTo' rule will authorize access to all
     * resources inside the perimeter, provided that the request
     * also matches the 'operations' field.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * operations block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#operations AccessContextManagerServicePerimeters#operations}
     *
     * @stability stable
     */
    readonly operations?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[];
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOutputReference | AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo | undefined);
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _operations?;
    /**
     * @stability stable
     */
    get operations(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[];
    /**
     * @stability stable
     */
    set operations(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[]);
    /**
     * @stability stable
     */
    resetOperations(): void;
    /**
     * @stability stable
     */
    get operationsInput(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressToOperations[] | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies {
    /**
     * ingress_from block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_from AccessContextManagerServicePerimeters#ingress_from}
     *
     * @stability stable
     */
    readonly ingressFrom?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressFrom;
    /**
     * ingress_to block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_to AccessContextManagerServicePerimeters#ingress_to}
     *
     * @stability stable
     */
    readonly ingressTo?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesIngressTo;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusIngressPoliciesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices {
    /**
     * The list of APIs usable within the Service Perimeter. Must be empty unless 'enableRestriction' is True.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#allowed_services AccessContextManagerServicePerimeters#allowed_services}
     *
     * @stability stable
     */
    readonly allowedServices?: string[];
    /**
     * Whether to restrict API calls within the Service Perimeter to the list of APIs specified in 'allowedServices'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#enable_restriction AccessContextManagerServicePerimeters#enable_restriction}
     *
     * @stability stable
     */
    readonly enableRestriction?: boolean | cdktf.IResolvable;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServicesToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServicesOutputReference | AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServicesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices | undefined);
    private _allowedServices?;
    /**
     * @stability stable
     */
    get allowedServices(): string[];
    /**
     * @stability stable
     */
    set allowedServices(value: string[]);
    /**
     * @stability stable
     */
    resetAllowedServices(): void;
    /**
     * @stability stable
     */
    get allowedServicesInput(): string[] | undefined;
    private _enableRestriction?;
    /**
     * @stability stable
     */
    get enableRestriction(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableRestriction(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableRestriction(): void;
    /**
     * @stability stable
     */
    get enableRestrictionInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimetersStatus {
    /**
     * A list of AccessLevel resource names that allow resources within the ServicePerimeter to be accessed from the internet.
     *
     * AccessLevels listed must be in the same policy as this
     * ServicePerimeter. Referencing a nonexistent AccessLevel is a
     * syntax error. If no AccessLevel names are listed, resources within
     * the perimeter can only be accessed via GCP calls with request
     * origins within the perimeter. For Service Perimeter Bridge, must
     * be empty.
     *
     * Format: accessPolicies/{policy_id}/accessLevels/{access_level_name}
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#access_levels AccessContextManagerServicePerimeters#access_levels}
     *
     * @stability stable
     */
    readonly accessLevels?: string[];
    /**
     * A list of GCP resources that are inside of the service perimeter. Currently only projects are allowed. Format: projects/{project_number}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#resources AccessContextManagerServicePerimeters#resources}
     *
     * @stability stable
     */
    readonly resources?: string[];
    /**
     * GCP services that are subject to the Service Perimeter restrictions.
     *
     * Must contain a list of services. For example, if
     * 'storage.googleapis.com' is specified, access to the storage
     * buckets inside the perimeter must meet the perimeter's access
     * restrictions.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#restricted_services AccessContextManagerServicePerimeters#restricted_services}
     *
     * @stability stable
     */
    readonly restrictedServices?: string[];
    /**
     * egress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#egress_policies AccessContextManagerServicePerimeters#egress_policies}
     *
     * @stability stable
     */
    readonly egressPolicies?: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[];
    /**
     * ingress_policies block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#ingress_policies AccessContextManagerServicePerimeters#ingress_policies}
     *
     * @stability stable
     */
    readonly ingressPolicies?: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[];
    /**
     * vpc_accessible_services block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#vpc_accessible_services AccessContextManagerServicePerimeters#vpc_accessible_services}
     *
     * @stability stable
     */
    readonly vpcAccessibleServices?: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices;
}
export declare function accessContextManagerServicePerimetersServicePerimetersStatusToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimetersStatusOutputReference | AccessContextManagerServicePerimetersServicePerimetersStatus): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersServicePerimetersStatusOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersServicePerimetersStatus | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersServicePerimetersStatus | undefined);
    private _accessLevels?;
    /**
     * @stability stable
     */
    get accessLevels(): string[];
    /**
     * @stability stable
     */
    set accessLevels(value: string[]);
    /**
     * @stability stable
     */
    resetAccessLevels(): void;
    /**
     * @stability stable
     */
    get accessLevelsInput(): string[] | undefined;
    private _resources?;
    /**
     * @stability stable
     */
    get resources(): string[];
    /**
     * @stability stable
     */
    set resources(value: string[]);
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): string[] | undefined;
    private _restrictedServices?;
    /**
     * @stability stable
     */
    get restrictedServices(): string[];
    /**
     * @stability stable
     */
    set restrictedServices(value: string[]);
    /**
     * @stability stable
     */
    resetRestrictedServices(): void;
    /**
     * @stability stable
     */
    get restrictedServicesInput(): string[] | undefined;
    private _egressPolicies?;
    /**
     * @stability stable
     */
    get egressPolicies(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[];
    /**
     * @stability stable
     */
    set egressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[]);
    /**
     * @stability stable
     */
    resetEgressPolicies(): void;
    /**
     * @stability stable
     */
    get egressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusEgressPolicies[] | undefined;
    private _ingressPolicies?;
    /**
     * @stability stable
     */
    get ingressPolicies(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[];
    /**
     * @stability stable
     */
    set ingressPolicies(value: AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[]);
    /**
     * @stability stable
     */
    resetIngressPolicies(): void;
    /**
     * @stability stable
     */
    get ingressPoliciesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusIngressPolicies[] | undefined;
    private _vpcAccessibleServices;
    /**
     * @stability stable
     */
    get vpcAccessibleServices(): AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServicesOutputReference;
    /**
     * @stability stable
     */
    putVpcAccessibleServices(value: AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices): void;
    /**
     * @stability stable
     */
    resetVpcAccessibleServices(): void;
    /**
     * @stability stable
     */
    get vpcAccessibleServicesInput(): AccessContextManagerServicePerimetersServicePerimetersStatusVpcAccessibleServices | undefined;
}
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersServicePerimeters {
    /**
     * Description of the ServicePerimeter and its use. Does not affect behavior.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#description AccessContextManagerServicePerimeters#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Resource name for the ServicePerimeter. The short_name component must begin with a letter and only include alphanumeric and '_'. Format: accessPolicies/{policy_id}/servicePerimeters/{short_name}.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#name AccessContextManagerServicePerimeters#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Specifies the type of the Perimeter.
     *
     * There are two types: regular and
     * bridge. Regular Service Perimeter contains resources, access levels,
     * and restricted services. Every resource can be in at most
     * ONE regular Service Perimeter.
     *
     * In addition to being in a regular service perimeter, a resource can also
     * be in zero or more perimeter bridges. A perimeter bridge only contains
     * resources. Cross project operations are permitted if all effected
     * resources share some perimeter (whether bridge or regular). Perimeter
     * Bridge does not contain access levels or services: those are governed
     * entirely by the regular perimeter that resource is in.
     *
     * Perimeter Bridges are typically useful when building more complex
     * topologies with many independent perimeters that need to share some data
     * with a common perimeter, but should not be able to share data among
     * themselves. Default value: "PERIMETER_TYPE_REGULAR" Possible values: ["PERIMETER_TYPE_REGULAR", "PERIMETER_TYPE_BRIDGE"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#perimeter_type AccessContextManagerServicePerimeters#perimeter_type}
     *
     * @stability stable
     */
    readonly perimeterType?: string;
    /**
     * Human readable title. Must be unique within the Policy.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#title AccessContextManagerServicePerimeters#title}
     *
     * @stability stable
     */
    readonly title: string;
    /**
     * Use explicit dry run spec flag.
     *
     * Ordinarily, a dry-run spec implicitly exists
     * for all Service Perimeters, and that spec is identical to the status for those
     * Service Perimeters. When this flag is set, it inhibits the generation of the
     * implicit spec, thereby allowing the user to explicitly provide a
     * configuration ("spec") to use in a dry-run version of the Service Perimeter.
     * This allows the user to test changes to the enforced config ("status") without
     * actually enforcing them. This testing is done through analyzing the differences
     * between currently enforced and suggested restrictions. useExplicitDryRunSpec must
     * bet set to True if any of the fields in the spec are set to non-default values.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#use_explicit_dry_run_spec AccessContextManagerServicePerimeters#use_explicit_dry_run_spec}
     *
     * @stability stable
     */
    readonly useExplicitDryRunSpec?: boolean | cdktf.IResolvable;
    /**
     * spec block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#spec AccessContextManagerServicePerimeters#spec}
     *
     * @stability stable
     */
    readonly spec?: AccessContextManagerServicePerimetersServicePerimetersSpec;
    /**
     * status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#status AccessContextManagerServicePerimeters#status}
     *
     * @stability stable
     */
    readonly status?: AccessContextManagerServicePerimetersServicePerimetersStatus;
}
export declare function accessContextManagerServicePerimetersServicePerimetersToTerraform(struct?: AccessContextManagerServicePerimetersServicePerimeters): any;
/**
 * @stability stable
 */
export interface AccessContextManagerServicePerimetersTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#create AccessContextManagerServicePerimeters#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#delete AccessContextManagerServicePerimeters#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html#update AccessContextManagerServicePerimeters#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function accessContextManagerServicePerimetersTimeoutsToTerraform(struct?: AccessContextManagerServicePerimetersTimeoutsOutputReference | AccessContextManagerServicePerimetersTimeouts): any;
/**
 * @stability stable
 */
export declare class AccessContextManagerServicePerimetersTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AccessContextManagerServicePerimetersTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AccessContextManagerServicePerimetersTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html google_access_context_manager_service_perimeters}.
 *
 * @stability stable
 */
export declare class AccessContextManagerServicePerimeters extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/access_context_manager_service_perimeters.html google_access_context_manager_service_perimeters} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AccessContextManagerServicePerimetersConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    private _servicePerimeters?;
    /**
     * @stability stable
     */
    get servicePerimeters(): AccessContextManagerServicePerimetersServicePerimeters[];
    /**
     * @stability stable
     */
    set servicePerimeters(value: AccessContextManagerServicePerimetersServicePerimeters[]);
    /**
     * @stability stable
     */
    resetServicePerimeters(): void;
    /**
     * @stability stable
     */
    get servicePerimetersInput(): AccessContextManagerServicePerimetersServicePerimeters[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AccessContextManagerServicePerimetersTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AccessContextManagerServicePerimetersTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AccessContextManagerServicePerimetersTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
