import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckConfig extends cdktf.TerraformMetaArguments {
    /**
     * How often (in seconds) to send a health check. The default value is 5 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#check_interval_sec ComputeRegionHealthCheck#check_interval_sec}
     *
     * @stability stable
     */
    readonly checkIntervalSec?: number;
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#description ComputeRegionHealthCheck#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * A so-far unhealthy instance will be marked healthy after this many consecutive successes. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#healthy_threshold ComputeRegionHealthCheck#healthy_threshold}
     *
     * @stability stable
     */
    readonly healthyThreshold?: number;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035.  Specifically, the name must be 1-63 characters long and
     * match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
     * the first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the
     * last character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#name ComputeRegionHealthCheck#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#project ComputeRegionHealthCheck#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The Region in which the created health check should reside. If it is not provided, the provider region is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#region ComputeRegionHealthCheck#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * How long (in seconds) to wait before claiming failure.
     *
     * The default value is 5 seconds.  It is invalid for timeoutSec to have
     * greater value than checkIntervalSec.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#timeout_sec ComputeRegionHealthCheck#timeout_sec}
     *
     * @stability stable
     */
    readonly timeoutSec?: number;
    /**
     * A so-far healthy instance will be marked unhealthy after this many consecutive failures. The default value is 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#unhealthy_threshold ComputeRegionHealthCheck#unhealthy_threshold}
     *
     * @stability stable
     */
    readonly unhealthyThreshold?: number;
    /**
     * grpc_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#grpc_health_check ComputeRegionHealthCheck#grpc_health_check}
     *
     * @stability stable
     */
    readonly grpcHealthCheck?: ComputeRegionHealthCheckGrpcHealthCheck;
    /**
     * http2_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#http2_health_check ComputeRegionHealthCheck#http2_health_check}
     *
     * @stability stable
     */
    readonly http2HealthCheck?: ComputeRegionHealthCheckHttp2HealthCheck;
    /**
     * http_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#http_health_check ComputeRegionHealthCheck#http_health_check}
     *
     * @stability stable
     */
    readonly httpHealthCheck?: ComputeRegionHealthCheckHttpHealthCheck;
    /**
     * https_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#https_health_check ComputeRegionHealthCheck#https_health_check}
     *
     * @stability stable
     */
    readonly httpsHealthCheck?: ComputeRegionHealthCheckHttpsHealthCheck;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#log_config ComputeRegionHealthCheck#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeRegionHealthCheckLogConfig;
    /**
     * ssl_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#ssl_health_check ComputeRegionHealthCheck#ssl_health_check}
     *
     * @stability stable
     */
    readonly sslHealthCheck?: ComputeRegionHealthCheckSslHealthCheck;
    /**
     * tcp_health_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#tcp_health_check ComputeRegionHealthCheck#tcp_health_check}
     *
     * @stability stable
     */
    readonly tcpHealthCheck?: ComputeRegionHealthCheckTcpHealthCheck;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#timeouts ComputeRegionHealthCheck#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionHealthCheckTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckGrpcHealthCheck {
    /**
     * The gRPC service name for the health check. The value of grpcServiceName has the following meanings by convention:.
     *
     * Empty serviceName means the overall status of all services at the backend.
     * Non-empty serviceName means the health of that gRPC service, as defined by the owner of the service.
     *
     * The grpcServiceName can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#grpc_service_name ComputeRegionHealthCheck#grpc_service_name}
     *
     * @stability stable
     */
    readonly grpcServiceName?: string;
    /**
     * The port number for the health check request.
     *
     * Must be specified if portName and portSpecification are not set
     * or if port_specification is USE_FIXED_PORT. Valid values are 1 through 65535.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, gRPC health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
}
export declare function computeRegionHealthCheckGrpcHealthCheckToTerraform(struct?: ComputeRegionHealthCheckGrpcHealthCheckOutputReference | ComputeRegionHealthCheckGrpcHealthCheck): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckGrpcHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckGrpcHealthCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckGrpcHealthCheck | undefined);
    private _grpcServiceName?;
    /**
     * @stability stable
     */
    get grpcServiceName(): string;
    /**
     * @stability stable
     */
    set grpcServiceName(value: string);
    /**
     * @stability stable
     */
    resetGrpcServiceName(): void;
    /**
     * @stability stable
     */
    get grpcServiceNameInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    set portSpecification(value: string);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckHttp2HealthCheck {
    /**
     * The value of the host header in the HTTP2 health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#host ComputeRegionHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTP2 health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTP2 health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTP2 health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request_path ComputeRegionHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
export declare function computeRegionHealthCheckHttp2HealthCheckToTerraform(struct?: ComputeRegionHealthCheckHttp2HealthCheckOutputReference | ComputeRegionHealthCheckHttp2HealthCheck): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckHttp2HealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckHttp2HealthCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckHttp2HealthCheck | undefined);
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    set portSpecification(value: string);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    set requestPath(value: string);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string;
    /**
     * @stability stable
     */
    set response(value: string);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckHttpHealthCheck {
    /**
     * The value of the host header in the HTTP health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#host ComputeRegionHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTP health check request. The default value is 80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTP health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTP health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request_path ComputeRegionHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
export declare function computeRegionHealthCheckHttpHealthCheckToTerraform(struct?: ComputeRegionHealthCheckHttpHealthCheckOutputReference | ComputeRegionHealthCheckHttpHealthCheck): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckHttpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckHttpHealthCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckHttpHealthCheck | undefined);
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    set portSpecification(value: string);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    set requestPath(value: string);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string;
    /**
     * @stability stable
     */
    set response(value: string);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckHttpsHealthCheck {
    /**
     * The value of the host header in the HTTPS health check request.
     *
     * If left empty (default value), the public IP on behalf of which this health
     * check is performed will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#host ComputeRegionHealthCheck#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The TCP port number for the HTTPS health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, HTTPS health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The request path of the HTTPS health check request. The default value is /.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request_path ComputeRegionHealthCheck#request_path}
     *
     * @stability stable
     */
    readonly requestPath?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
export declare function computeRegionHealthCheckHttpsHealthCheckToTerraform(struct?: ComputeRegionHealthCheckHttpsHealthCheckOutputReference | ComputeRegionHealthCheckHttpsHealthCheck): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckHttpsHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckHttpsHealthCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckHttpsHealthCheck | undefined);
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    set portSpecification(value: string);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _requestPath?;
    /**
     * @stability stable
     */
    get requestPath(): string;
    /**
     * @stability stable
     */
    set requestPath(value: string);
    /**
     * @stability stable
     */
    resetRequestPath(): void;
    /**
     * @stability stable
     */
    get requestPathInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string;
    /**
     * @stability stable
     */
    set response(value: string);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckLogConfig {
    /**
     * Indicates whether or not to export logs.
     *
     * This is false by default,
     * which means no health check logging will be done.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#enable ComputeRegionHealthCheck#enable}
     *
     * @stability stable
     */
    readonly enable?: boolean | cdktf.IResolvable;
}
export declare function computeRegionHealthCheckLogConfigToTerraform(struct?: ComputeRegionHealthCheckLogConfigOutputReference | ComputeRegionHealthCheckLogConfig): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckLogConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckLogConfig | undefined);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnable(): void;
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckSslHealthCheck {
    /**
     * The TCP port number for the SSL health check request. The default value is 443.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, SSL health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The application data to send once the SSL connection has been established (default value is empty).
     *
     * If both request and response are
     * empty, the connection establishment alone will indicate health. The request
     * data can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request ComputeRegionHealthCheck#request}
     *
     * @stability stable
     */
    readonly request?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
export declare function computeRegionHealthCheckSslHealthCheckToTerraform(struct?: ComputeRegionHealthCheckSslHealthCheckOutputReference | ComputeRegionHealthCheckSslHealthCheck): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckSslHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckSslHealthCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckSslHealthCheck | undefined);
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    set portSpecification(value: string);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): string;
    /**
     * @stability stable
     */
    set request(value: string);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string;
    /**
     * @stability stable
     */
    set response(value: string);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckTcpHealthCheck {
    /**
     * The TCP port number for the TCP health check request. The default value is 80.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port ComputeRegionHealthCheck#port}
     *
     * @stability stable
     */
    readonly port?: number;
    /**
     * Port name as defined in InstanceGroup#NamedPort#name. If both port and port_name are defined, port takes precedence.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_name ComputeRegionHealthCheck#port_name}
     *
     * @stability stable
     */
    readonly portName?: string;
    /**
     * Specifies how port is selected for health checking, can be one of the following values:.
     *
     * 'USE_FIXED_PORT': The port number in 'port' is used for health checking.
     *
     * 'USE_NAMED_PORT': The 'portName' is used for health checking.
     *
     * 'USE_SERVING_PORT': For NetworkEndpointGroup, the port specified for each
     * network endpoint is used for health checking. For other backends, the
     * port or named port specified in the Backend Service is used for health
     * checking.
     *
     * If not specified, TCP health check follows behavior specified in 'port' and
     * 'portName' fields. Possible values: ["USE_FIXED_PORT", "USE_NAMED_PORT", "USE_SERVING_PORT"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#port_specification ComputeRegionHealthCheck#port_specification}
     *
     * @stability stable
     */
    readonly portSpecification?: string;
    /**
     * Specifies the type of proxy header to append before sending data to the backend.
     *
     * Default value: "NONE" Possible values: ["NONE", "PROXY_V1"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#proxy_header ComputeRegionHealthCheck#proxy_header}
     *
     * @stability stable
     */
    readonly proxyHeader?: string;
    /**
     * The application data to send once the TCP connection has been established (default value is empty).
     *
     * If both request and response are
     * empty, the connection establishment alone will indicate health. The request
     * data can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#request ComputeRegionHealthCheck#request}
     *
     * @stability stable
     */
    readonly request?: string;
    /**
     * The bytes to match against the beginning of the response data.
     *
     * If left empty
     * (the default value), any response will indicate health. The response data
     * can only be ASCII.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#response ComputeRegionHealthCheck#response}
     *
     * @stability stable
     */
    readonly response?: string;
}
export declare function computeRegionHealthCheckTcpHealthCheckToTerraform(struct?: ComputeRegionHealthCheckTcpHealthCheckOutputReference | ComputeRegionHealthCheckTcpHealthCheck): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckTcpHealthCheckOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckTcpHealthCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckTcpHealthCheck | undefined);
    private _port?;
    /**
     * @stability stable
     */
    get port(): number;
    /**
     * @stability stable
     */
    set port(value: number);
    /**
     * @stability stable
     */
    resetPort(): void;
    /**
     * @stability stable
     */
    get portInput(): number | undefined;
    private _portName?;
    /**
     * @stability stable
     */
    get portName(): string;
    /**
     * @stability stable
     */
    set portName(value: string);
    /**
     * @stability stable
     */
    resetPortName(): void;
    /**
     * @stability stable
     */
    get portNameInput(): string | undefined;
    private _portSpecification?;
    /**
     * @stability stable
     */
    get portSpecification(): string;
    /**
     * @stability stable
     */
    set portSpecification(value: string);
    /**
     * @stability stable
     */
    resetPortSpecification(): void;
    /**
     * @stability stable
     */
    get portSpecificationInput(): string | undefined;
    private _proxyHeader?;
    /**
     * @stability stable
     */
    get proxyHeader(): string;
    /**
     * @stability stable
     */
    set proxyHeader(value: string);
    /**
     * @stability stable
     */
    resetProxyHeader(): void;
    /**
     * @stability stable
     */
    get proxyHeaderInput(): string | undefined;
    private _request?;
    /**
     * @stability stable
     */
    get request(): string;
    /**
     * @stability stable
     */
    set request(value: string);
    /**
     * @stability stable
     */
    resetRequest(): void;
    /**
     * @stability stable
     */
    get requestInput(): string | undefined;
    private _response?;
    /**
     * @stability stable
     */
    get response(): string;
    /**
     * @stability stable
     */
    set response(value: string);
    /**
     * @stability stable
     */
    resetResponse(): void;
    /**
     * @stability stable
     */
    get responseInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionHealthCheckTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#create ComputeRegionHealthCheck#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#delete ComputeRegionHealthCheck#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html#update ComputeRegionHealthCheck#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeRegionHealthCheckTimeoutsToTerraform(struct?: ComputeRegionHealthCheckTimeoutsOutputReference | ComputeRegionHealthCheckTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeRegionHealthCheckTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionHealthCheckTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionHealthCheckTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html google_compute_region_health_check}.
 *
 * @stability stable
 */
export declare class ComputeRegionHealthCheck extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_health_check.html google_compute_region_health_check} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionHealthCheckConfig);
    private _checkIntervalSec?;
    /**
     * @stability stable
     */
    get checkIntervalSec(): number;
    /**
     * @stability stable
     */
    set checkIntervalSec(value: number);
    /**
     * @stability stable
     */
    resetCheckIntervalSec(): void;
    /**
     * @stability stable
     */
    get checkIntervalSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _healthyThreshold?;
    /**
     * @stability stable
     */
    get healthyThreshold(): number;
    /**
     * @stability stable
     */
    set healthyThreshold(value: number);
    /**
     * @stability stable
     */
    resetHealthyThreshold(): void;
    /**
     * @stability stable
     */
    get healthyThresholdInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeoutSec?;
    /**
     * @stability stable
     */
    get timeoutSec(): number;
    /**
     * @stability stable
     */
    set timeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTimeoutSec(): void;
    /**
     * @stability stable
     */
    get timeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _unhealthyThreshold?;
    /**
     * @stability stable
     */
    get unhealthyThreshold(): number;
    /**
     * @stability stable
     */
    set unhealthyThreshold(value: number);
    /**
     * @stability stable
     */
    resetUnhealthyThreshold(): void;
    /**
     * @stability stable
     */
    get unhealthyThresholdInput(): number | undefined;
    private _grpcHealthCheck;
    /**
     * @stability stable
     */
    get grpcHealthCheck(): ComputeRegionHealthCheckGrpcHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putGrpcHealthCheck(value: ComputeRegionHealthCheckGrpcHealthCheck): void;
    /**
     * @stability stable
     */
    resetGrpcHealthCheck(): void;
    /**
     * @stability stable
     */
    get grpcHealthCheckInput(): ComputeRegionHealthCheckGrpcHealthCheck | undefined;
    private _http2HealthCheck;
    /**
     * @stability stable
     */
    get http2HealthCheck(): ComputeRegionHealthCheckHttp2HealthCheckOutputReference;
    /**
     * @stability stable
     */
    putHttp2HealthCheck(value: ComputeRegionHealthCheckHttp2HealthCheck): void;
    /**
     * @stability stable
     */
    resetHttp2HealthCheck(): void;
    /**
     * @stability stable
     */
    get http2HealthCheckInput(): ComputeRegionHealthCheckHttp2HealthCheck | undefined;
    private _httpHealthCheck;
    /**
     * @stability stable
     */
    get httpHealthCheck(): ComputeRegionHealthCheckHttpHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putHttpHealthCheck(value: ComputeRegionHealthCheckHttpHealthCheck): void;
    /**
     * @stability stable
     */
    resetHttpHealthCheck(): void;
    /**
     * @stability stable
     */
    get httpHealthCheckInput(): ComputeRegionHealthCheckHttpHealthCheck | undefined;
    private _httpsHealthCheck;
    /**
     * @stability stable
     */
    get httpsHealthCheck(): ComputeRegionHealthCheckHttpsHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putHttpsHealthCheck(value: ComputeRegionHealthCheckHttpsHealthCheck): void;
    /**
     * @stability stable
     */
    resetHttpsHealthCheck(): void;
    /**
     * @stability stable
     */
    get httpsHealthCheckInput(): ComputeRegionHealthCheckHttpsHealthCheck | undefined;
    private _logConfig;
    /**
     * @stability stable
     */
    get logConfig(): ComputeRegionHealthCheckLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeRegionHealthCheckLogConfig): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeRegionHealthCheckLogConfig | undefined;
    private _sslHealthCheck;
    /**
     * @stability stable
     */
    get sslHealthCheck(): ComputeRegionHealthCheckSslHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putSslHealthCheck(value: ComputeRegionHealthCheckSslHealthCheck): void;
    /**
     * @stability stable
     */
    resetSslHealthCheck(): void;
    /**
     * @stability stable
     */
    get sslHealthCheckInput(): ComputeRegionHealthCheckSslHealthCheck | undefined;
    private _tcpHealthCheck;
    /**
     * @stability stable
     */
    get tcpHealthCheck(): ComputeRegionHealthCheckTcpHealthCheckOutputReference;
    /**
     * @stability stable
     */
    putTcpHealthCheck(value: ComputeRegionHealthCheckTcpHealthCheck): void;
    /**
     * @stability stable
     */
    resetTcpHealthCheck(): void;
    /**
     * @stability stable
     */
    get tcpHealthCheckInput(): ComputeRegionHealthCheckTcpHealthCheck | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionHealthCheckTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRegionHealthCheckTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionHealthCheckTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
