import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRouterNatConfig extends cdktf.TerraformMetaArguments {
    /**
     * A list of URLs of the IP resources to be drained.
     *
     * These IPs must be
     * valid static external IPs that have been assigned to the NAT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#drain_nat_ips ComputeRouterNat#drain_nat_ips}
     *
     * @stability stable
     */
    readonly drainNatIps?: string[];
    /**
     * Specifies if endpoint independent mapping is enabled. This is enabled by default. For more information see the [official documentation](https://cloud.google.com/nat/docs/overview#specs-rfcs).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#enable_endpoint_independent_mapping ComputeRouterNat#enable_endpoint_independent_mapping}
     *
     * @stability stable
     */
    readonly enableEndpointIndependentMapping?: boolean | cdktf.IResolvable;
    /**
     * Timeout (in seconds) for ICMP connections. Defaults to 30s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#icmp_idle_timeout_sec ComputeRouterNat#icmp_idle_timeout_sec}
     *
     * @stability stable
     */
    readonly icmpIdleTimeoutSec?: number;
    /**
     * Minimum number of ports allocated to a VM from this NAT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#min_ports_per_vm ComputeRouterNat#min_ports_per_vm}
     *
     * @stability stable
     */
    readonly minPortsPerVm?: number;
    /**
     * Name of the NAT service. The name must be 1-63 characters long and comply with RFC1035.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#name ComputeRouterNat#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * How external IPs should be allocated for this NAT.
     *
     * Valid values are
     * 'AUTO_ONLY' for only allowing NAT IPs allocated by Google Cloud
     * Platform, or 'MANUAL_ONLY' for only user-allocated NAT IP addresses. Possible values: ["MANUAL_ONLY", "AUTO_ONLY"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#nat_ip_allocate_option ComputeRouterNat#nat_ip_allocate_option}
     *
     * @stability stable
     */
    readonly natIpAllocateOption: string;
    /**
     * Self-links of NAT IPs. Only valid if natIpAllocateOption is set to MANUAL_ONLY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#nat_ips ComputeRouterNat#nat_ips}
     *
     * @stability stable
     */
    readonly natIps?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#project ComputeRouterNat#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Region where the router and NAT reside.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#region ComputeRouterNat#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * The name of the Cloud Router in which this NAT will be configured.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#router ComputeRouterNat#router}
     *
     * @stability stable
     */
    readonly router: string;
    /**
     * How NAT should be configured per Subnetwork.
     *
     * If 'ALL_SUBNETWORKS_ALL_IP_RANGES', all of the
     * IP ranges in every Subnetwork are allowed to Nat.
     * If 'ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES', all of the primary IP
     * ranges in every Subnetwork are allowed to Nat.
     * 'LIST_OF_SUBNETWORKS': A list of Subnetworks are allowed to Nat
     * (specified in the field subnetwork below). Note that if this field
     * contains ALL_SUBNETWORKS_ALL_IP_RANGES or
     * ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES, then there should not be any
     * other RouterNat section in any Router for this network in this region. Possible values: ["ALL_SUBNETWORKS_ALL_IP_RANGES", "ALL_SUBNETWORKS_ALL_PRIMARY_IP_RANGES", "LIST_OF_SUBNETWORKS"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#source_subnetwork_ip_ranges_to_nat ComputeRouterNat#source_subnetwork_ip_ranges_to_nat}
     *
     * @stability stable
     */
    readonly sourceSubnetworkIpRangesToNat: string;
    /**
     * Timeout (in seconds) for TCP established connections. Defaults to 1200s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#tcp_established_idle_timeout_sec ComputeRouterNat#tcp_established_idle_timeout_sec}
     *
     * @stability stable
     */
    readonly tcpEstablishedIdleTimeoutSec?: number;
    /**
     * Timeout (in seconds) for TCP transitory connections. Defaults to 30s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#tcp_transitory_idle_timeout_sec ComputeRouterNat#tcp_transitory_idle_timeout_sec}
     *
     * @stability stable
     */
    readonly tcpTransitoryIdleTimeoutSec?: number;
    /**
     * Timeout (in seconds) for UDP connections. Defaults to 30s if not set.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#udp_idle_timeout_sec ComputeRouterNat#udp_idle_timeout_sec}
     *
     * @stability stable
     */
    readonly udpIdleTimeoutSec?: number;
    /**
     * log_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#log_config ComputeRouterNat#log_config}
     *
     * @stability stable
     */
    readonly logConfig?: ComputeRouterNatLogConfig;
    /**
     * subnetwork block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#subnetwork ComputeRouterNat#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: ComputeRouterNatSubnetwork[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#timeouts ComputeRouterNat#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRouterNatTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRouterNatLogConfig {
    /**
     * Indicates whether or not to export logs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#enable ComputeRouterNat#enable}
     *
     * @stability stable
     */
    readonly enable: boolean | cdktf.IResolvable;
    /**
     * Specifies the desired filtering of logs on this NAT. Possible values: ["ERRORS_ONLY", "TRANSLATIONS_ONLY", "ALL"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#filter ComputeRouterNat#filter}
     *
     * @stability stable
     */
    readonly filter: string;
}
export declare function computeRouterNatLogConfigToTerraform(struct?: ComputeRouterNatLogConfigOutputReference | ComputeRouterNatLogConfig): any;
/**
 * @stability stable
 */
export declare class ComputeRouterNatLogConfigOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRouterNatLogConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRouterNatLogConfig | undefined);
    private _enable?;
    /**
     * @stability stable
     */
    get enable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enableInput(): boolean | cdktf.IResolvable | undefined;
    private _filter?;
    /**
     * @stability stable
     */
    get filter(): string;
    /**
     * @stability stable
     */
    set filter(value: string);
    /**
     * @stability stable
     */
    get filterInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRouterNatSubnetwork {
    /**
     * Self-link of subnetwork to NAT.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#name ComputeRouterNat#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * List of the secondary ranges of the subnetwork that are allowed to use NAT.
     *
     * This can be populated only if
     * 'LIST_OF_SECONDARY_IP_RANGES' is one of the values in
     * sourceIpRangesToNat
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#secondary_ip_range_names ComputeRouterNat#secondary_ip_range_names}
     *
     * @stability stable
     */
    readonly secondaryIpRangeNames?: string[];
    /**
     * List of options for which source IPs in the subnetwork should have NAT enabled. Supported values include: 'ALL_IP_RANGES', 'LIST_OF_SECONDARY_IP_RANGES', 'PRIMARY_IP_RANGE'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#source_ip_ranges_to_nat ComputeRouterNat#source_ip_ranges_to_nat}
     *
     * @stability stable
     */
    readonly sourceIpRangesToNat: string[];
}
export declare function computeRouterNatSubnetworkToTerraform(struct?: ComputeRouterNatSubnetwork): any;
/**
 * @stability stable
 */
export interface ComputeRouterNatTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#create ComputeRouterNat#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#delete ComputeRouterNat#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html#update ComputeRouterNat#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeRouterNatTimeoutsToTerraform(struct?: ComputeRouterNatTimeoutsOutputReference | ComputeRouterNatTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeRouterNatTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRouterNatTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRouterNatTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html google_compute_router_nat}.
 *
 * @stability stable
 */
export declare class ComputeRouterNat extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_router_nat.html google_compute_router_nat} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRouterNatConfig);
    private _drainNatIps?;
    /**
     * @stability stable
     */
    get drainNatIps(): string[];
    /**
     * @stability stable
     */
    set drainNatIps(value: string[]);
    /**
     * @stability stable
     */
    resetDrainNatIps(): void;
    /**
     * @stability stable
     */
    get drainNatIpsInput(): string[] | undefined;
    private _enableEndpointIndependentMapping?;
    /**
     * @stability stable
     */
    get enableEndpointIndependentMapping(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableEndpointIndependentMapping(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableEndpointIndependentMapping(): void;
    /**
     * @stability stable
     */
    get enableEndpointIndependentMappingInput(): boolean | cdktf.IResolvable | undefined;
    private _icmpIdleTimeoutSec?;
    /**
     * @stability stable
     */
    get icmpIdleTimeoutSec(): number;
    /**
     * @stability stable
     */
    set icmpIdleTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetIcmpIdleTimeoutSec(): void;
    /**
     * @stability stable
     */
    get icmpIdleTimeoutSecInput(): number | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _minPortsPerVm?;
    /**
     * @stability stable
     */
    get minPortsPerVm(): number;
    /**
     * @stability stable
     */
    set minPortsPerVm(value: number);
    /**
     * @stability stable
     */
    resetMinPortsPerVm(): void;
    /**
     * @stability stable
     */
    get minPortsPerVmInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _natIpAllocateOption?;
    /**
     * @stability stable
     */
    get natIpAllocateOption(): string;
    /**
     * @stability stable
     */
    set natIpAllocateOption(value: string);
    /**
     * @stability stable
     */
    get natIpAllocateOptionInput(): string | undefined;
    private _natIps?;
    /**
     * @stability stable
     */
    get natIps(): string[];
    /**
     * @stability stable
     */
    set natIps(value: string[]);
    /**
     * @stability stable
     */
    resetNatIps(): void;
    /**
     * @stability stable
     */
    get natIpsInput(): string[] | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _router?;
    /**
     * @stability stable
     */
    get router(): string;
    /**
     * @stability stable
     */
    set router(value: string);
    /**
     * @stability stable
     */
    get routerInput(): string | undefined;
    private _sourceSubnetworkIpRangesToNat?;
    /**
     * @stability stable
     */
    get sourceSubnetworkIpRangesToNat(): string;
    /**
     * @stability stable
     */
    set sourceSubnetworkIpRangesToNat(value: string);
    /**
     * @stability stable
     */
    get sourceSubnetworkIpRangesToNatInput(): string | undefined;
    private _tcpEstablishedIdleTimeoutSec?;
    /**
     * @stability stable
     */
    get tcpEstablishedIdleTimeoutSec(): number;
    /**
     * @stability stable
     */
    set tcpEstablishedIdleTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTcpEstablishedIdleTimeoutSec(): void;
    /**
     * @stability stable
     */
    get tcpEstablishedIdleTimeoutSecInput(): number | undefined;
    private _tcpTransitoryIdleTimeoutSec?;
    /**
     * @stability stable
     */
    get tcpTransitoryIdleTimeoutSec(): number;
    /**
     * @stability stable
     */
    set tcpTransitoryIdleTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetTcpTransitoryIdleTimeoutSec(): void;
    /**
     * @stability stable
     */
    get tcpTransitoryIdleTimeoutSecInput(): number | undefined;
    private _udpIdleTimeoutSec?;
    /**
     * @stability stable
     */
    get udpIdleTimeoutSec(): number;
    /**
     * @stability stable
     */
    set udpIdleTimeoutSec(value: number);
    /**
     * @stability stable
     */
    resetUdpIdleTimeoutSec(): void;
    /**
     * @stability stable
     */
    get udpIdleTimeoutSecInput(): number | undefined;
    private _logConfig;
    /**
     * @stability stable
     */
    get logConfig(): ComputeRouterNatLogConfigOutputReference;
    /**
     * @stability stable
     */
    putLogConfig(value: ComputeRouterNatLogConfig): void;
    /**
     * @stability stable
     */
    resetLogConfig(): void;
    /**
     * @stability stable
     */
    get logConfigInput(): ComputeRouterNatLogConfig | undefined;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): ComputeRouterNatSubnetwork[];
    /**
     * @stability stable
     */
    set subnetwork(value: ComputeRouterNatSubnetwork[]);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): ComputeRouterNatSubnetwork[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRouterNatTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRouterNatTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRouterNatTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
