import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface KmsKeyRingConfig extends cdktf.TerraformMetaArguments {
    /**
     * The location for the KeyRing. A full list of valid locations can be found by running 'gcloud kms locations list'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html#location KmsKeyRing#location}
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * The resource name for the KeyRing.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html#name KmsKeyRing#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html#project KmsKeyRing#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html#timeouts KmsKeyRing#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: KmsKeyRingTimeouts;
}
/**
 * @stability stable
 */
export interface KmsKeyRingTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html#create KmsKeyRing#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html#delete KmsKeyRing#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
}
export declare function kmsKeyRingTimeoutsToTerraform(struct?: KmsKeyRingTimeoutsOutputReference | KmsKeyRingTimeouts): any;
/**
 * @stability stable
 */
export declare class KmsKeyRingTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): KmsKeyRingTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: KmsKeyRingTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html google_kms_key_ring}.
 *
 * @stability stable
 */
export declare class KmsKeyRing extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_key_ring.html google_kms_key_ring} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: KmsKeyRingConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): KmsKeyRingTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: KmsKeyRingTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): KmsKeyRingTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
