import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringNotificationChannelConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional human-readable description of this notification channel.
     *
     * This description may provide additional details, beyond the display name, for the channel. This may not exceed 1024 Unicode characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#description MonitoringNotificationChannel#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * An optional human-readable name for this notification channel.
     *
     * It is recommended that you specify a non-empty and unique name in order to make it easier to identify the channels in your project, though this is not enforced. The display name is limited to 512 Unicode characters.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#display_name MonitoringNotificationChannel#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Whether notifications are forwarded to the described channel.
     *
     * This makes it possible to disable delivery of notifications to a particular channel without removing the channel from all alerting policies that reference the channel. This is a more convenient approach when the change is temporary and you want to receive notifications from the same set of alerting policies on the channel at some point in the future.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#enabled MonitoringNotificationChannel#enabled}
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Configuration fields that define the channel and its behavior.
     *
     * The
     * permissible and required labels are specified in the
     * NotificationChannelDescriptor corresponding to the type field.
     *
     * Labels with sensitive data are obfuscated by the API and therefore Terraform cannot
     * determine if there are upstream changes to these fields. They can also be configured via
     * the sensitive_labels block, but cannot be configured in both places.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#labels MonitoringNotificationChannel#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#project MonitoringNotificationChannel#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * The type of the notification channel.
     *
     * This field matches the value of the NotificationChannelDescriptor.type field. See https://cloud.google.com/monitoring/api/ref_v3/rest/v3/projects.notificationChannelDescriptors/list to get the list of valid values such as "email", "slack", etc...
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#type MonitoringNotificationChannel#type}
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * User-supplied key/value data that does not need to conform to the corresponding NotificationChannelDescriptor's schema, unlike the labels field.
     *
     * This field is intended to be used for organizing and identifying the NotificationChannel objects.The field can contain up to 64 entries. Each key and value is limited to 63 Unicode characters or 128 bytes, whichever is smaller. Labels and values can contain only lowercase letters, numerals, underscores, and dashes. Keys must begin with a letter.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#user_labels MonitoringNotificationChannel#user_labels}
     *
     * @stability stable
     */
    readonly userLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * sensitive_labels block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#sensitive_labels MonitoringNotificationChannel#sensitive_labels}
     *
     * @stability stable
     */
    readonly sensitiveLabels?: MonitoringNotificationChannelSensitiveLabels;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#timeouts MonitoringNotificationChannel#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringNotificationChannelTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringNotificationChannelSensitiveLabels {
    /**
     * An authorization token for a notification channel. Channel types that support this field include: slack.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#auth_token MonitoringNotificationChannel#auth_token}
     *
     * @stability stable
     */
    readonly authToken?: string;
    /**
     * An password for a notification channel. Channel types that support this field include: webhook_basicauth.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#password MonitoringNotificationChannel#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * An servicekey token for a notification channel. Channel types that support this field include: pagerduty.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#service_key MonitoringNotificationChannel#service_key}
     *
     * @stability stable
     */
    readonly serviceKey?: string;
}
export declare function monitoringNotificationChannelSensitiveLabelsToTerraform(struct?: MonitoringNotificationChannelSensitiveLabelsOutputReference | MonitoringNotificationChannelSensitiveLabels): any;
/**
 * @stability stable
 */
export declare class MonitoringNotificationChannelSensitiveLabelsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringNotificationChannelSensitiveLabels | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringNotificationChannelSensitiveLabels | undefined);
    private _authToken?;
    /**
     * @stability stable
     */
    get authToken(): string;
    /**
     * @stability stable
     */
    set authToken(value: string);
    /**
     * @stability stable
     */
    resetAuthToken(): void;
    /**
     * @stability stable
     */
    get authTokenInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _serviceKey?;
    /**
     * @stability stable
     */
    get serviceKey(): string;
    /**
     * @stability stable
     */
    set serviceKey(value: string);
    /**
     * @stability stable
     */
    resetServiceKey(): void;
    /**
     * @stability stable
     */
    get serviceKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringNotificationChannelTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#create MonitoringNotificationChannel#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#delete MonitoringNotificationChannel#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html#update MonitoringNotificationChannel#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function monitoringNotificationChannelTimeoutsToTerraform(struct?: MonitoringNotificationChannelTimeoutsOutputReference | MonitoringNotificationChannelTimeouts): any;
/**
 * @stability stable
 */
export declare class MonitoringNotificationChannelTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): MonitoringNotificationChannelTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: MonitoringNotificationChannelTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html google_monitoring_notification_channel}.
 *
 * @stability stable
 */
export declare class MonitoringNotificationChannel extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_notification_channel.html google_monitoring_notification_channel} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: MonitoringNotificationChannelConfig);
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    private _userLabels?;
    /**
     * @stability stable
     */
    get userLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set userLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUserLabels(): void;
    /**
     * @stability stable
     */
    get userLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get verificationStatus(): string;
    private _sensitiveLabels;
    /**
     * @stability stable
     */
    get sensitiveLabels(): MonitoringNotificationChannelSensitiveLabelsOutputReference;
    /**
     * @stability stable
     */
    putSensitiveLabels(value: MonitoringNotificationChannelSensitiveLabels): void;
    /**
     * @stability stable
     */
    resetSensitiveLabels(): void;
    /**
     * @stability stable
     */
    get sensitiveLabelsInput(): MonitoringNotificationChannelSensitiveLabels | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringNotificationChannelTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringNotificationChannelTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringNotificationChannelTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
