# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetTeamResult',
    'AwaitableGetTeamResult',
    'get_team',
    'get_team_output',
]

@pulumi.output_type
class GetTeamResult:
    """
    A collection of values returned by getTeam.
    """
    def __init__(__self__, default_member_role=None, default_team=None, description=None, id=None, members_can_create_pipelines=None, name=None, privacy=None, slug=None, uuid=None):
        if default_member_role and not isinstance(default_member_role, str):
            raise TypeError("Expected argument 'default_member_role' to be a str")
        pulumi.set(__self__, "default_member_role", default_member_role)
        if default_team and not isinstance(default_team, bool):
            raise TypeError("Expected argument 'default_team' to be a bool")
        pulumi.set(__self__, "default_team", default_team)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members_can_create_pipelines and not isinstance(members_can_create_pipelines, bool):
            raise TypeError("Expected argument 'members_can_create_pipelines' to be a bool")
        pulumi.set(__self__, "members_can_create_pipelines", members_can_create_pipelines)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if privacy and not isinstance(privacy, str):
            raise TypeError("Expected argument 'privacy' to be a str")
        pulumi.set(__self__, "privacy", privacy)
        if slug and not isinstance(slug, str):
            raise TypeError("Expected argument 'slug' to be a str")
        pulumi.set(__self__, "slug", slug)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter(name="defaultMemberRole")
    def default_member_role(self) -> str:
        """
        Default role to assign to a team member
        """
        return pulumi.get(self, "default_member_role")

    @property
    @pulumi.getter(name="defaultTeam")
    def default_team(self) -> bool:
        """
        Whether new org members will be automatically added to this team
        """
        return pulumi.get(self, "default_team")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the team
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The GraphQL ID of the team
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="membersCanCreatePipelines")
    def members_can_create_pipelines(self) -> bool:
        """
        Whether team members can create new pipelines and add them to the team
        """
        return pulumi.get(self, "members_can_create_pipelines")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the team
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def privacy(self) -> str:
        """
        Whether the team is visible to org members outside this team
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter
    def slug(self) -> str:
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The UUID of the team
        """
        return pulumi.get(self, "uuid")


class AwaitableGetTeamResult(GetTeamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTeamResult(
            default_member_role=self.default_member_role,
            default_team=self.default_team,
            description=self.description,
            id=self.id,
            members_can_create_pipelines=self.members_can_create_pipelines,
            name=self.name,
            privacy=self.privacy,
            slug=self.slug,
            uuid=self.uuid)


def get_team(slug: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTeamResult:
    """
    ## # Data Source: team

    Use this data source to look up properties of a team. This can be used to
    validate that a team exists before setting the team slug on a pipeline.

    Buildkite documentation: https://buildkite.com/docs/pipelines/permissions

    ## Example Usage

    ```python
    import pulumi
    import pulumi_buildkite as buildkite

    my_team = buildkite.get_team(slug="my_team")
    ```


    :param str slug: The slug of the team, available in the URL of the team on buildkite.com
    """
    __args__ = dict()
    __args__['slug'] = slug
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('buildkite:index/getTeam:getTeam', __args__, opts=opts, typ=GetTeamResult).value

    return AwaitableGetTeamResult(
        default_member_role=__ret__.default_member_role,
        default_team=__ret__.default_team,
        description=__ret__.description,
        id=__ret__.id,
        members_can_create_pipelines=__ret__.members_can_create_pipelines,
        name=__ret__.name,
        privacy=__ret__.privacy,
        slug=__ret__.slug,
        uuid=__ret__.uuid)


@_utilities.lift_output_func(get_team)
def get_team_output(slug: Optional[pulumi.Input[str]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetTeamResult]:
    """
    ## # Data Source: team

    Use this data source to look up properties of a team. This can be used to
    validate that a team exists before setting the team slug on a pipeline.

    Buildkite documentation: https://buildkite.com/docs/pipelines/permissions

    ## Example Usage

    ```python
    import pulumi
    import pulumi_buildkite as buildkite

    my_team = buildkite.get_team(slug="my_team")
    ```


    :param str slug: The slug of the team, available in the URL of the team on buildkite.com
    """
    ...
