import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/helpers-internal';
/**
 * Properties for defining a `CfnAccountAuditConfiguration`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html
 */
export interface CfnAccountAuditConfigurationProps {
    /**
     * The ID of the account. You can use the expression `!Sub "${AWS::AccountId}"` to use your account ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-accountid
     */
    readonly accountId: string;
    /**
     * Specifies which audit checks are enabled and disabled for this account.
     *
     * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .
     *
     * If an enabled check is removed from the template, it will also be disabled.
     *
     * You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
     *
     * For more information on avialbe auidt checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations
     */
    readonly auditCheckConfigurations: CfnAccountAuditConfiguration.AuditCheckConfigurationsProperty | cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-rolearn
     */
    readonly roleArn: string;
    /**
     * Information about the targets to which audit notifications are sent.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-auditnotificationtargetconfigurations
     */
    readonly auditNotificationTargetConfigurations?: CfnAccountAuditConfiguration.AuditNotificationTargetConfigurationsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT::AccountAuditConfiguration`
 *
 * Use the `AWS::IoT::AccountAuditConfiguration` resource to configure or reconfigure the Device Defender audit settings for your account. Settings include how audit notifications are sent and which audit checks are enabled or disabled. For API reference, see [UpdateAccountAuditConfiguration](https://docs.aws.amazon.com/iot/latest/apireference/API_UpdateAccountAuditConfiguration.html) and for detailed information on all available audit checks, see [Audit checks](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-audit-checks.html) .
 *
 * @cloudformationResource AWS::IoT::AccountAuditConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html
 */
export declare class CfnAccountAuditConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::AccountAuditConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAccountAuditConfiguration;
    /**
     * The ID of the account. You can use the expression `!Sub "${AWS::AccountId}"` to use your account ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-accountid
     */
    accountId: string;
    /**
     * Specifies which audit checks are enabled and disabled for this account.
     *
     * Some data collection might start immediately when certain checks are enabled. When a check is disabled, any data collected so far in relation to the check is deleted. To disable a check, set the value of the `Enabled:` key to `false` .
     *
     * If an enabled check is removed from the template, it will also be disabled.
     *
     * You can't disable a check if it's used by any scheduled audit. You must delete the check from the scheduled audit or delete the scheduled audit itself to disable the check.
     *
     * For more information on avialbe auidt checks see [AWS::IoT::AccountAuditConfiguration AuditCheckConfigurations](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html)
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations
     */
    auditCheckConfigurations: CfnAccountAuditConfiguration.AuditCheckConfigurationsProperty | cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of the role that grants permission to AWS IoT to access information about your devices, policies, certificates, and other items as required when performing an audit.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-rolearn
     */
    roleArn: string;
    /**
     * Information about the targets to which audit notifications are sent.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-accountauditconfiguration.html#cfn-iot-accountauditconfiguration-auditnotificationtargetconfigurations
     */
    auditNotificationTargetConfigurations: CfnAccountAuditConfiguration.AuditNotificationTargetConfigurationsProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::IoT::AccountAuditConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAccountAuditConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnAccountAuditConfiguration {
    /**
     * Which audit checks are enabled and disabled for this account.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfiguration.html
     */
    interface AuditCheckConfigurationProperty {
        /**
         * True if this audit check is enabled for this account.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfiguration.html#cfn-iot-accountauditconfiguration-auditcheckconfiguration-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnAccountAuditConfiguration {
    /**
     * The types of audit checks that can be performed.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html
     */
    interface AuditCheckConfigurationsProperty {
        /**
         * Checks the permissiveness of an authenticated Amazon Cognito identity pool role. For this check, AWS IoT Device Defender audits all Amazon Cognito identity pools that have been used to connect to the AWS IoT message broker during the 31 days before the audit is performed.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-authenticatedcognitoroleoverlypermissivecheck
         */
        readonly authenticatedCognitoRoleOverlyPermissiveCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if a CA certificate is expiring. This check applies to CA certificates expiring within 30 days or that have expired.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-cacertificateexpiringcheck
         */
        readonly caCertificateExpiringCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks the quality of the CA certificate key. The quality checks if the key is in a valid format, not expired, and if the key meets a minimum required size. This check applies to CA certificates that are `ACTIVE` or `PENDING_TRANSFER` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-cacertificatekeyqualitycheck
         */
        readonly caCertificateKeyQualityCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if multiple devices connect using the same client ID.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-conflictingclientidscheck
         */
        readonly conflictingClientIdsCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if a device certificate is expiring. This check applies to device certificates expiring within 30 days or that have expired.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-devicecertificateexpiringcheck
         */
        readonly deviceCertificateExpiringCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks the quality of the device certificate key. The quality checks if the key is in a valid format, not expired, signed by a registered certificate authority, and if the key meets a minimum required size.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-devicecertificatekeyqualitycheck
         */
        readonly deviceCertificateKeyQualityCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if multiple concurrent connections use the same X.509 certificate to authenticate with AWS IoT .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-devicecertificatesharedcheck
         */
        readonly deviceCertificateSharedCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks the permissiveness of a policy attached to an authenticated Amazon Cognito identity pool role.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-iotpolicyoverlypermissivecheck
         */
        readonly iotPolicyOverlyPermissiveCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if a role alias has access to services that haven't been used for the AWS IoT device in the last year.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-iotrolealiasallowsaccesstounusedservicescheck
         */
        readonly iotRoleAliasAllowsAccessToUnusedServicesCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if the temporary credentials provided by AWS IoT role aliases are overly permissive.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-iotrolealiasoverlypermissivecheck
         */
        readonly iotRoleAliasOverlyPermissiveCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if AWS IoT logs are disabled.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-loggingdisabledcheck
         */
        readonly loggingDisabledCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if a revoked CA certificate is still active.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-revokedcacertificatestillactivecheck
         */
        readonly revokedCaCertificateStillActiveCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if a revoked device certificate is still active.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-revokeddevicecertificatestillactivecheck
         */
        readonly revokedDeviceCertificateStillActiveCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
        /**
         * Checks if policy attached to an unauthenticated Amazon Cognito identity pool role is too permissive.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditcheckconfigurations.html#cfn-iot-accountauditconfiguration-auditcheckconfigurations-unauthenticatedcognitoroleoverlypermissivecheck
         */
        readonly unauthenticatedCognitoRoleOverlyPermissiveCheck?: CfnAccountAuditConfiguration.AuditCheckConfigurationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnAccountAuditConfiguration {
    /**
     * Information about the targets to which audit notifications are sent.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditnotificationtarget.html
     */
    interface AuditNotificationTargetProperty {
        /**
         * True if notifications to the target are enabled.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditnotificationtarget.html#cfn-iot-accountauditconfiguration-auditnotificationtarget-enabled
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * The ARN of the role that grants permission to send notifications to the target.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditnotificationtarget.html#cfn-iot-accountauditconfiguration-auditnotificationtarget-rolearn
         */
        readonly roleArn?: string;
        /**
         * The ARN of the target (SNS topic) to which audit notifications are sent.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditnotificationtarget.html#cfn-iot-accountauditconfiguration-auditnotificationtarget-targetarn
         */
        readonly targetArn?: string;
    }
}
export declare namespace CfnAccountAuditConfiguration {
    /**
     * The configuration of the audit notification target.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditnotificationtargetconfigurations.html
     */
    interface AuditNotificationTargetConfigurationsProperty {
        /**
         * The `Sns` notification target.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-accountauditconfiguration-auditnotificationtargetconfigurations.html#cfn-iot-accountauditconfiguration-auditnotificationtargetconfigurations-sns
         */
        readonly sns?: CfnAccountAuditConfiguration.AuditNotificationTargetProperty | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `CfnAuthorizer`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html
 */
export interface CfnAuthorizerProps {
    /**
     * The authorizer's Lambda function ARN.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizerfunctionarn
     */
    readonly authorizerFunctionArn: string;
    /**
     * The authorizer name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizername
     */
    readonly authorizerName?: string;
    /**
     * `AWS::IoT::Authorizer.EnableCachingForHttp`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-enablecachingforhttp
     */
    readonly enableCachingForHttp?: boolean | cdk.IResolvable;
    /**
     * Specifies whether AWS IoT validates the token signature in an authorization request.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-signingdisabled
     */
    readonly signingDisabled?: boolean | cdk.IResolvable;
    /**
     * The status of the authorizer.
     *
     * Valid values: `ACTIVE` | `INACTIVE`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-status
     */
    readonly status?: string;
    /**
     * Metadata which can be used to manage the custom authorizer.
     *
     * > For URI Request parameters use format: ...key1=value1&key2=value2...
     * >
     * > For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     * >
     * > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * The key used to extract the token from the HTTP headers.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokenkeyname
     */
    readonly tokenKeyName?: string;
    /**
     * The public keys used to validate the token signature returned by your custom authentication service.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokensigningpublickeys
     */
    readonly tokenSigningPublicKeys?: {
        [key: string]: (string);
    } | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT::Authorizer`
 *
 * Specifies an authorizer.
 *
 * @cloudformationResource AWS::IoT::Authorizer
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html
 */
export declare class CfnAuthorizer extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Authorizer";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAuthorizer;
    /**
     * The Amazon Resource Name (ARN) of the authorizer.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The authorizer's Lambda function ARN.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizerfunctionarn
     */
    authorizerFunctionArn: string;
    /**
     * The authorizer name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-authorizername
     */
    authorizerName: string | undefined;
    /**
     * `AWS::IoT::Authorizer.EnableCachingForHttp`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-enablecachingforhttp
     */
    enableCachingForHttp: boolean | cdk.IResolvable | undefined;
    /**
     * Specifies whether AWS IoT validates the token signature in an authorization request.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-signingdisabled
     */
    signingDisabled: boolean | cdk.IResolvable | undefined;
    /**
     * The status of the authorizer.
     *
     * Valid values: `ACTIVE` | `INACTIVE`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-status
     */
    status: string | undefined;
    /**
     * Metadata which can be used to manage the custom authorizer.
     *
     * > For URI Request parameters use format: ...key1=value1&key2=value2...
     * >
     * > For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     * >
     * > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * The key used to extract the token from the HTTP headers.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokenkeyname
     */
    tokenKeyName: string | undefined;
    /**
     * The public keys used to validate the token signature returned by your custom authentication service.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-authorizer.html#cfn-iot-authorizer-tokensigningpublickeys
     */
    tokenSigningPublicKeys: {
        [key: string]: (string);
    } | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::IoT::Authorizer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAuthorizerProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnCACertificate`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html
 */
export interface CfnCACertificateProps {
    /**
     * `AWS::IoT::CACertificate.CACertificatePem`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-cacertificatepem
     */
    readonly caCertificatePem: string;
    /**
     * `AWS::IoT::CACertificate.Status`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-status
     */
    readonly status: string;
    /**
     * `AWS::IoT::CACertificate.AutoRegistrationStatus`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-autoregistrationstatus
     */
    readonly autoRegistrationStatus?: string;
    /**
     * `AWS::IoT::CACertificate.CertificateMode`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-certificatemode
     */
    readonly certificateMode?: string;
    /**
     * `AWS::IoT::CACertificate.RegistrationConfig`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-registrationconfig
     */
    readonly registrationConfig?: CfnCACertificate.RegistrationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::IoT::CACertificate.RemoveAutoRegistration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-removeautoregistration
     */
    readonly removeAutoRegistration?: boolean | cdk.IResolvable;
    /**
     * `AWS::IoT::CACertificate.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::IoT::CACertificate.VerificationCertificatePem`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-verificationcertificatepem
     */
    readonly verificationCertificatePem?: string;
}
/**
 * A CloudFormation `AWS::IoT::CACertificate`
 *
 *
 *
 * @cloudformationResource AWS::IoT::CACertificate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html
 */
export declare class CfnCACertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::CACertificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCACertificate;
    /**
     *
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoT::CACertificate.CACertificatePem`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-cacertificatepem
     */
    caCertificatePem: string;
    /**
     * `AWS::IoT::CACertificate.Status`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-status
     */
    status: string;
    /**
     * `AWS::IoT::CACertificate.AutoRegistrationStatus`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-autoregistrationstatus
     */
    autoRegistrationStatus: string | undefined;
    /**
     * `AWS::IoT::CACertificate.CertificateMode`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-certificatemode
     */
    certificateMode: string | undefined;
    /**
     * `AWS::IoT::CACertificate.RegistrationConfig`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-registrationconfig
     */
    registrationConfig: CfnCACertificate.RegistrationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::CACertificate.RemoveAutoRegistration`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-removeautoregistration
     */
    removeAutoRegistration: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::IoT::CACertificate.Tags`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoT::CACertificate.VerificationCertificatePem`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-cacertificate.html#cfn-iot-cacertificate-verificationcertificatepem
     */
    verificationCertificatePem: string | undefined;
    /**
     * Create a new `AWS::IoT::CACertificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCACertificateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnCACertificate {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-cacertificate-registrationconfig.html
     */
    interface RegistrationConfigProperty {
        /**
         * `CfnCACertificate.RegistrationConfigProperty.RoleArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-cacertificate-registrationconfig.html#cfn-iot-cacertificate-registrationconfig-rolearn
         */
        readonly roleArn?: string;
        /**
         * `CfnCACertificate.RegistrationConfigProperty.TemplateBody`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-cacertificate-registrationconfig.html#cfn-iot-cacertificate-registrationconfig-templatebody
         */
        readonly templateBody?: string;
        /**
         * `CfnCACertificate.RegistrationConfigProperty.TemplateName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-cacertificate-registrationconfig.html#cfn-iot-cacertificate-registrationconfig-templatename
         */
        readonly templateName?: string;
    }
}
/**
 * Properties for defining a `CfnCertificate`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html
 */
export interface CfnCertificateProps {
    /**
     * The status of the certificate.
     *
     * Valid values are ACTIVE, INACTIVE, REVOKED, PENDING_TRANSFER, and PENDING_ACTIVATION.
     *
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status
     */
    readonly status: string;
    /**
     * The CA certificate used to sign the device certificate being registered, not available when CertificateMode is SNI_ONLY.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-cacertificatepem
     */
    readonly caCertificatePem?: string;
    /**
     * Specifies which mode of certificate registration to use with this resource. Valid options are DEFAULT with CaCertificatePem and CertificatePem, SNI_ONLY with CertificatePem, and Default with CertificateSigningRequest.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatemode
     */
    readonly certificateMode?: string;
    /**
     * The certificate data in PEM format. Requires SNI_ONLY for the certificate mode or the accompanying CACertificatePem for registration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatepem
     */
    readonly certificatePem?: string;
    /**
     * The certificate signing request (CSR).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest
     */
    readonly certificateSigningRequest?: string;
}
/**
 * A CloudFormation `AWS::IoT::Certificate`
 *
 * Use the `AWS::IoT::Certificate` resource to declare an AWS IoT X.509 certificate. For information about working with X.509 certificates, see [X.509 Client Certificates](https://docs.aws.amazon.com/iot/latest/developerguide/x509-client-certs.html) in the *AWS IoT Developer Guide* .
 *
 * @cloudformationResource AWS::IoT::Certificate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Certificate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCertificate;
    /**
     * Returns the Amazon Resource Name (ARN) for the instance profile. For example:
     *
     * `{ "Fn::GetAtt": ["MyCertificate", "Arn"] }`
     *
     * A value similar to the following is returned:
     *
     * `arn:aws:iot:ap-southeast-2:123456789012:cert/a1234567b89c012d3e4fg567hij8k9l01mno1p23q45678901rs234567890t1u2`
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The certificate ID.
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The status of the certificate.
     *
     * Valid values are ACTIVE, INACTIVE, REVOKED, PENDING_TRANSFER, and PENDING_ACTIVATION.
     *
     * The status value REGISTER_INACTIVE is deprecated and should not be used.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-status
     */
    status: string;
    /**
     * The CA certificate used to sign the device certificate being registered, not available when CertificateMode is SNI_ONLY.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-cacertificatepem
     */
    caCertificatePem: string | undefined;
    /**
     * Specifies which mode of certificate registration to use with this resource. Valid options are DEFAULT with CaCertificatePem and CertificatePem, SNI_ONLY with CertificatePem, and Default with CertificateSigningRequest.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatemode
     */
    certificateMode: string | undefined;
    /**
     * The certificate data in PEM format. Requires SNI_ONLY for the certificate mode or the accompanying CACertificatePem for registration.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatepem
     */
    certificatePem: string | undefined;
    /**
     * The certificate signing request (CSR).
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-certificate.html#cfn-iot-certificate-certificatesigningrequest
     */
    certificateSigningRequest: string | undefined;
    /**
     * Create a new `AWS::IoT::Certificate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnCustomMetric`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html
 */
export interface CfnCustomMetricProps {
    /**
     * The type of the custom metric. Types include `string-list` , `ip-address-list` , `number-list` , and `number` .
     *
     * > The type `number` only takes a single metric value as an input, but when you submit the metrics value in the DeviceMetrics report, you must pass it as an array with a single value.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-metrictype
     */
    readonly metricType: string;
    /**
     * The friendly name in the console for the custom metric. This name doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. You can update the friendly name after you define it.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-displayname
     */
    readonly displayName?: string;
    /**
     * The name of the custom metric. This will be used in the metric report submitted from the device/thing. The name can't begin with `aws:` . You can’t change the name after you define it.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-metricname
     */
    readonly metricName?: string;
    /**
     * Metadata that can be used to manage the custom metric.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoT::CustomMetric`
 *
 * Use the `AWS::IoT::CustomMetric` resource to define a custom metric published by your devices to Device Defender. For API reference, see [CreateCustomMetric](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateCustomMetric.html) and for general information, see [Custom metrics](https://docs.aws.amazon.com/iot/latest/developerguide/dd-detect-custom-metrics.html) .
 *
 * @cloudformationResource AWS::IoT::CustomMetric
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html
 */
export declare class CfnCustomMetric extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::CustomMetric";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnCustomMetric;
    /**
     * The Amazon Resource Number (ARN) of the custom metric; for example, `arn: *aws-partition* :iot: *region* : *accountId* :custommetric/ *metricName*` .
     * @cloudformationAttribute MetricArn
     */
    readonly attrMetricArn: string;
    /**
     * The type of the custom metric. Types include `string-list` , `ip-address-list` , `number-list` , and `number` .
     *
     * > The type `number` only takes a single metric value as an input, but when you submit the metrics value in the DeviceMetrics report, you must pass it as an array with a single value.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-metrictype
     */
    metricType: string;
    /**
     * The friendly name in the console for the custom metric. This name doesn't have to be unique. Don't use this name as the metric identifier in the device metric report. You can update the friendly name after you define it.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-displayname
     */
    displayName: string | undefined;
    /**
     * The name of the custom metric. This will be used in the metric report submitted from the device/thing. The name can't begin with `aws:` . You can’t change the name after you define it.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-metricname
     */
    metricName: string | undefined;
    /**
     * Metadata that can be used to manage the custom metric.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-custommetric.html#cfn-iot-custommetric-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoT::CustomMetric`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCustomMetricProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnDimension`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html
 */
export interface CfnDimensionProps {
    /**
     * Specifies the value or list of values for the dimension. For `TOPIC_FILTER` dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-stringvalues
     */
    readonly stringValues: string[];
    /**
     * Specifies the type of dimension. Supported types: `TOPIC_FILTER.`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-type
     */
    readonly type: string;
    /**
     * A unique identifier for the dimension.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-name
     */
    readonly name?: string;
    /**
     * Metadata that can be used to manage the dimension.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoT::Dimension`
 *
 * Use the `AWS::IoT::Dimension` to limit the scope of a metric used in a security profile for AWS IoT Device Defender . For example, using a `TOPIC_FILTER` dimension, you can narrow down the scope of the metric to only MQTT topics where the name matches the pattern specified in the dimension. For API reference, see [CreateDimension](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateDimension.html) and for general information, see [Scoping metrics in security profiles using dimensions](https://docs.aws.amazon.com/iot/latest/developerguide/scoping-security-behavior.html) .
 *
 * @cloudformationResource AWS::IoT::Dimension
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html
 */
export declare class CfnDimension extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Dimension";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDimension;
    /**
     * The Amazon Resource Name (ARN) of the dimension.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Specifies the value or list of values for the dimension. For `TOPIC_FILTER` dimensions, this is a pattern used to match the MQTT topic (for example, "admin/#").
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-stringvalues
     */
    stringValues: string[];
    /**
     * Specifies the type of dimension. Supported types: `TOPIC_FILTER.`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-type
     */
    type: string;
    /**
     * A unique identifier for the dimension.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-name
     */
    name: string | undefined;
    /**
     * Metadata that can be used to manage the dimension.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-dimension.html#cfn-iot-dimension-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoT::Dimension`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDimensionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnDomainConfiguration`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html
 */
export interface CfnDomainConfigurationProps {
    /**
     * An object that specifies the authorization service for a domain.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig
     */
    readonly authorizerConfig?: CfnDomainConfiguration.AuthorizerConfigProperty | cdk.IResolvable;
    /**
     * The name of the domain configuration. This value must be unique to a region.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationname
     */
    readonly domainConfigurationName?: string;
    /**
     * The status to which the domain configuration should be updated.
     *
     * Valid values: `ENABLED` | `DISABLED`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationstatus
     */
    readonly domainConfigurationStatus?: string;
    /**
     * The name of the domain.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainname
     */
    readonly domainName?: string;
    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificatearns
     */
    readonly serverCertificateArns?: string[];
    /**
     * The type of service delivered by the endpoint.
     *
     * > AWS IoT Core currently supports only the `DATA` service type.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servicetype
     */
    readonly serviceType?: string;
    /**
     * Metadata which can be used to manage the domain configuration.
     *
     * > For URI Request parameters use format: ...key1=value1&key2=value2...
     * >
     * > For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     * >
     * > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-validationcertificatearn
     */
    readonly validationCertificateArn?: string;
}
/**
 * A CloudFormation `AWS::IoT::DomainConfiguration`
 *
 * Specifies a domain configuration.
 *
 * @cloudformationResource AWS::IoT::DomainConfiguration
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html
 */
export declare class CfnDomainConfiguration extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::DomainConfiguration";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDomainConfiguration;
    /**
     * The Amazon Resource Name (ARN) of the domain configuration.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The type of service delivered by the domain.
     * @cloudformationAttribute DomainType
     */
    readonly attrDomainType: string;
    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     * @cloudformationAttribute ServerCertificates
     */
    readonly attrServerCertificates: cdk.IResolvable;
    /**
     * An object that specifies the authorization service for a domain.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-authorizerconfig
     */
    authorizerConfig: CfnDomainConfiguration.AuthorizerConfigProperty | cdk.IResolvable | undefined;
    /**
     * The name of the domain configuration. This value must be unique to a region.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationname
     */
    domainConfigurationName: string | undefined;
    /**
     * The status to which the domain configuration should be updated.
     *
     * Valid values: `ENABLED` | `DISABLED`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainconfigurationstatus
     */
    domainConfigurationStatus: string | undefined;
    /**
     * The name of the domain.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-domainname
     */
    domainName: string | undefined;
    /**
     * The ARNs of the certificates that AWS IoT passes to the device during the TLS handshake. Currently you can specify only one certificate ARN. This value is not required for AWS -managed domains.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servercertificatearns
     */
    serverCertificateArns: string[] | undefined;
    /**
     * The type of service delivered by the endpoint.
     *
     * > AWS IoT Core currently supports only the `DATA` service type.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-servicetype
     */
    serviceType: string | undefined;
    /**
     * Metadata which can be used to manage the domain configuration.
     *
     * > For URI Request parameters use format: ...key1=value1&key2=value2...
     * >
     * > For the CLI command-line parameter use format: &&tags "key1=value1&key2=value2..."
     * >
     * > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * The certificate used to validate the server certificate and prove domain name ownership. This certificate must be signed by a public certificate authority. This value is not required for AWS -managed domains.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-domainconfiguration.html#cfn-iot-domainconfiguration-validationcertificatearn
     */
    validationCertificateArn: string | undefined;
    /**
     * Create a new `AWS::IoT::DomainConfiguration`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDomainConfigurationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnDomainConfiguration {
    /**
     * An object that specifies the authorization service for a domain.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html
     */
    interface AuthorizerConfigProperty {
        /**
         * A Boolean that specifies whether the domain configuration's authorization service can be overridden.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html#cfn-iot-domainconfiguration-authorizerconfig-allowauthorizeroverride
         */
        readonly allowAuthorizerOverride?: boolean | cdk.IResolvable;
        /**
         * The name of the authorization service for a domain configuration.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-authorizerconfig.html#cfn-iot-domainconfiguration-authorizerconfig-defaultauthorizername
         */
        readonly defaultAuthorizerName?: string;
    }
}
export declare namespace CfnDomainConfiguration {
    /**
     * An object that contains information about a server certificate.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html
     */
    interface ServerCertificateSummaryProperty {
        /**
         * The ARN of the server certificate.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatearn
         */
        readonly serverCertificateArn?: string;
        /**
         * The status of the server certificate.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatestatus
         */
        readonly serverCertificateStatus?: string;
        /**
         * Details that explain the status of the server certificate.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-domainconfiguration-servercertificatesummary.html#cfn-iot-domainconfiguration-servercertificatesummary-servercertificatestatusdetail
         */
        readonly serverCertificateStatusDetail?: string;
    }
}
/**
 * Properties for defining a `CfnFleetMetric`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html
 */
export interface CfnFleetMetricProps {
    /**
     * The name of the fleet metric to create.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-metricname
     */
    readonly metricName: string;
    /**
     * The field to aggregate.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-aggregationfield
     */
    readonly aggregationField?: string;
    /**
     * The type of the aggregation query.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-aggregationtype
     */
    readonly aggregationType?: CfnFleetMetric.AggregationTypeProperty | cdk.IResolvable;
    /**
     * The fleet metric description.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-description
     */
    readonly description?: string;
    /**
     * The name of the index to search.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-indexname
     */
    readonly indexName?: string;
    /**
     * The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-period
     */
    readonly period?: number;
    /**
     * The search query string.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-querystring
     */
    readonly queryString?: string;
    /**
     * The query version.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-queryversion
     */
    readonly queryVersion?: string;
    /**
     * Metadata which can be used to manage the fleet metric.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * Used to support unit transformation such as milliseconds to seconds. Must be a unit supported by CW metric. Default to null.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-unit
     */
    readonly unit?: string;
}
/**
 * A CloudFormation `AWS::IoT::FleetMetric`
 *
 * Use the `AWS::IoT::FleetMetric` resource to declare a fleet metric.
 *
 * @cloudformationResource AWS::IoT::FleetMetric
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html
 */
export declare class CfnFleetMetric extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::FleetMetric";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFleetMetric;
    /**
     * The time the fleet metric was created.
     * @cloudformationAttribute CreationDate
     */
    readonly attrCreationDate: cdk.IResolvable;
    /**
     * The time the fleet metric was last modified.
     * @cloudformationAttribute LastModifiedDate
     */
    readonly attrLastModifiedDate: cdk.IResolvable;
    /**
     * The Amazon Resource Name (ARN) of the fleet metric.
     * @cloudformationAttribute MetricArn
     */
    readonly attrMetricArn: string;
    /**
     * The fleet metric version.
     * @cloudformationAttribute Version
     */
    readonly attrVersion: cdk.IResolvable;
    /**
     * The name of the fleet metric to create.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-metricname
     */
    metricName: string;
    /**
     * The field to aggregate.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-aggregationfield
     */
    aggregationField: string | undefined;
    /**
     * The type of the aggregation query.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-aggregationtype
     */
    aggregationType: CfnFleetMetric.AggregationTypeProperty | cdk.IResolvable | undefined;
    /**
     * The fleet metric description.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-description
     */
    description: string | undefined;
    /**
     * The name of the index to search.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-indexname
     */
    indexName: string | undefined;
    /**
     * The time in seconds between fleet metric emissions. Range [60(1 min), 86400(1 day)] and must be multiple of 60.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-period
     */
    period: number | undefined;
    /**
     * The search query string.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-querystring
     */
    queryString: string | undefined;
    /**
     * The query version.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-queryversion
     */
    queryVersion: string | undefined;
    /**
     * Metadata which can be used to manage the fleet metric.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Used to support unit transformation such as milliseconds to seconds. Must be a unit supported by CW metric. Default to null.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-fleetmetric.html#cfn-iot-fleetmetric-unit
     */
    unit: string | undefined;
    /**
     * Create a new `AWS::IoT::FleetMetric`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFleetMetricProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnFleetMetric {
    /**
     * The type of aggregation queries.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-fleetmetric-aggregationtype.html
     */
    interface AggregationTypeProperty {
        /**
         * The name of the aggregation type.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-fleetmetric-aggregationtype.html#cfn-iot-fleetmetric-aggregationtype-name
         */
        readonly name: string;
        /**
         * A list of the values of aggregation types.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-fleetmetric-aggregationtype.html#cfn-iot-fleetmetric-aggregationtype-values
         */
        readonly values: string[];
    }
}
/**
 * Properties for defining a `CfnJobTemplate`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html
 */
export interface CfnJobTemplateProps {
    /**
     * A description of the job template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-description
     */
    readonly description: string;
    /**
     * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobtemplateid
     */
    readonly jobTemplateId: string;
    /**
     * The criteria that determine when and how a job abort takes place.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-abortconfig
     */
    readonly abortConfig?: any | cdk.IResolvable;
    /**
     * The job document.
     *
     * Required if you don't specify a value for `documentSource` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-document
     */
    readonly document?: string;
    /**
     * An S3 link to the job document to use in the template. Required if you don't specify a value for `document` .
     *
     * > If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * >
     * > The placeholder link is of the following form:
     * >
     * > `${aws:iot:s3-presigned-url:https://s3.amazonaws.com/ *bucket* / *key* }`
     * >
     * > where *bucket* is your bucket name and *key* is the object in the bucket to which you are linking.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-documentsource
     */
    readonly documentSource?: string;
    /**
     * The ARN of the job to use as the basis for the job template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobarn
     */
    readonly jobArn?: string;
    /**
     * Allows you to create the criteria to retry a job.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig
     */
    readonly jobExecutionsRetryConfig?: any | cdk.IResolvable;
    /**
     * Allows you to create a staged rollout of a job.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig
     */
    readonly jobExecutionsRolloutConfig?: any | cdk.IResolvable;
    /**
     * Configuration for pre-signed S3 URLs.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-presignedurlconfig
     */
    readonly presignedUrlConfig?: any | cdk.IResolvable;
    /**
     * Metadata that can be used to manage the job template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS` . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-timeoutconfig
     */
    readonly timeoutConfig?: any | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT::JobTemplate`
 *
 * Represents a job template.
 *
 * @cloudformationResource AWS::IoT::JobTemplate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html
 */
export declare class CfnJobTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::JobTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnJobTemplate;
    /**
     * The ARN of the job to use as the basis for the job template.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * A description of the job template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-description
     */
    description: string;
    /**
     * A unique identifier for the job template. We recommend using a UUID. Alpha-numeric characters, "-", and "_" are valid for use here.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobtemplateid
     */
    jobTemplateId: string;
    /**
     * The criteria that determine when and how a job abort takes place.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-abortconfig
     */
    abortConfig: any | cdk.IResolvable | undefined;
    /**
     * The job document.
     *
     * Required if you don't specify a value for `documentSource` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-document
     */
    document: string | undefined;
    /**
     * An S3 link to the job document to use in the template. Required if you don't specify a value for `document` .
     *
     * > If the job document resides in an S3 bucket, you must use a placeholder link when specifying the document.
     * >
     * > The placeholder link is of the following form:
     * >
     * > `${aws:iot:s3-presigned-url:https://s3.amazonaws.com/ *bucket* / *key* }`
     * >
     * > where *bucket* is your bucket name and *key* is the object in the bucket to which you are linking.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-documentsource
     */
    documentSource: string | undefined;
    /**
     * The ARN of the job to use as the basis for the job template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobarn
     */
    jobArn: string | undefined;
    /**
     * Allows you to create the criteria to retry a job.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsretryconfig
     */
    jobExecutionsRetryConfig: any | cdk.IResolvable | undefined;
    /**
     * Allows you to create a staged rollout of a job.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-jobexecutionsrolloutconfig
     */
    jobExecutionsRolloutConfig: any | cdk.IResolvable | undefined;
    /**
     * Configuration for pre-signed S3 URLs.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-presignedurlconfig
     */
    presignedUrlConfig: any | cdk.IResolvable | undefined;
    /**
     * Metadata that can be used to manage the job template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Specifies the amount of time each device has to finish its execution of the job. A timer is started when the job execution status is set to `IN_PROGRESS` . If the job execution status is not set to another terminal state before the timer expires, it will be automatically set to `TIMED_OUT` .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-jobtemplate.html#cfn-iot-jobtemplate-timeoutconfig
     */
    timeoutConfig: any | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::IoT::JobTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnJobTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnLogging`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html
 */
export interface CfnLoggingProps {
    /**
     * The account ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html#cfn-iot-logging-accountid
     */
    readonly accountId: string;
    /**
     * The default log level. Valid Values: `DEBUG | INFO | ERROR | WARN | DISABLED`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html#cfn-iot-logging-defaultloglevel
     */
    readonly defaultLogLevel: string;
    /**
     * The role ARN used for the log.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html#cfn-iot-logging-rolearn
     */
    readonly roleArn: string;
}
/**
 * A CloudFormation `AWS::IoT::Logging`
 *
 * Configure logging.
 *
 * @cloudformationResource AWS::IoT::Logging
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html
 */
export declare class CfnLogging extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Logging";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLogging;
    /**
     * The account ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html#cfn-iot-logging-accountid
     */
    accountId: string;
    /**
     * The default log level. Valid Values: `DEBUG | INFO | ERROR | WARN | DISABLED`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html#cfn-iot-logging-defaultloglevel
     */
    defaultLogLevel: string;
    /**
     * The role ARN used for the log.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-logging.html#cfn-iot-logging-rolearn
     */
    roleArn: string;
    /**
     * Create a new `AWS::IoT::Logging`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLoggingProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnMitigationAction`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html
 */
export interface CfnMitigationActionProps {
    /**
     * The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionparams
     */
    readonly actionParams: CfnMitigationAction.ActionParamsProperty | cdk.IResolvable;
    /**
     * The IAM role ARN used to apply this mitigation action.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-rolearn
     */
    readonly roleArn: string;
    /**
     * The friendly name of the mitigation action.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionname
     */
    readonly actionName?: string;
    /**
     * Metadata that can be used to manage the mitigation action.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoT::MitigationAction`
 *
 * Defines an action that can be applied to audit findings by using StartAuditMitigationActionsTask. For API reference, see [CreateMitigationAction](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateMitigationAction.html) and for general information, see [Mitigation actions](https://docs.aws.amazon.com/iot/latest/developerguide/dd-mitigation-actions.html) .
 *
 * @cloudformationResource AWS::IoT::MitigationAction
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html
 */
export declare class CfnMitigationAction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::MitigationAction";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnMitigationAction;
    /**
     * The Amazon Resource Name (ARN) of the mitigation action.
     * @cloudformationAttribute MitigationActionArn
     */
    readonly attrMitigationActionArn: string;
    /**
     * The ID of the mitigation action.
     * @cloudformationAttribute MitigationActionId
     */
    readonly attrMitigationActionId: string;
    /**
     * The set of parameters for this mitigation action. The parameters vary, depending on the kind of action you apply.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionparams
     */
    actionParams: CfnMitigationAction.ActionParamsProperty | cdk.IResolvable;
    /**
     * The IAM role ARN used to apply this mitigation action.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-rolearn
     */
    roleArn: string;
    /**
     * The friendly name of the mitigation action.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-actionname
     */
    actionName: string | undefined;
    /**
     * Metadata that can be used to manage the mitigation action.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-mitigationaction.html#cfn-iot-mitigationaction-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoT::MitigationAction`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnMitigationActionProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnMitigationAction {
    /**
     * Defines the type of action and the parameters for that action.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html
     */
    interface ActionParamsProperty {
        /**
         * Specifies the group to which you want to add the devices.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-addthingstothinggroupparams
         */
        readonly addThingsToThingGroupParams?: CfnMitigationAction.AddThingsToThingGroupParamsProperty | cdk.IResolvable;
        /**
         * Specifies the logging level and the role with permissions for logging. You cannot specify a logging level of `DISABLED` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-enableiotloggingparams
         */
        readonly enableIoTLoggingParams?: CfnMitigationAction.EnableIoTLoggingParamsProperty | cdk.IResolvable;
        /**
         * Specifies the topic to which the finding should be published.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-publishfindingtosnsparams
         */
        readonly publishFindingToSnsParams?: CfnMitigationAction.PublishFindingToSnsParamsProperty | cdk.IResolvable;
        /**
         * Replaces the policy version with a default or blank policy. You specify the template name. Only a value of `BLANK_POLICY` is currently supported.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-replacedefaultpolicyversionparams
         */
        readonly replaceDefaultPolicyVersionParams?: CfnMitigationAction.ReplaceDefaultPolicyVersionParamsProperty | cdk.IResolvable;
        /**
         * Specifies the new state for the CA certificate. Only a value of `DEACTIVATE` is currently supported.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-updatecacertificateparams
         */
        readonly updateCaCertificateParams?: CfnMitigationAction.UpdateCACertificateParamsProperty | cdk.IResolvable;
        /**
         * Specifies the new state for a device certificate. Only a value of `DEACTIVATE` is currently supported.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-actionparams.html#cfn-iot-mitigationaction-actionparams-updatedevicecertificateparams
         */
        readonly updateDeviceCertificateParams?: CfnMitigationAction.UpdateDeviceCertificateParamsProperty | cdk.IResolvable;
    }
}
export declare namespace CfnMitigationAction {
    /**
     * Parameters used when defining a mitigation action that move a set of things to a thing group.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html
     */
    interface AddThingsToThingGroupParamsProperty {
        /**
         * Specifies if this mitigation action can move the things that triggered the mitigation action even if they are part of one or more dynamic thing groups.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html#cfn-iot-mitigationaction-addthingstothinggroupparams-overridedynamicgroups
         */
        readonly overrideDynamicGroups?: boolean | cdk.IResolvable;
        /**
         * The list of groups to which you want to add the things that triggered the mitigation action. You can add a thing to a maximum of 10 groups, but you can't add a thing to more than one group in the same hierarchy.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-addthingstothinggroupparams.html#cfn-iot-mitigationaction-addthingstothinggroupparams-thinggroupnames
         */
        readonly thingGroupNames: string[];
    }
}
export declare namespace CfnMitigationAction {
    /**
     * Parameters used when defining a mitigation action that enable AWS IoT Core logging.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html
     */
    interface EnableIoTLoggingParamsProperty {
        /**
         * Specifies the type of information to be logged.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html#cfn-iot-mitigationaction-enableiotloggingparams-loglevel
         */
        readonly logLevel: string;
        /**
         * The Amazon Resource Name (ARN) of the IAM role used for logging.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-enableiotloggingparams.html#cfn-iot-mitigationaction-enableiotloggingparams-rolearnforlogging
         */
        readonly roleArnForLogging: string;
    }
}
export declare namespace CfnMitigationAction {
    /**
     * Parameters to define a mitigation action that publishes findings to Amazon SNS. You can implement your own custom actions in response to the Amazon SNS messages.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-publishfindingtosnsparams.html
     */
    interface PublishFindingToSnsParamsProperty {
        /**
         * The ARN of the topic to which you want to publish the findings.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-publishfindingtosnsparams.html#cfn-iot-mitigationaction-publishfindingtosnsparams-topicarn
         */
        readonly topicArn: string;
    }
}
export declare namespace CfnMitigationAction {
    /**
     * Parameters to define a mitigation action that adds a blank policy to restrict permissions.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-replacedefaultpolicyversionparams.html
     */
    interface ReplaceDefaultPolicyVersionParamsProperty {
        /**
         * The name of the template to be applied. The only supported value is `BLANK_POLICY` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-replacedefaultpolicyversionparams.html#cfn-iot-mitigationaction-replacedefaultpolicyversionparams-templatename
         */
        readonly templateName: string;
    }
}
export declare namespace CfnMitigationAction {
    /**
     * Parameters to define a mitigation action that changes the state of the CA certificate to inactive.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatecacertificateparams.html
     */
    interface UpdateCACertificateParamsProperty {
        /**
         * The action that you want to apply to the CA certificate. The only supported value is `DEACTIVATE` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatecacertificateparams.html#cfn-iot-mitigationaction-updatecacertificateparams-action
         */
        readonly action: string;
    }
}
export declare namespace CfnMitigationAction {
    /**
     * Parameters to define a mitigation action that changes the state of the device certificate to inactive.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatedevicecertificateparams.html
     */
    interface UpdateDeviceCertificateParamsProperty {
        /**
         * The action that you want to apply to the device certificate. The only supported value is `DEACTIVATE` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-mitigationaction-updatedevicecertificateparams.html#cfn-iot-mitigationaction-updatedevicecertificateparams-action
         */
        readonly action: string;
    }
}
/**
 * Properties for defining a `CfnPolicy`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html
 */
export interface CfnPolicyProps {
    /**
     * The JSON document that describes the policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policydocument
     */
    readonly policyDocument: any | cdk.IResolvable;
    /**
     * The policy name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policyname
     */
    readonly policyName?: string;
}
/**
 * A CloudFormation `AWS::IoT::Policy`
 *
 * Use the `AWS::IoT::Policy` resource to declare an AWS IoT policy. For more information about working with AWS IoT policies, see [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/authorization.html) in the *AWS IoT Developer Guide* .
 *
 * @cloudformationResource AWS::IoT::Policy
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html
 */
export declare class CfnPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Policy";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPolicy;
    /**
     * The Amazon Resource Name (ARN) of the AWS IoT policy, such as `arn:aws:iot:us-east-2:123456789012:policy/MyPolicy` .
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     *
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * The JSON document that describes the policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policydocument
     */
    policyDocument: any | cdk.IResolvable;
    /**
     * The policy name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policy.html#cfn-iot-policy-policyname
     */
    policyName: string | undefined;
    /**
     * Create a new `AWS::IoT::Policy`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnPolicyPrincipalAttachment`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html
 */
export interface CfnPolicyPrincipalAttachmentProps {
    /**
     * The name of the AWS IoT policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-policyname
     */
    readonly policyName: string;
    /**
     * The principal, which can be a certificate ARN (as returned from the `CreateCertificate` operation) or an Amazon Cognito ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-principal
     */
    readonly principal: string;
}
/**
 * A CloudFormation `AWS::IoT::PolicyPrincipalAttachment`
 *
 * Use the `AWS::IoT::PolicyPrincipalAttachment` resource to attach an AWS IoT policy to a principal (an X.509 certificate or other credential).
 *
 * For information about working with AWS IoT policies and principals, see [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/authorization.html) in the *AWS IoT Developer Guide* .
 *
 * @cloudformationResource AWS::IoT::PolicyPrincipalAttachment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html
 */
export declare class CfnPolicyPrincipalAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::PolicyPrincipalAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPolicyPrincipalAttachment;
    /**
     * The name of the AWS IoT policy.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-policyname
     */
    policyName: string;
    /**
     * The principal, which can be a certificate ARN (as returned from the `CreateCertificate` operation) or an Amazon Cognito ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-policyprincipalattachment.html#cfn-iot-policyprincipalattachment-principal
     */
    principal: string;
    /**
     * Create a new `AWS::IoT::PolicyPrincipalAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPolicyPrincipalAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnProvisioningTemplate`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html
 */
export interface CfnProvisioningTemplateProps {
    /**
     * The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-provisioningrolearn
     */
    readonly provisioningRoleArn: string;
    /**
     * The JSON formatted contents of the fleet provisioning template version.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatebody
     */
    readonly templateBody: string;
    /**
     * The description of the fleet provisioning template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-description
     */
    readonly description?: string;
    /**
     * True to enable the fleet provisioning template, otherwise false.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-enabled
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * Creates a pre-provisioning hook template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-preprovisioninghook
     */
    readonly preProvisioningHook?: CfnProvisioningTemplate.ProvisioningHookProperty | cdk.IResolvable;
    /**
     * Metadata that can be used to manage the fleet provisioning template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * The name of the fleet provisioning template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatename
     */
    readonly templateName?: string;
    /**
     * `AWS::IoT::ProvisioningTemplate.TemplateType`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatetype
     */
    readonly templateType?: string;
}
/**
 * A CloudFormation `AWS::IoT::ProvisioningTemplate`
 *
 * Creates a fleet provisioning template.
 *
 * @cloudformationResource AWS::IoT::ProvisioningTemplate
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html
 */
export declare class CfnProvisioningTemplate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::ProvisioningTemplate";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnProvisioningTemplate;
    /**
     * The ARN that identifies the provisioning template.
     * @cloudformationAttribute TemplateArn
     */
    readonly attrTemplateArn: string;
    /**
     * The role ARN for the role associated with the fleet provisioning template. This IoT role grants permission to provision a device.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-provisioningrolearn
     */
    provisioningRoleArn: string;
    /**
     * The JSON formatted contents of the fleet provisioning template version.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatebody
     */
    templateBody: string;
    /**
     * The description of the fleet provisioning template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-description
     */
    description: string | undefined;
    /**
     * True to enable the fleet provisioning template, otherwise false.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-enabled
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * Creates a pre-provisioning hook template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-preprovisioninghook
     */
    preProvisioningHook: CfnProvisioningTemplate.ProvisioningHookProperty | cdk.IResolvable | undefined;
    /**
     * Metadata that can be used to manage the fleet provisioning template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * The name of the fleet provisioning template.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatename
     */
    templateName: string | undefined;
    /**
     * `AWS::IoT::ProvisioningTemplate.TemplateType`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-provisioningtemplate.html#cfn-iot-provisioningtemplate-templatetype
     */
    templateType: string | undefined;
    /**
     * Create a new `AWS::IoT::ProvisioningTemplate`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnProvisioningTemplateProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnProvisioningTemplate {
    /**
     * Structure that contains payloadVersion and targetArn. Provisioning hooks can be used when fleet provisioning to validate device parameters before allowing the device to be provisioned.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-provisioninghook.html
     */
    interface ProvisioningHookProperty {
        /**
         * The payload that was sent to the target function. The valid payload is `"2020-04-01"` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-provisioninghook.html#cfn-iot-provisioningtemplate-provisioninghook-payloadversion
         */
        readonly payloadVersion?: string;
        /**
         * The ARN of the target function.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-provisioningtemplate-provisioninghook.html#cfn-iot-provisioningtemplate-provisioninghook-targetarn
         */
        readonly targetArn?: string;
    }
}
/**
 * Properties for defining a `CfnResourceSpecificLogging`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html
 */
export interface CfnResourceSpecificLoggingProps {
    /**
     * The default log level.Valid Values: `DEBUG | INFO | ERROR | WARN | DISABLED`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html#cfn-iot-resourcespecificlogging-loglevel
     */
    readonly logLevel: string;
    /**
     * The target name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html#cfn-iot-resourcespecificlogging-targetname
     */
    readonly targetName: string;
    /**
     * The target type. Valid Values: `DEFAULT | THING_GROUP`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html#cfn-iot-resourcespecificlogging-targettype
     */
    readonly targetType: string;
}
/**
 * A CloudFormation `AWS::IoT::ResourceSpecificLogging`
 *
 * Configure resource-specific logging.
 *
 * @cloudformationResource AWS::IoT::ResourceSpecificLogging
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html
 */
export declare class CfnResourceSpecificLogging extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::ResourceSpecificLogging";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnResourceSpecificLogging;
    /**
     * The target Id.
     * @cloudformationAttribute TargetId
     */
    readonly attrTargetId: string;
    /**
     * The default log level.Valid Values: `DEBUG | INFO | ERROR | WARN | DISABLED`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html#cfn-iot-resourcespecificlogging-loglevel
     */
    logLevel: string;
    /**
     * The target name.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html#cfn-iot-resourcespecificlogging-targetname
     */
    targetName: string;
    /**
     * The target type. Valid Values: `DEFAULT | THING_GROUP`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-resourcespecificlogging.html#cfn-iot-resourcespecificlogging-targettype
     */
    targetType: string;
    /**
     * Create a new `AWS::IoT::ResourceSpecificLogging`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnResourceSpecificLoggingProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnRoleAlias`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html
 */
export interface CfnRoleAliasProps {
    /**
     * The role ARN.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-rolearn
     */
    readonly roleArn: string;
    /**
     * The number of seconds for which the credential is valid.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-credentialdurationseconds
     */
    readonly credentialDurationSeconds?: number;
    /**
     * The role alias.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-rolealias
     */
    readonly roleAlias?: string;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoT::RoleAlias`
 *
 * Specifies a role alias.
 *
 * Requires permission to access the [CreateRoleAlias](https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions) action.
 *
 * @cloudformationResource AWS::IoT::RoleAlias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html
 */
export declare class CfnRoleAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::RoleAlias";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnRoleAlias;
    /**
     * The role alias ARN.
     * @cloudformationAttribute RoleAliasArn
     */
    readonly attrRoleAliasArn: string;
    /**
     * The role ARN.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-rolearn
     */
    roleArn: string;
    /**
     * The number of seconds for which the credential is valid.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-credentialdurationseconds
     */
    credentialDurationSeconds: number | undefined;
    /**
     * The role alias.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-rolealias
     */
    roleAlias: string | undefined;
    /**
     * An array of key-value pairs to apply to this resource.
     *
     * For more information, see [Tag](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html) .
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-rolealias.html#cfn-iot-rolealias-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoT::RoleAlias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnRoleAliasProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnScheduledAudit`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html
 */
export interface CfnScheduledAuditProps {
    /**
     * How often the scheduled audit occurs.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-frequency
     */
    readonly frequency: string;
    /**
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
     *
     * The following checks are currently aviable:
     *
     * - `AUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK`
     * - `CA_CERTIFICATE_EXPIRING_CHECK`
     * - `CA_CERTIFICATE_KEY_QUALITY_CHECK`
     * - `CONFLICTING_CLIENT_IDS_CHECK`
     * - `DEVICE_CERTIFICATE_EXPIRING_CHECK`
     * - `DEVICE_CERTIFICATE_KEY_QUALITY_CHECK`
     * - `DEVICE_CERTIFICATE_SHARED_CHECK`
     * - `IOT_POLICY_OVERLY_PERMISSIVE_CHECK`
     * - `IOT_ROLE_ALIAS_ALLOWS_ACCESS_TO_UNUSED_SERVICES_CHECK`
     * - `IOT_ROLE_ALIAS_OVERLY_PERMISSIVE_CHECK`
     * - `LOGGING_DISABLED_CHECK`
     * - `REVOKED_CA_CERTIFICATE_STILL_ACTIVE_CHECK`
     * - `REVOKED_DEVICE_CERTIFICATE_STILL_ACTIVE_CHECK`
     * - `UNAUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-targetchecknames
     */
    readonly targetCheckNames: string[];
    /**
     * The day of the month on which the scheduled audit is run (if the `frequency` is "MONTHLY"). If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofmonth
     */
    readonly dayOfMonth?: string;
    /**
     * The day of the week on which the scheduled audit is run (if the `frequency` is "WEEKLY" or "BIWEEKLY").
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofweek
     */
    readonly dayOfWeek?: string;
    /**
     * The name of the scheduled audit.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-scheduledauditname
     */
    readonly scheduledAuditName?: string;
    /**
     * Metadata that can be used to manage the scheduled audit.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoT::ScheduledAudit`
 *
 * Use the `AWS::IoT::ScheduledAudit` resource to create a scheduled audit that is run at a specified time interval. For API reference, see [CreateScheduleAudit](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateScheduledAudit.html) and for general information, see [Audit](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-audit.html) .
 *
 * @cloudformationResource AWS::IoT::ScheduledAudit
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html
 */
export declare class CfnScheduledAudit extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::ScheduledAudit";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnScheduledAudit;
    /**
     * The ARN of the scheduled audit.
     * @cloudformationAttribute ScheduledAuditArn
     */
    readonly attrScheduledAuditArn: string;
    /**
     * How often the scheduled audit occurs.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-frequency
     */
    frequency: string;
    /**
     * Which checks are performed during the scheduled audit. Checks must be enabled for your account. (Use `DescribeAccountAuditConfiguration` to see the list of all checks, including those that are enabled or use `UpdateAccountAuditConfiguration` to select which checks are enabled.)
     *
     * The following checks are currently aviable:
     *
     * - `AUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK`
     * - `CA_CERTIFICATE_EXPIRING_CHECK`
     * - `CA_CERTIFICATE_KEY_QUALITY_CHECK`
     * - `CONFLICTING_CLIENT_IDS_CHECK`
     * - `DEVICE_CERTIFICATE_EXPIRING_CHECK`
     * - `DEVICE_CERTIFICATE_KEY_QUALITY_CHECK`
     * - `DEVICE_CERTIFICATE_SHARED_CHECK`
     * - `IOT_POLICY_OVERLY_PERMISSIVE_CHECK`
     * - `IOT_ROLE_ALIAS_ALLOWS_ACCESS_TO_UNUSED_SERVICES_CHECK`
     * - `IOT_ROLE_ALIAS_OVERLY_PERMISSIVE_CHECK`
     * - `LOGGING_DISABLED_CHECK`
     * - `REVOKED_CA_CERTIFICATE_STILL_ACTIVE_CHECK`
     * - `REVOKED_DEVICE_CERTIFICATE_STILL_ACTIVE_CHECK`
     * - `UNAUTHENTICATED_COGNITO_ROLE_OVERLY_PERMISSIVE_CHECK`
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-targetchecknames
     */
    targetCheckNames: string[];
    /**
     * The day of the month on which the scheduled audit is run (if the `frequency` is "MONTHLY"). If days 29-31 are specified, and the month does not have that many days, the audit takes place on the "LAST" day of the month.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofmonth
     */
    dayOfMonth: string | undefined;
    /**
     * The day of the week on which the scheduled audit is run (if the `frequency` is "WEEKLY" or "BIWEEKLY").
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-dayofweek
     */
    dayOfWeek: string | undefined;
    /**
     * The name of the scheduled audit.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-scheduledauditname
     */
    scheduledAuditName: string | undefined;
    /**
     * Metadata that can be used to manage the scheduled audit.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-scheduledaudit.html#cfn-iot-scheduledaudit-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoT::ScheduledAudit`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScheduledAuditProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnSecurityProfile`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html
 */
export interface CfnSecurityProfileProps {
    /**
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's `behaviors` , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2
     */
    readonly additionalMetricsToRetainV2?: Array<CfnSecurityProfile.MetricToRetainProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets
     */
    readonly alertTargets?: {
        [key: string]: (CfnSecurityProfile.AlertTargetProperty | cdk.IResolvable);
    } | cdk.IResolvable;
    /**
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors
     */
    readonly behaviors?: Array<CfnSecurityProfile.BehaviorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * A description of the security profile.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofiledescription
     */
    readonly securityProfileDescription?: string;
    /**
     * The name you gave to the security profile.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofilename
     */
    readonly securityProfileName?: string;
    /**
     * Metadata that can be used to manage the security profile.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * The ARN of the target (thing group) to which the security profile is attached.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-targetarns
     */
    readonly targetArns?: string[];
}
/**
 * A CloudFormation `AWS::IoT::SecurityProfile`
 *
 * Use the `AWS::IoT::SecurityProfile` resource to create a Device Defender security profile. For API reference, see [CreateSecurityProfile](https://docs.aws.amazon.com/iot/latest/apireference/API_CreateSecurityProfile.html) and for general information, see [Detect](https://docs.aws.amazon.com/iot/latest/developerguide/device-defender-detect.html) .
 *
 * @cloudformationResource AWS::IoT::SecurityProfile
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html
 */
export declare class CfnSecurityProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::SecurityProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnSecurityProfile;
    /**
     * The Amazon Resource Name (ARN) of the security profile.
     * @cloudformationAttribute SecurityProfileArn
     */
    readonly attrSecurityProfileArn: string;
    /**
     * A list of metrics whose data is retained (stored). By default, data is retained for any metric used in the profile's `behaviors` , but it's also retained for any metric specified here. Can be used with custom metrics; can't be used with dimensions.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-additionalmetricstoretainv2
     */
    additionalMetricsToRetainV2: Array<CfnSecurityProfile.MetricToRetainProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Specifies the destinations to which alerts are sent. (Alerts are always sent to the console.) Alerts are generated when a device (thing) violates a behavior.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-alerttargets
     */
    alertTargets: {
        [key: string]: (CfnSecurityProfile.AlertTargetProperty | cdk.IResolvable);
    } | cdk.IResolvable | undefined;
    /**
     * Specifies the behaviors that, when violated by a device (thing), cause an alert.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-behaviors
     */
    behaviors: Array<CfnSecurityProfile.BehaviorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * A description of the security profile.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofiledescription
     */
    securityProfileDescription: string | undefined;
    /**
     * The name you gave to the security profile.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-securityprofilename
     */
    securityProfileName: string | undefined;
    /**
     * Metadata that can be used to manage the security profile.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * The ARN of the target (thing group) to which the security profile is attached.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-securityprofile.html#cfn-iot-securityprofile-targetarns
     */
    targetArns: string[] | undefined;
    /**
     * Create a new `AWS::IoT::SecurityProfile`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnSecurityProfileProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnSecurityProfile {
    /**
     * A structure containing the alert target ARN and the role ARN.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html
     */
    interface AlertTargetProperty {
        /**
         * The Amazon Resource Name (ARN) of the notification target to which alerts are sent.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html#cfn-iot-securityprofile-alerttarget-alerttargetarn
         */
        readonly alertTargetArn: string;
        /**
         * The ARN of the role that grants permission to send alerts to the notification target.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-alerttarget.html#cfn-iot-securityprofile-alerttarget-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * A Device Defender security profile behavior.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html
     */
    interface BehaviorProperty {
        /**
         * The criteria that determine if a device is behaving normally in regard to the `metric` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-criteria
         */
        readonly criteria?: CfnSecurityProfile.BehaviorCriteriaProperty | cdk.IResolvable;
        /**
         * What is measured by the behavior.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-metric
         */
        readonly metric?: string;
        /**
         * The dimension of the metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-metricdimension
         */
        readonly metricDimension?: CfnSecurityProfile.MetricDimensionProperty | cdk.IResolvable;
        /**
         * The name you've given to the behavior.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-name
         */
        readonly name: string;
        /**
         * The alert status. If you set the value to `true` , alerts will be suppressed.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behavior.html#cfn-iot-securityprofile-behavior-suppressalerts
         */
        readonly suppressAlerts?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * The criteria by which the behavior is determined to be normal.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html
     */
    interface BehaviorCriteriaProperty {
        /**
         * The operator that relates the thing measured ( `metric` ) to the criteria (containing a `value` or `statisticalThreshold` ). Valid operators include:
         *
         * - `string-list` : `in-set` and `not-in-set`
         * - `number-list` : `in-set` and `not-in-set`
         * - `ip-address-list` : `in-cidr-set` and `not-in-cidr-set`
         * - `number` : `less-than` , `less-than-equals` , `greater-than` , and `greater-than-equals`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-comparisonoperator
         */
        readonly comparisonOperator?: string;
        /**
         * If a device is in violation of the behavior for the specified number of consecutive datapoints, an alarm occurs. If not specified, the default is 1.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-consecutivedatapointstoalarm
         */
        readonly consecutiveDatapointsToAlarm?: number;
        /**
         * If an alarm has occurred and the offending device is no longer in violation of the behavior for the specified number of consecutive datapoints, the alarm is cleared. If not specified, the default is 1.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-consecutivedatapointstoclear
         */
        readonly consecutiveDatapointsToClear?: number;
        /**
         * Use this to specify the time duration over which the behavior is evaluated, for those criteria that have a time dimension (for example, `NUM_MESSAGES_SENT` ). For a `statisticalThreshhold` metric comparison, measurements from all devices are accumulated over this time duration before being used to calculate percentiles, and later, measurements from an individual device are also accumulated over this time duration before being given a percentile rank. Cannot be used with list-based metric datatypes.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-durationseconds
         */
        readonly durationSeconds?: number;
        /**
         * The confidence level of the detection model.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-mldetectionconfig
         */
        readonly mlDetectionConfig?: CfnSecurityProfile.MachineLearningDetectionConfigProperty | cdk.IResolvable;
        /**
         * A statistical ranking (percentile)that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-statisticalthreshold
         */
        readonly statisticalThreshold?: CfnSecurityProfile.StatisticalThresholdProperty | cdk.IResolvable;
        /**
         * The value to be compared with the `metric` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-behaviorcriteria.html#cfn-iot-securityprofile-behaviorcriteria-value
         */
        readonly value?: CfnSecurityProfile.MetricValueProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * The `MachineLearningDetectionConfig` property type controls confidence of the machine learning model.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-machinelearningdetectionconfig.html
     */
    interface MachineLearningDetectionConfigProperty {
        /**
         * The model confidence level.
         *
         * There are three levels of confidence, `"high"` , `"medium"` , and `"low"` .
         *
         * The higher the confidence level, the lower the sensitivity, and the lower the alarm frequency will be.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-machinelearningdetectionconfig.html#cfn-iot-securityprofile-machinelearningdetectionconfig-confidencelevel
         */
        readonly confidenceLevel?: string;
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * The dimension of the metric.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html
     */
    interface MetricDimensionProperty {
        /**
         * The name of the dimension.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html#cfn-iot-securityprofile-metricdimension-dimensionname
         */
        readonly dimensionName: string;
        /**
         * Operators are constructs that perform logical operations. Valid values are `IN` and `NOT_IN` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricdimension.html#cfn-iot-securityprofile-metricdimension-operator
         */
        readonly operator?: string;
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * The metric you want to retain. Dimensions are optional.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html
     */
    interface MetricToRetainProperty {
        /**
         * A standard of measurement.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-metric
         */
        readonly metric: string;
        /**
         * The dimension of the metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metrictoretain.html#cfn-iot-securityprofile-metrictoretain-metricdimension
         */
        readonly metricDimension?: CfnSecurityProfile.MetricDimensionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * The value to be compared with the `metric` .
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html
     */
    interface MetricValueProperty {
        /**
         * If the `comparisonOperator` calls for a set of CIDRs, use this to specify that set to be compared with the `metric` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-cidrs
         */
        readonly cidrs?: string[];
        /**
         * If the `comparisonOperator` calls for a numeric value, use this to specify that numeric value to be compared with the `metric` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-count
         */
        readonly count?: string;
        /**
         * The numeric values of a metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-number
         */
        readonly number?: number;
        /**
         * The numeric value of a metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-numbers
         */
        readonly numbers?: number[] | cdk.IResolvable;
        /**
         * If the `comparisonOperator` calls for a set of ports, use this to specify that set to be compared with the `metric` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-ports
         */
        readonly ports?: number[] | cdk.IResolvable;
        /**
         * The string values of a metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-metricvalue.html#cfn-iot-securityprofile-metricvalue-strings
         */
        readonly strings?: string[];
    }
}
export declare namespace CfnSecurityProfile {
    /**
     * A statistical ranking (percentile) that indicates a threshold value by which a behavior is determined to be in compliance or in violation of the behavior.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-statisticalthreshold.html
     */
    interface StatisticalThresholdProperty {
        /**
         * The percentile that resolves to a threshold value by which compliance with a behavior is determined. Metrics are collected over the specified period ( `durationSeconds` ) from all reporting devices in your account and statistical ranks are calculated. Then, the measurements from a device are collected over the same period. If the accumulated measurements from the device fall above or below ( `comparisonOperator` ) the value associated with the percentile specified, then the device is considered to be in compliance with the behavior, otherwise a violation occurs.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-securityprofile-statisticalthreshold.html#cfn-iot-securityprofile-statisticalthreshold-statistic
         */
        readonly statistic?: string;
    }
}
/**
 * Properties for defining a `CfnThing`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 */
export interface CfnThingProps {
    /**
     * A string that contains up to three key value pairs. Maximum length of 800. Duplicates not allowed.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload
     */
    readonly attributePayload?: CfnThing.AttributePayloadProperty | cdk.IResolvable;
    /**
     * The name of the thing to update.
     *
     * You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname
     */
    readonly thingName?: string;
}
/**
 * A CloudFormation `AWS::IoT::Thing`
 *
 * Use the `AWS::IoT::Thing` resource to declare an AWS IoT thing.
 *
 * For information about working with things, see [How AWS IoT Works](https://docs.aws.amazon.com/iot/latest/developerguide/aws-iot-how-it-works.html) and [Device Registry for AWS IoT](https://docs.aws.amazon.com/iot/latest/developerguide/thing-registry.html) in the *AWS IoT Developer Guide* .
 *
 * @cloudformationResource AWS::IoT::Thing
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html
 */
export declare class CfnThing extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::Thing";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnThing;
    /**
     * A string that contains up to three key value pairs. Maximum length of 800. Duplicates not allowed.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-attributepayload
     */
    attributePayload: CfnThing.AttributePayloadProperty | cdk.IResolvable | undefined;
    /**
     * The name of the thing to update.
     *
     * You can't change a thing's name. To change a thing's name, you must create a new thing, give it the new name, and then delete the old thing.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html#cfn-iot-thing-thingname
     */
    thingName: string | undefined;
    /**
     * Create a new `AWS::IoT::Thing`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnThingProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnThing {
    /**
     * The AttributePayload property specifies up to three attributes for an AWS IoT as key-value pairs. AttributePayload is a property of the [AWS::IoT::Thing](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thing.html) resource.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html
     */
    interface AttributePayloadProperty {
        /**
         * A JSON string containing up to three key-value pair in JSON format. For example:
         *
         * `{\"attributes\":{\"string1\":\"string2\"}}`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-thing-attributepayload.html#cfn-iot-thing-attributepayload-attributes
         */
        readonly attributes?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `CfnThingPrincipalAttachment`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html
 */
export interface CfnThingPrincipalAttachmentProps {
    /**
     * The principal, which can be a certificate ARN (as returned from the `CreateCertificate` operation) or an Amazon Cognito ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal
     */
    readonly principal: string;
    /**
     * The name of the AWS IoT thing.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname
     */
    readonly thingName: string;
}
/**
 * A CloudFormation `AWS::IoT::ThingPrincipalAttachment`
 *
 * Use the `AWS::IoT::ThingPrincipalAttachment` resource to attach a principal (an X.509 certificate or another credential) to a thing.
 *
 * For more information about working with AWS IoT things and principals, see [Authorization](https://docs.aws.amazon.com/iot/latest/developerguide/authorization.html) in the *AWS IoT Developer Guide* .
 *
 * @cloudformationResource AWS::IoT::ThingPrincipalAttachment
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html
 */
export declare class CfnThingPrincipalAttachment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::ThingPrincipalAttachment";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnThingPrincipalAttachment;
    /**
     * The principal, which can be a certificate ARN (as returned from the `CreateCertificate` operation) or an Amazon Cognito ID.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-principal
     */
    principal: string;
    /**
     * The name of the AWS IoT thing.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingprincipalattachment.html#cfn-iot-thingprincipalattachment-thingname
     */
    thingName: string;
    /**
     * Create a new `AWS::IoT::ThingPrincipalAttachment`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnThingPrincipalAttachmentProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `CfnTopicRule`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 */
export interface CfnTopicRuleProps {
    /**
     * The rule payload.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload
     */
    readonly topicRulePayload: CfnTopicRule.TopicRulePayloadProperty | cdk.IResolvable;
    /**
     * The name of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename
     */
    readonly ruleName?: string;
    /**
     * Metadata which can be used to manage the topic rule.
     *
     * > For URI Request parameters use format: ...key1=value1&key2=value2...
     * >
     * > For the CLI command-line parameter use format: --tags "key1=value1&key2=value2..."
     * >
     * > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoT::TopicRule`
 *
 * Use the `AWS::IoT::TopicRule` resource to declare an AWS IoT rule. For information about working with AWS IoT rules, see [Rules for AWS IoT](https://docs.aws.amazon.com/iot/latest/developerguide/iot-rules.html) in the *AWS IoT Developer Guide* .
 *
 * @cloudformationResource AWS::IoT::TopicRule
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html
 */
export declare class CfnTopicRule extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::TopicRule";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTopicRule;
    /**
     * The Amazon Resource Name (ARN) of the AWS IoT rule, such as `arn:aws:iot:us-east-2:123456789012:rule/MyIoTRule` .
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * The rule payload.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-topicrulepayload
     */
    topicRulePayload: CfnTopicRule.TopicRulePayloadProperty | cdk.IResolvable;
    /**
     * The name of the rule.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-rulename
     */
    ruleName: string | undefined;
    /**
     * Metadata which can be used to manage the topic rule.
     *
     * > For URI Request parameters use format: ...key1=value1&key2=value2...
     * >
     * > For the CLI command-line parameter use format: --tags "key1=value1&key2=value2..."
     * >
     * > For the cli-input-json file use format: "tags": "key1=value1&key2=value2..."
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicrule.html#cfn-iot-topicrule-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoT::TopicRule`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props: CfnTopicRuleProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnTopicRule {
    /**
     * Describes the actions associated with a rule.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html
     */
    interface ActionProperty {
        /**
         * Change the state of a CloudWatch alarm.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchalarm
         */
        readonly cloudwatchAlarm?: CfnTopicRule.CloudwatchAlarmActionProperty | cdk.IResolvable;
        /**
         * Sends data to CloudWatch.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchlogs
         */
        readonly cloudwatchLogs?: CfnTopicRule.CloudwatchLogsActionProperty | cdk.IResolvable;
        /**
         * Capture a CloudWatch metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-cloudwatchmetric
         */
        readonly cloudwatchMetric?: CfnTopicRule.CloudwatchMetricActionProperty | cdk.IResolvable;
        /**
         * Write to a DynamoDB table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodb
         */
        readonly dynamoDb?: CfnTopicRule.DynamoDBActionProperty | cdk.IResolvable;
        /**
         * Write to a DynamoDB table. This is a new version of the DynamoDB action. It allows you to write each attribute in an MQTT message payload into a separate DynamoDB column.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-dynamodbv2
         */
        readonly dynamoDBv2?: CfnTopicRule.DynamoDBv2ActionProperty | cdk.IResolvable;
        /**
         * Write data to an Amazon OpenSearch Service domain.
         *
         * > The `Elasticsearch` action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the `OpenSearch` rule action instead. For more information, see [OpenSearchAction](https://docs.aws.amazon.com//iot/latest/apireference/API_OpenSearchAction.html) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-elasticsearch
         */
        readonly elasticsearch?: CfnTopicRule.ElasticsearchActionProperty | cdk.IResolvable;
        /**
         * Write to an Amazon Kinesis Firehose stream.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-firehose
         */
        readonly firehose?: CfnTopicRule.FirehoseActionProperty | cdk.IResolvable;
        /**
         * Send data to an HTTPS endpoint.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-http
         */
        readonly http?: CfnTopicRule.HttpActionProperty | cdk.IResolvable;
        /**
         * Sends message data to an AWS IoT Analytics channel.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotanalytics
         */
        readonly iotAnalytics?: CfnTopicRule.IotAnalyticsActionProperty | cdk.IResolvable;
        /**
         * Sends an input to an AWS IoT Events detector.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotevents
         */
        readonly iotEvents?: CfnTopicRule.IotEventsActionProperty | cdk.IResolvable;
        /**
         * Sends data from the MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-iotsitewise
         */
        readonly iotSiteWise?: CfnTopicRule.IotSiteWiseActionProperty | cdk.IResolvable;
        /**
         * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kafka
         */
        readonly kafka?: CfnTopicRule.KafkaActionProperty | cdk.IResolvable;
        /**
         * Write data to an Amazon Kinesis stream.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-kinesis
         */
        readonly kinesis?: CfnTopicRule.KinesisActionProperty | cdk.IResolvable;
        /**
         * Invoke a Lambda function.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-lambda
         */
        readonly lambda?: CfnTopicRule.LambdaActionProperty | cdk.IResolvable;
        /**
         * `CfnTopicRule.ActionProperty.Location`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-location
         */
        readonly location?: CfnTopicRule.LocationActionProperty | cdk.IResolvable;
        /**
         * Write data to an Amazon OpenSearch Service domain.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-opensearch
         */
        readonly openSearch?: CfnTopicRule.OpenSearchActionProperty | cdk.IResolvable;
        /**
         * Publish to another MQTT topic.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-republish
         */
        readonly republish?: CfnTopicRule.RepublishActionProperty | cdk.IResolvable;
        /**
         * Write to an Amazon S3 bucket.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-s3
         */
        readonly s3?: CfnTopicRule.S3ActionProperty | cdk.IResolvable;
        /**
         * Publish to an Amazon SNS topic.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sns
         */
        readonly sns?: CfnTopicRule.SnsActionProperty | cdk.IResolvable;
        /**
         * Publish to an Amazon SQS queue.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-sqs
         */
        readonly sqs?: CfnTopicRule.SqsActionProperty | cdk.IResolvable;
        /**
         * Starts execution of a Step Functions state machine.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-stepfunctions
         */
        readonly stepFunctions?: CfnTopicRule.StepFunctionsActionProperty | cdk.IResolvable;
        /**
         * Writes attributes from an MQTT message.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-action.html#cfn-iot-topicrule-action-timestream
         */
        readonly timestream?: CfnTopicRule.TimestreamActionProperty | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * An asset property timestamp entry containing the following information.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html
     */
    interface AssetPropertyTimestampProperty {
        /**
         * Optional. A string that contains the nanosecond time offset. Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-offsetinnanos
         */
        readonly offsetInNanos?: string;
        /**
         * A string that contains the time in seconds since epoch. Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertytimestamp.html#cfn-iot-topicrule-assetpropertytimestamp-timeinseconds
         */
        readonly timeInSeconds: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * An asset property value entry containing the following information.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html
     */
    interface AssetPropertyValueProperty {
        /**
         * Optional. A string that describes the quality of the value. Accepts substitution templates. Must be `GOOD` , `BAD` , or `UNCERTAIN` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-quality
         */
        readonly quality?: string;
        /**
         * The asset property value timestamp.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-timestamp
         */
        readonly timestamp: CfnTopicRule.AssetPropertyTimestampProperty | cdk.IResolvable;
        /**
         * The value of the asset property.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvalue.html#cfn-iot-topicrule-assetpropertyvalue-value
         */
        readonly value: CfnTopicRule.AssetPropertyVariantProperty | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Contains an asset property value (of a single type).
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html
     */
    interface AssetPropertyVariantProperty {
        /**
         * Optional. A string that contains the boolean value ( `true` or `false` ) of the value entry. Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-booleanvalue
         */
        readonly booleanValue?: string;
        /**
         * Optional. A string that contains the double value of the value entry. Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-doublevalue
         */
        readonly doubleValue?: string;
        /**
         * Optional. A string that contains the integer value of the value entry. Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-integervalue
         */
        readonly integerValue?: string;
        /**
         * Optional. The string value of the value entry. Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-assetpropertyvariant.html#cfn-iot-topicrule-assetpropertyvariant-stringvalue
         */
        readonly stringValue?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that updates a CloudWatch alarm.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html
     */
    interface CloudwatchAlarmActionProperty {
        /**
         * The CloudWatch alarm name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-alarmname
         */
        readonly alarmName: string;
        /**
         * The IAM role that allows access to the CloudWatch alarm.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The reason for the alarm change.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statereason
         */
        readonly stateReason: string;
        /**
         * The value of the alarm state. Acceptable values are: OK, ALARM, INSUFFICIENT_DATA.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchalarmaction.html#cfn-iot-topicrule-cloudwatchalarmaction-statevalue
         */
        readonly stateValue: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that updates a CloudWatch log.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html
     */
    interface CloudwatchLogsActionProperty {
        /**
         * The CloudWatch log name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-loggroupname
         */
        readonly logGroupName: string;
        /**
         * The IAM role that allows access to the CloudWatch log.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchlogsaction.html#cfn-iot-topicrule-cloudwatchlogsaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that captures a CloudWatch metric.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html
     */
    interface CloudwatchMetricActionProperty {
        /**
         * The CloudWatch metric name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricname
         */
        readonly metricName: string;
        /**
         * The CloudWatch metric namespace name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricnamespace
         */
        readonly metricNamespace: string;
        /**
         * An optional [Unix timestamp](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#about_timestamp) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metrictimestamp
         */
        readonly metricTimestamp?: string;
        /**
         * The [metric unit](https://docs.aws.amazon.com/AmazonCloudWatch/latest/DeveloperGuide/cloudwatch_concepts.html#Unit) supported by CloudWatch.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricunit
         */
        readonly metricUnit: string;
        /**
         * The CloudWatch metric value.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-metricvalue
         */
        readonly metricValue: string;
        /**
         * The IAM role that allows access to the CloudWatch metric.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-cloudwatchmetricaction.html#cfn-iot-topicrule-cloudwatchmetricaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to write to a DynamoDB table.
     *
     * The `tableName` , `hashKeyField` , and `rangeKeyField` values must match the values used when you created the table.
     *
     * The `hashKeyValue` and `rangeKeyvalue` fields use a substitution template syntax. These templates provide data at runtime. The syntax is as follows: ${ *sql-expression* }.
     *
     * You can specify any valid expression in a WHERE or SELECT clause, including JSON properties, comparisons, calculations, and functions. For example, the following field uses the third level of the topic:
     *
     * `"hashKeyValue": "${topic(3)}"`
     *
     * The following field uses the timestamp:
     *
     * `"rangeKeyValue": "${timestamp()}"`
     *
     * For more information, see [DynamoDBv2 Action](https://docs.aws.amazon.com/iot/latest/developerguide/iot-rule-actions.html) in the *AWS IoT Developer Guide* .
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html
     */
    interface DynamoDBActionProperty {
        /**
         * The hash key name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyfield
         */
        readonly hashKeyField: string;
        /**
         * The hash key type. Valid values are "STRING" or "NUMBER"
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeytype
         */
        readonly hashKeyType?: string;
        /**
         * The hash key value.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-hashkeyvalue
         */
        readonly hashKeyValue: string;
        /**
         * The action payload. This name can be customized.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-payloadfield
         */
        readonly payloadField?: string;
        /**
         * The range key name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyfield
         */
        readonly rangeKeyField?: string;
        /**
         * The range key type. Valid values are "STRING" or "NUMBER"
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeytype
         */
        readonly rangeKeyType?: string;
        /**
         * The range key value.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rangekeyvalue
         */
        readonly rangeKeyValue?: string;
        /**
         * The ARN of the IAM role that grants access to the DynamoDB table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The name of the DynamoDB table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbaction.html#cfn-iot-topicrule-dynamodbaction-tablename
         */
        readonly tableName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to write to a DynamoDB table.
     *
     * This DynamoDB action writes each attribute in the message payload into it's own column in the DynamoDB table.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html
     */
    interface DynamoDBv2ActionProperty {
        /**
         * Specifies the DynamoDB table to which the message data will be written. For example:
         *
         * `{ "dynamoDBv2": { "roleArn": "aws:iam:12341251:my-role" "putItem": { "tableName": "my-table" } } }`
         *
         * Each attribute in the message payload will be written to a separate column in the DynamoDB database.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-putitem
         */
        readonly putItem?: CfnTopicRule.PutItemInputProperty | cdk.IResolvable;
        /**
         * The ARN of the IAM role that grants access to the DynamoDB table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-dynamodbv2action.html#cfn-iot-topicrule-dynamodbv2action-rolearn
         */
        readonly roleArn?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that writes data to an Amazon OpenSearch Service domain.
     *
     * > The `Elasticsearch` action can only be used by existing rule actions. To create a new rule action or to update an existing rule action, use the `OpenSearch` rule action instead. For more information, see [OpenSearchAction](https://docs.aws.amazon.com//iot/latest/apireference/API_OpenSearchAction.html) .
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html
     */
    interface ElasticsearchActionProperty {
        /**
         * The endpoint of your OpenSearch domain.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-endpoint
         */
        readonly endpoint: string;
        /**
         * The unique identifier for the document you are storing.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-id
         */
        readonly id: string;
        /**
         * The index where you want to store your data.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-index
         */
        readonly index: string;
        /**
         * The IAM role ARN that has access to OpenSearch.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The type of document you are storing.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-elasticsearchaction.html#cfn-iot-topicrule-elasticsearchaction-type
         */
        readonly type: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that writes data to an Amazon Kinesis Firehose stream.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html
     */
    interface FirehoseActionProperty {
        /**
         * Whether to deliver the Kinesis Data Firehose stream as a batch by using [`PutRecordBatch`](https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html) . The default value is `false` .
         *
         * When `batchMode` is `true` and the rule's SQL statement evaluates to an Array, each Array element forms one record in the [`PutRecordBatch`](https://docs.aws.amazon.com/firehose/latest/APIReference/API_PutRecordBatch.html) request. The resulting array can't have more than 500 records.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-batchmode
         */
        readonly batchMode?: boolean | cdk.IResolvable;
        /**
         * The delivery stream name.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-deliverystreamname
         */
        readonly deliveryStreamName: string;
        /**
         * The IAM role that grants access to the Amazon Kinesis Firehose stream.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-rolearn
         */
        readonly roleArn: string;
        /**
         * A character separator that will be used to separate records written to the Firehose stream. Valid values are: '\n' (newline), '\t' (tab), '\r\n' (Windows newline), ',' (comma).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-firehoseaction.html#cfn-iot-topicrule-firehoseaction-separator
         */
        readonly separator?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Send data to an HTTPS endpoint.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html
     */
    interface HttpActionProperty {
        /**
         * The authentication method to use when sending data to an HTTPS endpoint.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-auth
         */
        readonly auth?: CfnTopicRule.HttpAuthorizationProperty | cdk.IResolvable;
        /**
         * The URL to which AWS IoT sends a confirmation message. The value of the confirmation URL must be a prefix of the endpoint URL. If you do not specify a confirmation URL AWS IoT uses the endpoint URL as the confirmation URL. If you use substitution templates in the confirmationUrl, you must create and enable topic rule destinations that match each possible value of the substitution template before traffic is allowed to your endpoint URL.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-confirmationurl
         */
        readonly confirmationUrl?: string;
        /**
         * The HTTP headers to send with the message data.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-headers
         */
        readonly headers?: Array<CfnTopicRule.HttpActionHeaderProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The endpoint URL. If substitution templates are used in the URL, you must also specify a `confirmationUrl` . If this is a new destination, a new `TopicRuleDestination` is created if possible.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpaction.html#cfn-iot-topicrule-httpaction-url
         */
        readonly url: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * The HTTP action header.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html
     */
    interface HttpActionHeaderProperty {
        /**
         * The HTTP header key.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-key
         */
        readonly key: string;
        /**
         * The HTTP header value. Substitution templates are supported.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpactionheader.html#cfn-iot-topicrule-httpactionheader-value
         */
        readonly value: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * The authorization method used to send messages.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html
     */
    interface HttpAuthorizationProperty {
        /**
         * Use Sig V4 authorization. For more information, see [Signature Version 4 Signing Process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-httpauthorization.html#cfn-iot-topicrule-httpauthorization-sigv4
         */
        readonly sigv4?: CfnTopicRule.SigV4AuthorizationProperty | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Sends message data to an AWS IoT Analytics channel.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html
     */
    interface IotAnalyticsActionProperty {
        /**
         * Whether to process the action as a batch. The default value is `false` .
         *
         * When `batchMode` is `true` and the rule SQL statement evaluates to an Array, each Array element is delivered as a separate message when passed by [`BatchPutMessage`](https://docs.aws.amazon.com/iotanalytics/latest/APIReference/API_BatchPutMessage.html) The resulting array can't have more than 100 messages.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-batchmode
         */
        readonly batchMode?: boolean | cdk.IResolvable;
        /**
         * The name of the IoT Analytics channel to which message data will be sent.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-channelname
         */
        readonly channelName: string;
        /**
         * The ARN of the role which has a policy that grants IoT Analytics permission to send message data via IoT Analytics (iotanalytics:BatchPutMessage).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotanalyticsaction.html#cfn-iot-topicrule-iotanalyticsaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Sends an input to an AWS IoT Events detector.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html
     */
    interface IotEventsActionProperty {
        /**
         * Whether to process the event actions as a batch. The default value is `false` .
         *
         * When `batchMode` is `true` , you can't specify a `messageId` .
         *
         * When `batchMode` is `true` and the rule SQL statement evaluates to an Array, each Array element is treated as a separate message when Events by calling [`BatchPutMessage`](https://docs.aws.amazon.com/iotevents/latest/apireference/API_iotevents-data_BatchPutMessage.html) . The resulting array can't have more than 10 messages.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-batchmode
         */
        readonly batchMode?: boolean | cdk.IResolvable;
        /**
         * The name of the AWS IoT Events input.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-inputname
         */
        readonly inputName: string;
        /**
         * The ID of the message. The default `messageId` is a new UUID value.
         *
         * When `batchMode` is `true` , you can't specify a `messageId` --a new UUID value will be assigned.
         *
         * Assign a value to this property to ensure that only one input (message) with a given `messageId` will be processed by an AWS IoT Events detector.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-messageid
         */
        readonly messageId?: string;
        /**
         * The ARN of the role that grants AWS IoT permission to send an input to an AWS IoT Events detector. ("Action":"iotevents:BatchPutMessage").
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-ioteventsaction.html#cfn-iot-topicrule-ioteventsaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to send data from an MQTT message that triggered the rule to AWS IoT SiteWise asset properties.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html
     */
    interface IotSiteWiseActionProperty {
        /**
         * A list of asset property value entries.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-putassetpropertyvalueentries
         */
        readonly putAssetPropertyValueEntries: Array<CfnTopicRule.PutAssetPropertyValueEntryProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The ARN of the role that grants AWS IoT permission to send an asset property value to AWS IoT SiteWise. ( `"Action": "iotsitewise:BatchPutAssetPropertyValue"` ). The trust policy can restrict access to specific asset hierarchy paths.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-iotsitewiseaction.html#cfn-iot-topicrule-iotsitewiseaction-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Send messages to an Amazon Managed Streaming for Apache Kafka (Amazon MSK) or self-managed Apache Kafka cluster.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html
     */
    interface KafkaActionProperty {
        /**
         * Properties of the Apache Kafka producer client.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-clientproperties
         */
        readonly clientProperties: {
            [key: string]: (string);
        } | cdk.IResolvable;
        /**
         * The ARN of Kafka action's VPC `TopicRuleDestination` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-destinationarn
         */
        readonly destinationArn: string;
        /**
         * The Kafka message key.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-key
         */
        readonly key?: string;
        /**
         * The Kafka message partition.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-partition
         */
        readonly partition?: string;
        /**
         * The Kafka topic for messages to be sent to the Kafka broker.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kafkaaction.html#cfn-iot-topicrule-kafkaaction-topic
         */
        readonly topic: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to write data to an Amazon Kinesis stream.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html
     */
    interface KinesisActionProperty {
        /**
         * The partition key.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-partitionkey
         */
        readonly partitionKey?: string;
        /**
         * The ARN of the IAM role that grants access to the Amazon Kinesis stream.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The name of the Amazon Kinesis stream.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-kinesisaction.html#cfn-iot-topicrule-kinesisaction-streamname
         */
        readonly streamName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to invoke a Lambda function.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html
     */
    interface LambdaActionProperty {
        /**
         * The ARN of the Lambda function.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-lambdaaction.html#cfn-iot-topicrule-lambdaaction-functionarn
         */
        readonly functionArn?: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html
     */
    interface LocationActionProperty {
        /**
         * `CfnTopicRule.LocationActionProperty.DeviceId`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-deviceid
         */
        readonly deviceId: string;
        /**
         * `CfnTopicRule.LocationActionProperty.Latitude`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-latitude
         */
        readonly latitude: string;
        /**
         * `CfnTopicRule.LocationActionProperty.Longitude`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-longitude
         */
        readonly longitude: string;
        /**
         * `CfnTopicRule.LocationActionProperty.RoleArn`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-rolearn
         */
        readonly roleArn: string;
        /**
         * `CfnTopicRule.LocationActionProperty.Timestamp`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-timestamp
         */
        readonly timestamp?: Date | cdk.IResolvable;
        /**
         * `CfnTopicRule.LocationActionProperty.TrackerName`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-locationaction.html#cfn-iot-topicrule-locationaction-trackername
         */
        readonly trackerName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that writes data to an Amazon OpenSearch Service domain.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html
     */
    interface OpenSearchActionProperty {
        /**
         * The endpoint of your OpenSearch domain.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-endpoint
         */
        readonly endpoint: string;
        /**
         * The unique identifier for the document you are storing.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-id
         */
        readonly id: string;
        /**
         * The OpenSearch index where you want to store your data.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-index
         */
        readonly index: string;
        /**
         * The IAM role ARN that has access to OpenSearch.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The type of document you are storing.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-opensearchaction.html#cfn-iot-topicrule-opensearchaction-type
         */
        readonly type: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * An asset property value entry containing the following information.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html
     */
    interface PutAssetPropertyValueEntryProperty {
        /**
         * The ID of the AWS IoT SiteWise asset. You must specify either a `propertyAlias` or both an `aliasId` and a `propertyId` . Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-assetid
         */
        readonly assetId?: string;
        /**
         * Optional. A unique identifier for this entry that you can define to better track which message caused an error in case of failure. Accepts substitution templates. Defaults to a new UUID.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-entryid
         */
        readonly entryId?: string;
        /**
         * The name of the property alias associated with your asset property. You must specify either a `propertyAlias` or both an `aliasId` and a `propertyId` . Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyalias
         */
        readonly propertyAlias?: string;
        /**
         * The ID of the asset's property. You must specify either a `propertyAlias` or both an `aliasId` and a `propertyId` . Accepts substitution templates.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyid
         */
        readonly propertyId?: string;
        /**
         * A list of property values to insert that each contain timestamp, quality, and value (TQV) information.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putassetpropertyvalueentry.html#cfn-iot-topicrule-putassetpropertyvalueentry-propertyvalues
         */
        readonly propertyValues: Array<CfnTopicRule.AssetPropertyValueProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * The input for the DynamoActionVS action that specifies the DynamoDB table to which the message data will be written.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html
     */
    interface PutItemInputProperty {
        /**
         * The table where the message data will be written.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-putiteminput.html#cfn-iot-topicrule-putiteminput-tablename
         */
        readonly tableName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to republish to another topic.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html
     */
    interface RepublishActionProperty {
        /**
         * The Quality of Service (QoS) level to use when republishing messages. The default value is 0.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-qos
         */
        readonly qos?: number;
        /**
         * The ARN of the IAM role that grants access.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The name of the MQTT topic.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-republishaction.html#cfn-iot-topicrule-republishaction-topic
         */
        readonly topic: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to write data to an Amazon S3 bucket.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html
     */
    interface S3ActionProperty {
        /**
         * The Amazon S3 bucket.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-bucketname
         */
        readonly bucketName: string;
        /**
         * The Amazon S3 canned ACL that controls access to the object identified by the object key. For more information, see [S3 canned ACLs](https://docs.aws.amazon.com/AmazonS3/latest/dev/acl-overview.html#canned-acl) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-cannedacl
         */
        readonly cannedAcl?: string;
        /**
         * The object key. For more information, see [Actions, resources, and condition keys for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/dev/list_amazons3.html) .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-key
         */
        readonly key: string;
        /**
         * The ARN of the IAM role that grants access.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-s3action.html#cfn-iot-topicrule-s3action-rolearn
         */
        readonly roleArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * For more information, see [Signature Version 4 signing process](https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html) .
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html
     */
    interface SigV4AuthorizationProperty {
        /**
         * The ARN of the signing role.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-rolearn
         */
        readonly roleArn: string;
        /**
         * The service name to use while signing with Sig V4.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-servicename
         */
        readonly serviceName: string;
        /**
         * The signing region.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sigv4authorization.html#cfn-iot-topicrule-sigv4authorization-signingregion
         */
        readonly signingRegion: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to publish to an Amazon SNS topic.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html
     */
    interface SnsActionProperty {
        /**
         * (Optional) The message format of the message to publish. Accepted values are "JSON" and "RAW". The default value of the attribute is "RAW". SNS uses this setting to determine if the payload should be parsed and relevant platform-specific bits of the payload should be extracted. For more information, see [Amazon SNS Message and JSON Formats](https://docs.aws.amazon.com/sns/latest/dg/json-formats.html) in the *Amazon Simple Notification Service Developer Guide* .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-messageformat
         */
        readonly messageFormat?: string;
        /**
         * The ARN of the IAM role that grants access.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The ARN of the SNS topic.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-snsaction.html#cfn-iot-topicrule-snsaction-targetarn
         */
        readonly targetArn: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action to publish data to an Amazon SQS queue.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html
     */
    interface SqsActionProperty {
        /**
         * The URL of the Amazon SQS queue.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-queueurl
         */
        readonly queueUrl: string;
        /**
         * The ARN of the IAM role that grants access.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-rolearn
         */
        readonly roleArn: string;
        /**
         * Specifies whether to use Base64 encoding.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-sqsaction.html#cfn-iot-topicrule-sqsaction-usebase64
         */
        readonly useBase64?: boolean | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Starts execution of a Step Functions state machine.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html
     */
    interface StepFunctionsActionProperty {
        /**
         * (Optional) A name will be given to the state machine execution consisting of this prefix followed by a UUID. Step Functions automatically creates a unique name for each state machine execution if one is not provided.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-executionnameprefix
         */
        readonly executionNamePrefix?: string;
        /**
         * The ARN of the role that grants IoT permission to start execution of a state machine ("Action":"states:StartExecution").
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The name of the Step Functions state machine whose execution will be started.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-stepfunctionsaction.html#cfn-iot-topicrule-stepfunctionsaction-statemachinename
         */
        readonly stateMachineName: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     *
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html
     */
    interface TimestampProperty {
        /**
         * `CfnTopicRule.TimestampProperty.Unit`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html#cfn-iot-topicrule-timestamp-unit
         */
        readonly unit?: string;
        /**
         * `CfnTopicRule.TimestampProperty.Value`
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestamp.html#cfn-iot-topicrule-timestamp-value
         */
        readonly value: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes an action that writes records into an Amazon Timestream table.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html
     */
    interface TimestreamActionProperty {
        /**
         * The name of an Amazon Timestream database that has the table to write records into.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-databasename
         */
        readonly databaseName: string;
        /**
         * Metadata attributes of the time series that are written in each measure record.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-dimensions
         */
        readonly dimensions: Array<CfnTopicRule.TimestreamDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The Amazon Resource Name (ARN) of the role that grants AWS IoT permission to write to the Timestream database table.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-rolearn
         */
        readonly roleArn: string;
        /**
         * The table where the message data will be written.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-tablename
         */
        readonly tableName: string;
        /**
         * The value to use for the entry's timestamp. If blank, the time that the entry was processed is used.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamaction.html#cfn-iot-topicrule-timestreamaction-timestamp
         */
        readonly timestamp?: CfnTopicRule.TimestreamTimestampProperty | cdk.IResolvable;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Metadata attributes of the time series that are written in each measure record.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html
     */
    interface TimestreamDimensionProperty {
        /**
         * The metadata dimension name. This is the name of the column in the Amazon Timestream database table record.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html#cfn-iot-topicrule-timestreamdimension-name
         */
        readonly name: string;
        /**
         * The value to write in this column of the database record.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamdimension.html#cfn-iot-topicrule-timestreamdimension-value
         */
        readonly value: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * The value to use for the entry's timestamp. If blank, the time that the entry was processed is used.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html
     */
    interface TimestreamTimestampProperty {
        /**
         * The precision of the timestamp value that results from the expression described in `value` .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html#cfn-iot-topicrule-timestreamtimestamp-unit
         */
        readonly unit: string;
        /**
         * An expression that returns a long epoch time value.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-timestreamtimestamp.html#cfn-iot-topicrule-timestreamtimestamp-value
         */
        readonly value: string;
    }
}
export declare namespace CfnTopicRule {
    /**
     * Describes a rule.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html
     */
    interface TopicRulePayloadProperty {
        /**
         * The actions associated with the rule.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-actions
         */
        readonly actions: Array<CfnTopicRule.ActionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * The version of the SQL rules engine to use when evaluating the rule.
         *
         * The default value is 2015-10-08.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-awsiotsqlversion
         */
        readonly awsIotSqlVersion?: string;
        /**
         * The description of the rule.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-description
         */
        readonly description?: string;
        /**
         * The action to take when an error occurs.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-erroraction
         */
        readonly errorAction?: CfnTopicRule.ActionProperty | cdk.IResolvable;
        /**
         * Specifies whether the rule is disabled.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-ruledisabled
         */
        readonly ruleDisabled?: boolean | cdk.IResolvable;
        /**
         * The SQL statement used to query the topic. For more information, see [AWS IoT SQL Reference](https://docs.aws.amazon.com/iot/latest/developerguide/iot-sql-reference.html) in the *AWS IoT Developer Guide* .
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicrule-topicrulepayload.html#cfn-iot-topicrule-topicrulepayload-sql
         */
        readonly sql: string;
    }
}
/**
 * Properties for defining a `CfnTopicRuleDestination`
 *
 * @struct
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html
 */
export interface CfnTopicRuleDestinationProps {
    /**
     * Properties of the HTTP URL.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-httpurlproperties
     */
    readonly httpUrlProperties?: CfnTopicRuleDestination.HttpUrlDestinationSummaryProperty | cdk.IResolvable;
    /**
     * - **IN_PROGRESS** - A topic rule destination was created but has not been confirmed. You can set status to `IN_PROGRESS` by calling `UpdateTopicRuleDestination` . Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     * - **ENABLED** - Confirmation was completed, and traffic to this destination is allowed. You can set status to `DISABLED` by calling `UpdateTopicRuleDestination` .
     * - **DISABLED** - Confirmation was completed, and traffic to this destination is not allowed. You can set status to `ENABLED` by calling `UpdateTopicRuleDestination` .
     * - **ERROR** - Confirmation could not be completed; for example, if the confirmation timed out. You can call `GetTopicRuleDestination` for details about the error. You can set status to `IN_PROGRESS` by calling `UpdateTopicRuleDestination` . Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-status
     */
    readonly status?: string;
    /**
     * Properties of the virtual private cloud (VPC) connection.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-vpcproperties
     */
    readonly vpcProperties?: CfnTopicRuleDestination.VpcDestinationPropertiesProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::IoT::TopicRuleDestination`
 *
 * A topic rule destination.
 *
 * @cloudformationResource AWS::IoT::TopicRuleDestination
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html
 */
export declare class CfnTopicRuleDestination extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoT::TopicRuleDestination";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnTopicRuleDestination;
    /**
     * The topic rule destination URL.
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * Additional details or reason why the topic rule destination is in the current status.
     * @cloudformationAttribute StatusReason
     */
    readonly attrStatusReason: string;
    /**
     * Properties of the HTTP URL.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-httpurlproperties
     */
    httpUrlProperties: CfnTopicRuleDestination.HttpUrlDestinationSummaryProperty | cdk.IResolvable | undefined;
    /**
     * - **IN_PROGRESS** - A topic rule destination was created but has not been confirmed. You can set status to `IN_PROGRESS` by calling `UpdateTopicRuleDestination` . Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     * - **ENABLED** - Confirmation was completed, and traffic to this destination is allowed. You can set status to `DISABLED` by calling `UpdateTopicRuleDestination` .
     * - **DISABLED** - Confirmation was completed, and traffic to this destination is not allowed. You can set status to `ENABLED` by calling `UpdateTopicRuleDestination` .
     * - **ERROR** - Confirmation could not be completed; for example, if the confirmation timed out. You can call `GetTopicRuleDestination` for details about the error. You can set status to `IN_PROGRESS` by calling `UpdateTopicRuleDestination` . Calling `UpdateTopicRuleDestination` causes a new confirmation challenge to be sent to your confirmation endpoint.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-status
     */
    status: string | undefined;
    /**
     * Properties of the virtual private cloud (VPC) connection.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-topicruledestination.html#cfn-iot-topicruledestination-vpcproperties
     */
    vpcProperties: CfnTopicRuleDestination.VpcDestinationPropertiesProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::IoT::TopicRuleDestination`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnTopicRuleDestinationProps);
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector: cdk.TreeInspector): void;
    protected get cfnProperties(): {
        [key: string]: any;
    };
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
export declare namespace CfnTopicRuleDestination {
    /**
     * HTTP URL destination properties.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-httpurldestinationsummary.html
     */
    interface HttpUrlDestinationSummaryProperty {
        /**
         * The URL used to confirm the HTTP topic rule destination URL.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-httpurldestinationsummary.html#cfn-iot-topicruledestination-httpurldestinationsummary-confirmationurl
         */
        readonly confirmationUrl?: string;
    }
}
export declare namespace CfnTopicRuleDestination {
    /**
     * The properties of a virtual private cloud (VPC) destination.
     *
     * @struct
     * @stability external
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-vpcdestinationproperties.html
     */
    interface VpcDestinationPropertiesProperty {
        /**
         * The ARN of a role that has permission to create and attach to elastic network interfaces (ENIs).
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-vpcdestinationproperties.html#cfn-iot-topicruledestination-vpcdestinationproperties-rolearn
         */
        readonly roleArn?: string;
        /**
         * The security groups of the VPC destination.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-vpcdestinationproperties.html#cfn-iot-topicruledestination-vpcdestinationproperties-securitygroups
         */
        readonly securityGroups?: string[];
        /**
         * The subnet IDs of the VPC destination.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-vpcdestinationproperties.html#cfn-iot-topicruledestination-vpcdestinationproperties-subnetids
         */
        readonly subnetIds?: string[];
        /**
         * The ID of the VPC.
         *
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iot-topicruledestination-vpcdestinationproperties.html#cfn-iot-topicruledestination-vpcdestinationproperties-vpcid
         */
        readonly vpcId?: string;
    }
}
