# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'MachineMountArgs',
    'MachineServiceArgs',
    'MachineServicePortArgs',
]

@pulumi.input_type
class MachineMountArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 volume: pulumi.Input[str]):
        """
        :param pulumi.Input[str] path: Path for volume to be mounted on vm, ex: `/data`
        :param pulumi.Input[str] volume: ID of volume
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "volume", volume)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Path for volume to be mounted on vm, ex: `/data`
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def volume(self) -> pulumi.Input[str]:
        """
        ID of volume
        """
        return pulumi.get(self, "volume")

    @volume.setter
    def volume(self, value: pulumi.Input[str]):
        pulumi.set(self, "volume", value)


@pulumi.input_type
class MachineServiceArgs:
    def __init__(__self__, *,
                 internal_port: pulumi.Input[int],
                 ports: pulumi.Input[Sequence[pulumi.Input['MachineServicePortArgs']]],
                 protocol: pulumi.Input[str]):
        """
        :param pulumi.Input[int] internal_port: Port the machine listens on
        :param pulumi.Input[Sequence[pulumi.Input['MachineServicePortArgs']]] ports: How the port is exposed
        :param pulumi.Input[str] protocol: `udp` or `tcp`
        """
        pulumi.set(__self__, "internal_port", internal_port)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="internalPort")
    def internal_port(self) -> pulumi.Input[int]:
        """
        Port the machine listens on
        """
        return pulumi.get(self, "internal_port")

    @internal_port.setter
    def internal_port(self, value: pulumi.Input[int]):
        pulumi.set(self, "internal_port", value)

    @property
    @pulumi.getter
    def ports(self) -> pulumi.Input[Sequence[pulumi.Input['MachineServicePortArgs']]]:
        """
        How the port is exposed
        """
        return pulumi.get(self, "ports")

    @ports.setter
    def ports(self, value: pulumi.Input[Sequence[pulumi.Input['MachineServicePortArgs']]]):
        pulumi.set(self, "ports", value)

    @property
    @pulumi.getter
    def protocol(self) -> pulumi.Input[str]:
        """
        `udp` or `tcp`
        """
        return pulumi.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: pulumi.Input[str]):
        pulumi.set(self, "protocol", value)


@pulumi.input_type
class MachineServicePortArgs:
    def __init__(__self__, *,
                 port: pulumi.Input[int],
                 force_https: Optional[pulumi.Input[bool]] = None,
                 handlers: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        :param pulumi.Input[int] port: Mapped external port number
        :param pulumi.Input[bool] force_https: Automatically redirect to HTTPS on "http" handler
        :param pulumi.Input[Sequence[pulumi.Input[str]]] handlers: How the edge should process requests; ex empty, or `tls` to attach app's certificate
        """
        pulumi.set(__self__, "port", port)
        if force_https is not None:
            pulumi.set(__self__, "force_https", force_https)
        if handlers is not None:
            pulumi.set(__self__, "handlers", handlers)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        """
        Mapped external port number
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="forceHttps")
    def force_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Automatically redirect to HTTPS on "http" handler
        """
        return pulumi.get(self, "force_https")

    @force_https.setter
    def force_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "force_https", value)

    @property
    @pulumi.getter
    def handlers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        How the edge should process requests; ex empty, or `tls` to attach app's certificate
        """
        return pulumi.get(self, "handlers")

    @handlers.setter
    def handlers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "handlers", value)


